@extends('layouts.factor-master')

@section('content')
<?php
    $report = customeReportNew('account_show');
    $_date= !in_array('date', $report);
    $_description= !in_array('description', $report);
    $_user= !in_array('user', $report);
    $_unit= !in_array('unit', $report);
    $_qut_in= !in_array('qut_in', $report);
    $_qut_out= !in_array('qut_out', $report);
    $_rate= !in_array('rate', $report);
    $_balance= !in_array('balance', $report);
    $_balance_base= !in_array('balance_base', $report);
    $_total= !in_array('total', $report);
    $_amount_base = !in_array('amount_base', $report);
    $_account_name = !in_array('account_name', $report);
    $_bank = !in_array('bank', $report);
    $_type = !in_array('type', $report);
    $_number = !in_array('number', $report);
    $_category = !in_array('category', $report);

    
    $report_percent = customeReportNewPercent('account_show');
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_unit_percent= (array_key_exists('unit___percent', $report_percent))?$report_percent['unit___percent']:null;
    $_qut_in_percent= (array_key_exists('qut_in___percent', $report_percent))?$report_percent['qut_in___percent']:null;
    $_qut_out_percent= (array_key_exists('qut_out___percent', $report_percent))?$report_percent['qut_out___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_balance_percent= (array_key_exists('balance___percent', $report_percent))?$report_percent['balance___percent']:null;
    $_balance_base_percent= (array_key_exists('balance_base___percent', $report_percent))?$report_percent['balance_base___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_amount_base_percent= (array_key_exists('amount_base___percent', $report_percent))?$report_percent['amount_base___percent']:null;
    $_account_name_percent= (array_key_exists('account_name___percent', $report_percent))?$report_percent['account_name___percent']:null;
    $_bank_percent= (array_key_exists('bank___percent', $report_percent))?$report_percent['bank___percent']:null;
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_category_percent= (array_key_exists('category___percent', $report_percent))?$report_percent['category___percent']:null;
    // dd($_amount_base_percent);
 
if(getAccountTransaction() ==null || getAccountTransaction()=="in_out")
{
  $in_tr  = __('layout.QutIn');
  $out_tr = __('layout.QutOut');
}
elseif(getAccountTransaction() =="dr_cr"){
  //Income
  if($info->type =="income" || $info->type =="otherIncome")
  {
    $in_tr = __('layout.Cr');
    $out_tr = __('layout.Dr');
  }
  
  //Expense
  if($info->type =="expense" || $info->type =="otherExpense"|| $info->type =="costOfGoodSold")
  {
    $in_tr = __('layout.Dr');
    $out_tr = __('layout.Cr');
  }
  //Asset
  if($info->type =="otherCurrentAsset" || $info->type =="bank"|| $info->type =="accountsReceivable"|| $info->type =="asset"|| $info->type =="otherAsset")
  {
    $in_tr = __('layout.Dr');
    $out_tr = __('layout.Cr');
  }
  
  //Liabilities
  if($info->type =="otherCurrentLiability" || $info->type =="longTermLiability"|| $info->type =="accountsPayable"|| $info->type =="liability"|| $info->type =="CreditCard")
  {
    $in_tr = __('layout.Cr');
    $out_tr = __('layout.Dr');
  }
  
  //Capital
  if($info->type =="equity" )
    {
      $in_tr = __('layout.Cr');
      $out_tr = __('layout.Dr');
    }

}

?>


<h3 class="table-caption" style="text-align: center;">@lang('layout.ChartOfAccountsReport')</h3>
<table  class="main-table">
 @if($info && $info !=[])
 <tr>
  <td>
    <span>@lang('layout.AccountNumber')</span> : <span>{{$info->number}}</span>
  </td>
  <td>
    <span>@lang('layout.AccountName')</span> : <span>{{$info->name}}</span>
  </td>
  <td>
    <span>@lang('layout.AccountType')</span> : <span>{{$info->type}}</span>
  </td>
  <td>
    <span>@lang('layout.Currency')</span> : <span>{{$info->currency}}</span>
  </td>
  <td>
    <span>@lang('layout.Total')</span> : <span>{{myRound($total['currency_amount'])}}</span>
  </td>   
  <td>
    <span>@lang('layout.Total')</span> : <span>{{myRound($total['base_amount'])}}   {{getHomeCurrency()[getCurrencyType()]}}</span>
  </td> 

</tr>
<tr>
   @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
<tr>
   @if($accounts_details)
   <td colspan="2">
    <span>@lang('layout.StatementDetails')</span>: @if(!Str::is('type.*', __('type.'.$accounts_details))) {{__('type.'.$accounts_details)}} @else {{ $accounts_details }} @endif
  </td>
  @endif
</tr>
@endif
</table>

@if($beforeTotalAmount)
<br>
<table class="main-table">
  <tr class="mt">
    <td colspan="2">@lang('layout.PreviousBalance') </td>
  </tr>
  <tr class="">
    <td colspan="1">@lang('layout.Balance') </td>
    <td colspan="1">{{myRound($beforeTotalAmount)}} <span>{{$info->currency}}</span></td>
  </tr>
</table>
@endif

<br>

<table class="main-table">
 <thead>
 <tr class="bg">
 <td class="center"> @lang('layout.Record') </td>
 @if($_date)<td class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif> @lang('layout.Date')</td>@endif
 @if($_description)<td class="center"  @if($_description_percent) width="{{$_description_percent}}%" @endif > @lang('layout.Description')</td>@endif

 @if($_type)<td class="center"  @if($_type_percent) width="{{$_type_percent}}%" @endif> @lang('layout.Type')</td>@endif
 @if($_number)<td class="center"  @if($_number_percent) width="{{$_number_percent}}%" @endif> @lang('layout.Number')</td>@endif
 @if($_category)<td class="center"  @if($_category_percent) width="{{$_category_percent}}%" @endif> @lang('layout.Category')</td>@endif

 @if($_account_name)<td class="center"  @if($_account_name_percent) width="{{$_account_name_percent}}%" @endif> @lang('layout.Account')</td>@endif
 @if($_bank)<td class="center"  @if($_bank_percent) width="{{$_bank_percent}}%" @endif> @lang('layout.Bank')</td>@endif

 @if($_user)<td class="center"  @if($_user_percent) width="{{$_user_percent}}%" @endif> @lang('layout.User')</td>@endif
 @if($_unit)<td class="center"  @if($_unit_percent) width="{{$_unit_percent}}%" @endif> @lang('layout.Unit')</td>@endif
 @if($_qut_in)
  <td class="center"  @if($_qut_in_percent) width="{{$_qut_in_percent}}%" @endif> {{$in_tr}}</td>
 @endif
 @if($_qut_out)
  <td class="center"  @if($_qut_out_percent) width="{{$_qut_out_percent}}%" @endif> {{$out_tr}}</td>
 @endif

 @if($_rate)<td class="center"  @if($_rate_percent) width="{{$_rate_percent}}%" @endif> @lang('layout.Rate')</td>@endif
 @if(!$check_currency)
  @if($_balance)<td class="center"  @if($_balance_percent) width="{{$_balance_percent}}%" @endif> @lang('layout.Balance')</td>@endif
 @endif
 
 @if($_amount_base)
 <td class="center"  @if($_amount_base_percent) width="{{$_amount_base_percent}}%" @endif> @lang('layout.Amount'){{getHomeCurrency()[getCurrencyType()]}}</td>
  @endif
 @if($_balance_base)<td class="center"  @if($_balance_base_percent) width="{{$_balance_base_percent}}%" @endif> @lang('layout.Balance'){{getHomeCurrency()[getCurrencyType()]}}</td>@endif
</tr>
</thead>
<?php
$count = 0;
$balance=0;

// $balance1=0;
$balance1=($beforeTotalAmount)?$beforeTotalAmount:0;
$balance1Base=($beforeTotalAmountBase)?$beforeTotalAmountBase:0;
// dd($balance1,$balance1Base);
$tp=0;
$tn=0;

$tn_currency = 0;
$tp_currency = 0;

?>
@foreach($data AS $record)
<?php
if(systemConfig()[30] == 1){
  $balance+=$record['amount']/ $record['static_rate'] * $record['rate'];
}else{
  $balance+=$record['amount']/$record['rate'];
}


  $balance1+=$record['amount'];

  if(systemConfig()[30] == 1){
  $balance1Base+=$record['amount']/ $record['static_rate'] * $record['rate'];
}else{
    $balance1Base+=$record['amount']/$record['rate'];
  }


  if($record['amount']<0)
  {
    if(systemConfig()[30] == 1){
    $tn += $record['amount']/ $record['static_rate'] * $record['rate'];
  }else{
      $tn += $record['amount']/$record['rate'];
    }
  }

  if($record['amount']>0)
  {
    if(systemConfig()[30] == 1){
    $tp += $record['amount']/ $record['static_rate'] * $record['rate'];
  }else{
    $tp += $record['amount']/$record['rate'];
  }
  }


  //  total in currency
 
  if($record['amount']<0)
  {
    $tn_currency += $record['amount'];
  }

  if($record['amount']>0)
  {
    $tp_currency += $record['amount'];
  }

?>
<tr>
<td class="center">{{++$count}}</td>
@if($_date)<td class="center">{{convertDate($record['date'])}}</td>@endif
@if($_description)<td style="@if($_description_percent) text-align: justify @endif">
    {!! $record['description'] !!}
</td>@endif

@if($_type)<td class="center">@if($record['type']){{__('menu.'.$record['type'])}}@endif</td>@endif
@if($_number)<td class="center">{{$record['number']}}</td>@endif
@if($_category)<td class="center"> @if(!Str::is('type.*', __('type.'.$record['category']))) {{__('type.'.$record['category'])}} @else {{ $record['category'] }} @endif </td>@endif
@if($_account_name)<td class="center">{{$record['account']}}</td>@endif
@if($_bank)<td class="center">{{$record['account_name']}}</td>@endif

@if($_user)<td  style="text-align: center;">{{$record['name']}}</td>@endif
@if($_unit)<td class="center">{{$record['unit']}}</td>@endif
@if($_qut_in)<td class="center">
@if($record['amount']>0)
{{myRound($record['amount'])}}
@endif
</td>
@endif
@if($_qut_out)<td class="center">
  @if($record['amount']<0)
  {{myRound($record['amount'])}}
@endif
</td>
@endif
@if($_rate)<td class="center">{{myRound($record['rate'])}}</td>@endif
@if(!$check_currency)
  @if($_balance)<td class="center">{{myRound($balance1)}}</td>@endif
@endif
@if($_amount_base)
@if(systemConfig()[30] == 1)
<td class="center">{{myRound($record['amount']/ $record['static_rate'] * $record['rate'])}}</td>
@else 
<td class="center">{{myRound($record['amount']/$record['rate'])}}</td>
@endif
@endif
@if($_balance_base)<td class="center">{{myRound($balance1Base)}}</td>@endif
</tr>
@endforeach    
</table>

{{-- <span>@lang('layout.QutIn'): {{myRound($tp)}} 
@lang('layout.QutOut'): {{myRound($tn)}}
 </span>
 <span>
 {{getHomeCurrency()[getCurrencyType()]}}
 </span> --}} 
<br>

@if($_total)


@if($info->currency != getHomeCurrency()[getCurrencyType()])
<table class="main-table">
  <tr class="mt">
  <td colspan="2">{{$out_tr}} </td>
  <td colspan="2">{{$in_tr}} </td>
  <td colspan="2">@lang('layout.Balance') </td>


</tr>  <tr class="">
  <td colspan="2">{{myRound($tn_currency)}} <span>{{$info->currency}}</span> </td>  
  <td colspan="2">{{myRound($tp_currency)}} <span>{{$info->currency}}</span></td>
  <td colspan="2">{{myRound($balance1)}} <span>{{$info->currency}}</span></td>
  

</tr>
</table>
@endif
<br>
<table class="main-table">
  <tr class="mt">
  <td colspan="2">{{$out_tr}} </td>
  <td colspan="2">{{$in_tr}} </td>
  <td colspan="2">@lang('layout.Balance') </td>



</tr>  <tr class="">
  <td colspan="2">{{myRound($tn)}} <span>
 {{getHomeCurrency()[getCurrencyType()]}}
 </span></td>  
  <td colspan="2">{{myRound($tp)}}  
    <span>
 {{getHomeCurrency()[getCurrencyType()]}}
 </span> </td>  
 <td colspan="2">
      {{myRound($balance1Base)}}  
      <span>
      {{getHomeCurrency()[getCurrencyType()]}}
   </span> 
  </td>
</tr>
</table>

@if($TotalAmounts)
<br>
<table class="main-table">
  <tr class="mt">
    <td colspan="2">@lang('layout.Total') @lang('layout.Balance')</td>
  </tr>
  <tr class="">
    <td colspan="1">@lang('layout.Balance') </td>
    <td colspan="1">{{myRound($balance1)}} <span>{{$info->currency}}</span></td>
  </tr>
</table>
@endif

@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->



@endsection