@extends('layouts.app')
 
@section('content')
 <div id="print-modal">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'accoun_details'"
        @closed="closeModal">
        <div slot="body">
             <input type="hidden" name="id" value="{{$account->id}}"/>
             <input type="hidden" name="account_type" value="{{$account->type}}"/>

                <!----------------------------------------------
                ----Begin Report Body And Custome Report------- 
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop"> 
                            <ul class="nav nav-tabs"> 
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                        <div class="portlet light bordered">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.Type') </label>
                                                    <select name="types" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="in">@lang('layout.QutIn')</option>
                                                        <option value="out">@lang('layout.QutOut')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.StatementDetails') </label>
                                                    <select name="accounts_details" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="Payment">@lang('layout.Payment')</option>
                                                        <option value="Transfer">@lang('layout.TransferTo')</option>
                                                        <option value="Expense">@lang('menu.Expense')</option>
                                                        <option value="Deposit">@lang('layout.Deposit')</option>
                                                        <option value="Withdrawal">@lang('layout.Withdrawal')</option>
                                                        <option value="salary">@lang('layout.Salary')</option>
                                                        <option value="loan">@lang('layout.Loan')</option>
                                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                                        <option value="reward">@lang('layout.Reward')</option>
                                                        <option value="personalPayAndReceive">@lang('layout.PersonalPayAndReceive')</option>
                                                        <option value="Receive">@lang('layout.Recevies')</option>
                                                        <option value="Write Checks">@lang('menu.WriteChecks')</option>
                                                        <option value="Sales Receipt">@lang('menu.SaleReceipt')</option>
                                                        <option value="Fixed Asset">@lang('layout.FixAsset')</option>
                                                        <option value="send cheque">@lang('layout.Cheque')</option>
                                                        <option value="EXchange">@lang('menu.CurrencyExchange')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.ReportType') </label>
                                                    <select name="report_type" class="form-control">
                                                        <option value="">@lang('layout.Simple')</option>
                                                        <option value="details">@lang('layout.Details')</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="control-label"> @lang('layout.Date')</label>
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" name="from_date"
                                                                autocomplete="off">
                                                                
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" name="to_date"
                                                                autocomplete="off">
                                                               
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="account_show">

                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                             <!-- <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label> -->

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

        </div>
    </report-modal>
</div>



 
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.AccountInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead >
                    <tr>
                        <th>
                            <i class="fa fa-tasks"></i> @lang('layout.AccountNumber')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.AccountName')  
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.AccountType') 
                        </th>
                        @if($account->type == 'bank')
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.BankType') 
                        </th>
                        @endif
                        <th>
                            <i class="fa fa-user"></i> @lang('layout.CreatedBy')  
                        </th>
                        <th>

                            <i class="fa fa-clock-o"></i> @lang('layout.CreatedAt')  

                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.UpdatedAt')  
                        </th>
                        <th>
                            <i class="fa fa-money"></i> @lang('layout.Total')

                        </th>
                         <th>
                            <i class="fa fa-money"></i> @lang('layout.Total')  
                              <span>{{getHomeCurrency()['code']}}</span>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class="highlight"> 
                            {{ $account->number }}
                        </td>
                        <td class="hidden-xs"> {{ $account->name }}  </td>
                        <td class="hidden-xs"> {{ $account->type }}  </td>
                        @if($account->type == 'bank')
                        @if($account->bank_type)
                        <td class="hidden-xs"> {{ __('layout.'.$account->bank_type) }} </td>
                        @else
                        <td class="hidden-xs">  </td>
                        @endif
                        @endif
                        <td class="hidden-xs"> {{ $account->username }}  </td>
                        <td class="hidden-xs"> {{ convertDate($account->created_at) }}  </td>
                        <td class="hidden-xs"> {{ convertDate($account->updated_at) }}  </td>
                        <td> {{myRound($totalWithoutChange)}}</td> 
                        <td> {{myRound($total)}} </td> 
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered ">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.AccountTransactionList')</span>
                    </div>
                    <div class="tools">
                    </div> 
                    <div class="actions">
                      
                            <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                            </span>
                      
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="transaction">
                        <thead>
                            <tr>
                                <th>@lang('layout.Number')</th>
                                <th>@lang('layout.Remark')</th>
                                <th>@lang('layout.User')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Currency')</th>
                                <th>@lang('layout.Rate')</th>
                                <th>
                                    <i class="fa fa-shopping-cart"></i> @lang('layout.Total')  
                                <span>{{getHomeCurrency()['code']}}</span>
                                </th>
                                <th>@lang('layout.Date')</th>
                                <th>@lang('layout.Action')</th>
                            </tr>
                        </thead> 
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>

@endsection
@include('print.modal')
@push('scripts')

<script>
        var cust_rep = {!!customeReportNewData('account_show')!!};

    $(document).ready(function () { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

        $('#transaction').DataTable({

            ajax:'{{route("transaction.show",$account->id   )}}',
            order: [["{{orderByColumn()=='number'?0:7}}", "{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
            columns: [
                { data: 'id', name: 'transactions.id'},
                { data: 'remark', name: 'transactions.remark_en'},
                { data: 'name', name: 'users.name' },
                { data: 'amount', name: 'transactions.amount'},
                { data: 'unit', name: 'percent',searchable:false,orderable:false },
                { data: 'rate', name: 'rate'},
                { data: 'Total', name: 'Total',searchable:false,orderable:false },
                { data: 'date', name: 'transactions.date' },
                { data: 'page_route', name: 'page_route' },
        ]
        });

    });
  

  var vm =new Vue({

            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
                customReportData:
                [
                 
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'',column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.QutIn")', column_name: 'qut_in',checkedColumn:(cust_rep.qut_in)?'checked':'',column_percentage:(cust_rep.qut_in___percent)?cust_rep.qut_in___percent:''},
                 {Name: '@lang("layout.QutOut")', column_name: 'qut_out',checkedColumn:(cust_rep.qut_out)?'checked':'',column_percentage:(cust_rep.qut_out___percent)?cust_rep.qut_out___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Balance")', column_name: 'balance',checkedColumn:(cust_rep.balance)?'checked':'',column_percentage:(cust_rep.balance___percent)?cust_rep.balance___percent:''},
                 {Name: '@lang("layout.TotalMoblaq")', column_name: 'base_currency',checkedColumn:(cust_rep.base_currency)?'checked':'',column_percentage:(cust_rep.base_currency___percent)?cust_rep.base_currency___percent:''},
                 {Name: '@lang("layout.Balance") {{getHomeCurrency()["code"]}}', column_name: 'balance_base',checkedColumn:(cust_rep.balance_base)?'checked':'',column_percentage:(cust_rep.balance_base___percent)?cust_rep.balance_base___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.Amount")' + ' ' + '@lang("layout.BaseCurrency")' , column_name: 'amount_base',checkedColumn:(cust_rep.amount_base)?'checked':'',column_percentage:(cust_rep.amount_base___percent)?cust_rep.amount_base___percent:''},
                 {Name: '@lang("layout.AccountName")', column_name: 'account_name',checkedColumn:(cust_rep.account_name)?'checked':'' ,column_percentage:(cust_rep.account_name___percent)?cust_rep.account_name___percent:''},
                 {Name: '@lang("layout.Bank")', column_name: 'bank',checkedColumn:(cust_rep.bank)?'checked':'' ,column_percentage:(cust_rep.bank___percent)?cust_rep.bank___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'' ,column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'' ,column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'' ,column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
                 
                ],
                  cust_rep:cust_rep
            },
    
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
        });

    new Vue({
        el:'#anchore-modal',
        methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });
   

</script>


@endpush
