@extends('layouts.app')
@section('style')
<style type="text/css">
    .v-select .selected-tag {
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
        display: none !important;
    }
</style>
@endsection
@section('content')
<!-- BEGIN CONTENT -->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'chartofaccountlist'"
        @closed="closeModal">
        <div slot="body">
            <input type="hidden" name="type_id" :value="type_id" />
            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">

                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                            <div class="col-md-6">
                                                <div class="col-md-6">
                                                    <label class="control-label">@lang('layout.Currency') </label>
                                                    <select class="form-control" v-model="selected_currency">
                                                        <option v-for="curre in currencies" :value="curre">@{{ curre.code }}
                                                        </option>
                                                    </select>
                                                    <input type="hidden" name="currency"
                                                        v-bind:value="(selected_currency)?selected_currency.code:null" />
                                                </div>
                                                <div v-if="selected_currency" class="col-md-6">
                                                    <span v-if="selected_currency.code != code">
                                                            <label class="control-label">@lang('layout.Rate') </label>
                                                            <div class="input-group">
                                                                <input v-model="selected_currency.rate" class="form-control"
                                                                    name="currency_rate" type="number" step="any" min="0">
                                                                <span
                                                                    class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                    </span>
                                                </div>
                                            </div>
                                            <!-- begin accountClass account -->
                                            <div class="col-md-3">
                                                <label class="control-label">@lang('layout.Class')</label>
                                                <v-select label="name" :options="accountClass"
                                                    v-model="selected_accountClass"></v-select>
                                                <input type="hidden" name="class_id" v-validate="'required'"
                                                    data-vv-as="@lang('layout.Class')"
                                                    :value="(this.selected_accountClass==null)?null:selected_accountClass.id">
                                            </div>
                                            <div class="col-md-3">
                                                <label class="control-label ">@lang('layout.Type') </label>
                                                <select name="types" class="form-control">
                                                    <option value="">@lang('layout.Select')</option>
                                                    <option value="in">@lang('layout.QutIn')</option>
                                                    <option value="out">@lang('layout.QutOut')</option>
                                                </select>
                                            </div>
                                        </div>
                                        <!-- end accountClass account -->
                                        @if(getFinancialClass() =='true') 
                                        @permission('financialClass-list')
                                        <div class="col-md-3">
                                            <label class="control-label"> @lang('menu.FinancialClass')</label>
                                            <select name="financial_class_id" class="form-control" >
                                                <option value="">@lang('layout.SelectClass')</option>
                                                <option value="Unclassified">Unclassified</option>
                                                <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                            </select>
                                        </div>
                                        @endpermission
                                        @endif 

                                        <div class="col-md-3">
                                            <label class="control-label"> @lang('layout.BankType')</label>
                                            <select name="bank_type" id="bank_type_idd" class="form-control" v-model="bank_type" @click="get_by_bank_type">
                                                <option value=""> @lang('layout.Select') </option>
                                                <option value="Bank"> @lang('layout.Bank') </option>
                                                <option value="Box"> @lang('layout.Box') </option>
                                            </select>
                                        </div>

                                        {{-- <label class="control-label col-md-5">@lang('layout.BankType')</label>
                                                            <div class="col-md-7">
                                                            <select name="bank_type" id="" class="form-control">
                                                                <option value=""> @lang('layout.Select') </option>
                                                                <option value="Bank"> @lang('layout.Bank') </option>
                                                                <option value="Box"> @lang('layout.Box') </option>
                                                            </select>
                                                            </div> --}}

                                                            
                                        @if(auth()->user()->financial_classes)
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label" >@lang('layout.AllZeroAccounts')</label>
                                                    <input type="checkbox" name="zeroAccounts" value="on"  class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        @endif   

                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label" >@lang('layout.NotTransferFunds')</label>
                                                    <input type="checkbox" name="not_transfer" value="on"  class="form-control">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label" >@lang('layout.GroupByCategory')</label>
                                                    <input type="checkbox" name="groupByCategory" value="on"  class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <!-- begin expense category -->
                                        <div class="col-md-2">
                                            <label class="control-label">@lang('layout.Category')</label>
                                            <v-select  label="name" :options="expense_category" v-model="selected_expense_category" @search="searchCategories"></v-select>
                                            <input type="hidden" name="exp_category_id" data-vv-as="@lang('layout.Class')" :value="(this.selected_expense_category==null)?null:selected_expense_category.id">
                                        </div> 

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Account') </label>
                                        <v-select 
                                        class="vue-select2" 
                                        v-model="selectedAccount" 
                                        label="name" 
                                        @search="onAccountSearch"
                                        :options="account_list"
                                        :multiple="true"
                                        >
                                        </v-select>

                                        <input type="hidden" name="account_id":value="account_id.length > 0 ? account_id:null">
                                    </div>
                                    {{-- <div class="col-md-2">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label" >@lang('layout.Details')</label>
                                                <input type="checkbox" name="details" value="on"  class="form-control">

                                                
                                            </div>
                                        </div>
                                    </div> --}} 
                                    <div class="col-md-3">
                                        <label class="control-label ">@lang('layout.Details') </label>
                                        <select name="details" id="" class="form-control">
                                            <option value="">@lang('layout.Select')</option>
                                            <option value="details_by_account">@lang('layout.DetailsByAccount')</option>
                                            <option value="details_all">@lang('layout.DetailsAll')</option>
                                            <option value="details_statement">@lang('layout.StatementDetails')</option>
                                            <option value="total_statement">@lang('layout.StatementTotal')</option> 
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label ">@lang('layout.StatementDetails') </label>
                                        <select name="accounts_details" class="form-control">
                                            <option value="">@lang('layout.Select')</option>
                                            <option value="Payment">@lang('layout.Payment')</option>
                                            <option value="Transfer">@lang('layout.TransferTo')</option>
                                            <option value="Expense">@lang('menu.Expense')</option>
                                            <option value="Deposit">@lang('layout.Deposit')</option>
                                            <option value="Withdrawal">@lang('layout.Withdrawal')</option>
                                            <option value="salary">@lang('layout.Salary')</option>
                                            <option value="loan">@lang('layout.Loan')</option>
                                            <option value="prepaid">@lang('layout.Prepaid')</option>
                                            <option value="reward">@lang('layout.Reward')</option>
                                            <option value="personalPayAndReceive">@lang('layout.PersonalPayAndReceive')</option>
                                            <option value="Receive">@lang('layout.Recevies')</option>
                                            <option value="Write Checks">@lang('menu.WriteChecks')</option>
                                            <option value="Sales Receipt">@lang('menu.SaleReceipt')</option>
                                            <option value="Fixed Asset">@lang('layout.FixAsset')</option>
                                            <option value="send cheque">@lang('layout.Cheque')</option>
                                            <option value="EXchange">@lang('menu.CurrencyExchange')</option>
                                        </select>
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                            <select name="period" v-model="period" @input="getDates()"
                                                class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-8" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example"
                                                        v-model="from_date" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example"
                                                        v-model="to_date" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="account_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;"
                                                v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                    <table
                                                        class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden"
                                                                    :name="'column_name['+itemIndex+']'"
                                                                    class="form-control" v-model="row.column_name">


                                                                <label class="switch">
                                                                    <input type="checkbox"
                                                                        :name="'column_status['+itemIndex+']'"
                                                                        :checked="row.checkedColumn">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>



                                                    <!-- <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label> -->

                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->


        </div>
    </report-modal>
</div>

<!-- <div class="row"> -->
<div class="portlet light bordered sale">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase"> @lang('layout.AccountList')</span>
        </div>
    </div>
    <div class="portlet-body">
        <template v-cloak id="company_ll">
            <company @company="setCompany"></company>
        </template>

        <ul class="nav nav-pills mytabs" id="mytabs">
            <li class="active">
                <a href="#tab" data-toggle="tab" id="default">@lang('layout.AllAccounts')</a>
            </li>
            <?php
                $counter = 0;
                ?>
            @foreach($accounttypes AS $Atype)
            @if (($loop->index)<6) <li>
                <a href="#tab{{$Atype}}" id="{{$Atype}}" data-toggle="tab">{{__('layout.'.ucfirst($Atype))}}</a>
                </li>
                @endif
                @if (($loop->index)>=6)
                <?php
                    $counter++;
                    if($counter == 1)
                    {
                ?>
                <li class="dropdown">
                    <a href="javascript:;" id="myTabDrop1" class="dropdown-toggle" data-toggle="dropdown">
                        @lang('layout.OtherAccount')
                        <i class="fa fa-angle-down"></i>
                    </a>
                    <ul class="dropdown-menu" role="menu" aria-labelledby="myTabDrop1">
                        <?php
                            }
                            ?>
                        <li>
                            <a href="#tab{{$Atype}}" id="{{$Atype}}" data-toggle="tab">{{__('layout.'.ucfirst($Atype))}}</a>
                        </li>
                        <?php
                            if($loop->last)
                            {
                        ?>
                    </ul>
                </li>
                <?php
                    }
                ?>
                @endif

                @endforeach
                @if(auth()->user()->financial_classes)
                <li>
                    <a href="#tab" data-toggle="tab" id="zero_account">@lang('layout.AllZeroAccounts')</a>
                </li>
                @endif
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab">
                <div class="page-toolbar">
                    <div class=" pull-right">
                        @permission('account-export')
                        <span id="anchore-modal">
                            <a href="#" @click.prevent="showModal" id="anchore-modal-link" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                            </a>
                        </span>
                        @endpermission
                        @permission('account-create')
                        <a href="{{route('account.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button>
                        </a>
                        @endpermission
                    </div>
                </div>
                <table id="my_table_default" class="table table-striped table-bordered table-hover" cellspacing="0"
                    width="100%">
                    <thead>
                        <tr>
                            <th>@lang('layout.AccountNumber')</th>
                            <th>@lang('layout.AccountName')</th>
                            <th>@lang('layout.AccountType')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Balance')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions') </th>
                        </tr>
                    </thead>

                </table>
            </div>
            @foreach($accounttypes AS $mmm)

            <div class="tab-pane" id="tab{{$mmm}}">
                <div class="page-toolbar">
                    <div class="pull-right">
                        @permission('account-export')


                        <button type="button" id="{{$mmm}}" onClick="report_by_type_excell()" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>


                        <button type="button" id="{{$mmm}}" onClick="report_by_type_pdf()" class="btn btn-success"><i
                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF')
                        </button>
                        @endpermission
                        @permission('account-create')
                        <a href="{{route('account.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button>
                        </a>
                        @endpermission
                    </div>
                </div>
                <table id="my_table_{{$mmm}}" class="table table-striped table-bordered table-hover" cellspacing="0"
                    width="100%">
                    <thead>
                        <tr>
                            <th>@lang('layout.AccountNumber')</th>
                            <th>@lang('layout.AccountName')</th>
                            <th>@lang('layout.AccountType')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Balance')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions') </th>
                        </tr>
                    </thead>
                </table>
            </div>
            @endforeach
        </div>
    </div>
</div>

<!-- </div> -->
<!-- END TAB PORTLET-->

<!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

<script type="text/javascript">
    // submit the form
    function showChiled(data = '') {
        // console.log(12, data);
        swal({
            title: "@lang('layout.ShowSubAccount')",
            buttons: "@lang('layout.Confirm')",
            text: data,
            // icon: "info",
        }).then((willDelete) => {
            if (willDelete) {
                
            }
        });
    }
    
    // submit the form

    var cust_rep = {!!customeReportNewData('account_index')!!};
        var AccountType = 0;
        var type_id = 0;
        var myid = '';
        var my_table = 0;
        var my_table_default = 0;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            myid = 'default';
            my_table_default = $('#my_table_default').DataTable({
                ajax: {
                    url: '{{ route("account.index") }}',
                    data: function (d) {
                        d.type = myid;
                    }
                },
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                destroy: true,
                paging: true,
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'accounts.number'},
                    {data: 'name', name: 'accounts.name'},
                    {data: 'type', name: 'accounts.type'},
                    {data: 'description', name: 'accounts.description'},
                    {data: 'currency', name: 'accounts.currency'},
                    {data: 'balance', name: 'balance', searchable: false, orderable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', searchable: false, orderable: false},
                ]
            });


        });


        /**
         * we load approperiat datable according
         * to it's site_id
         */
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $(document).on("click", "#mytabs li", function (event) {
            var myid = event.target.id;
            if (myid == 'default') {
                my_table_default = $('#my_table_default').DataTable({
                    ajax: {
                        url: '{{route("account.index")}}',
                        data: function (d) {
                            d.type = myid;
                        }
                    },
                    pageLength: '{{getPageRows()}}',
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    destroy: true,
                    order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                    paging: true,
                    serverSide: true,
                    buttons: [{
                        extend: 'excel',
                        text: '',
                        key: {
                            key: 'x',
                            altkey: true
                        }
                    }],
                    columns: [
                        {data: 'number', name: 'accounts.number'},
                        {data: 'name', name: 'accounts.name'},
                        {data: 'type', name: 'accounts.type'},
                        {data: 'description', name: 'accounts.description'},
                        {data: 'currency', name: 'accounts.currency'},
                        {data: 'balance', name: 'balance', searchable: false, orderable: false},
                        {data: 'user', name: 'users.name'},
                        {data: 'actions', name: 'actions', searchable: false, orderable: false},
                    ]
                });


            } else if (myid == 'zero_account') {
                my_table_default = $('#my_table_default').DataTable({
                    ajax: {

                        url: '{{route("account.index")}}',
                        data: function (d) {
                            d.type = 'zero_account';
                        }
                    },
                    pageLength: '{{getPageRows()}}',
                    
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    destroy: true,
                    scrollCollapse: false,
                    paging: true,
                    order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                    serverSide: true,
                    autoWidth: false,
                    buttons: [{
                        extend: 'excel',
                        text: '',
                        key: {
                            key: 'x',
                            altkey: true
                        }
                    }],
                    columns: [
                        {data: 'number', name: 'accounts.number'},
                        {data: 'name', name: 'accounts.name'},
                        {data: 'type', name: 'accounts.type'},
                        {data: 'description', name: 'accounts.description'},
                        {data: 'currency', name: 'accounts.currency'},
                        {data: 'balance', name: 'balance', searchable: false, orderable: false},
                        {data: 'user', name: 'users.name'},
                        {data: 'actions', name: 'actions', searchable: false, orderable: false},
                    ]
                });
            } else {

                if (my_table != 0) {
                    my_table.destroy();
                }
                my_table = $('#my_table_' + myid).DataTable({
                    ajax: {

                        url: '{{route("account.index")}}',
                        data: function (d) {
                            d.type = myid;
                        }
                    },
                    pageLength: '{{getPageRows()}}',
                    
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    destroy: true,
                    scrollCollapse: false,
                    paging: true,
                    order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                    serverSide: true,
                    autoWidth: false,
                    buttons: [{
                        extend: 'excel',
                        text: '',
                        key: {
                            key: 'x',
                            altkey: true
                        }
                    }],
                    columns: [
                        {data: 'number', name: 'accounts.number'},
                        {data: 'name', name: 'accounts.name'},
                        {data: 'type', name: 'accounts.type'},
                        {data: 'description', name: 'accounts.description'},
                        {data: 'currency', name: 'accounts.currency'},
                        {data: 'balance', name: 'balance', searchable: false, orderable: false},
                        {data: 'user', name: 'users.name'},
                        {data: 'actions', name: 'actions', searchable: false, orderable: false},
                    ]
                });
            }
        });        
        
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });


        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        })


        function report_by_type_excell(e) {
            var myid = event.target.id;
            vm.type_id = myid;
            anchor.showModal();
        }

        function report_by_type_pdf(e) {
            var myid = event.target.id;

            vm.type_id = myid;
            anchor.showModal();
        }

        Vue.component('v-select', VueSelect.VueSelect);

        var currencies = {!! $currencies !!};
        var code = '{!! getHomeCurrency()['code'] !!}';
        var accountClass = {!! $accountClass!!};

        var vm = new Vue({

            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                type_id: '',
                currencies: currencies,
                selected_currency: null,
                accountClass: accountClass,
                selected_accountClass: null,
                financial_classes: {!!getFinancialClassList()!!},
                code: code,
                expense_category:[],
                selected_expense_category:null,
                account_list:[],
                selectedAccount:[],
                account_id:[],
                bank_type:null,
                customReportData:
                [ 
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'' ,column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.AccountCategory")', column_name: 'account_category',checkedColumn:(cust_rep.account_category)?'checked':'' ,column_percentage:(cust_rep.account_category___percent)?cust_rep.account_category___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'' ,column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.FirstDate")', column_name: 'start_date',checkedColumn:(cust_rep.start_date)?'checked':'' ,column_percentage:(cust_rep.start_date___percent)?cust_rep.start_date___percent:''},
                 {Name: '@lang("layout.LastDate")', column_name: 'end_date',checkedColumn:(cust_rep.end_date)?'checked':'' ,column_percentage:(cust_rep.end_date___percent)?cust_rep.end_date___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'referencen_number',checkedColumn:(cust_rep.referencen_number)?'checked':'' ,column_percentage:(cust_rep.referencen_number___percent)?cust_rep.referencen_number___percent:''},
                 {Name: '@lang("layout.ReferenceName")', column_name: 'referencen_name',checkedColumn:(cust_rep.referencen_name)?'checked':'' ,column_percentage:(cust_rep.referencen_name___percent)?cust_rep.referencen_name___percent:''},
                 {Name: '@lang("layout.ReceiptFactor")', column_name: 'recipt_number',checkedColumn:(cust_rep.recipt_number)?'checked':'' ,column_percentage:(cust_rep.recipt_number___percent)?cust_rep.recipt_number___percent:''},
                 {Name: '@lang("layout.AccountNumber")', column_name: 'account_number',checkedColumn:(cust_rep.account_number)?'checked':'' ,column_percentage:(cust_rep.account_number___percent)?cust_rep.account_number___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'' ,column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'' ,column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
                 {Name: '@lang("layout.Issue")', column_name: 'issue',checkedColumn:(cust_rep.issue)?'checked':'' ,column_percentage:(cust_rep.issue___percent)?cust_rep.issue___percent:''},
                 {Name: '@lang("layout.AccountName")', column_name: 'account_name',checkedColumn:(cust_rep.account_name)?'checked':'' ,column_percentage:(cust_rep.account_name___percent)?cust_rep.account_name___percent:''},
                 {Name: '@lang("layout.Bank")', column_name: 'bank',checkedColumn:(cust_rep.bank)?'checked':'' ,column_percentage:(cust_rep.bank___percent)?cust_rep.bank___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'' ,column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'' ,column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'' ,column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TransactionQty")', column_name: 'transactionQty',checkedColumn:(cust_rep.transactionQty)?'checked':'' ,column_percentage:(cust_rep.transactionQty___percent)?cust_rep.transactionQty___percent:''},
                 {Name: '@lang("layout.FirstTransaction")', column_name: 'firstDate',checkedColumn:(cust_rep.firstDate)?'checked':'' ,column_percentage:(cust_rep.firstDate___percent)?cust_rep.firstDate___percent:''},
                 {Name: '@lang("layout.LastTransaction")', column_name: 'lastDate',checkedColumn:(cust_rep.lastDate)?'checked':'' ,column_percentage:(cust_rep.lastDate___percent)?cust_rep.lastDate___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'' ,column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.QutIn")', column_name: 'qutIn',checkedColumn:(cust_rep.qutIn)?'checked':'' ,column_percentage:(cust_rep.qutIn___percent)?cust_rep.qutIn___percent:''},
                 {Name: '@lang("layout.QutOut")', column_name: 'qutOut',checkedColumn:(cust_rep.qutOut)?'checked':'' ,column_percentage:(cust_rep.qutOut___percent)?cust_rep.qutOut___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'' ,column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'' ,column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.BalanceBase")', column_name: 'balance_base',checkedColumn:(cust_rep.balance_base)?'checked':'' ,column_percentage:(cust_rep.balance_base___percent)?cust_rep.balance_base___percent:''},
                 {Name: '@lang("layout.Balance")', column_name: 'balance',checkedColumn:(cust_rep.balance)?'checked':'' ,column_percentage:(cust_rep.balance___percent)?cust_rep.balance___percent:''},
                 {Name: '@lang("layout.BaseCurrency")', column_name: 'base_currency',checkedColumn:(cust_rep.base_currency)?'checked':'' ,column_percentage:(cust_rep.base_currency___percent)?cust_rep.base_currency___percent:''},
                 {Name: '@lang("layout.QutOut")' + ' ' + '@lang("layout.BaseCurrency")' , column_name: 'qutOut_Base_Currency',checkedColumn:(cust_rep.qutOut_Base_Currency)?'checked':'' ,column_percentage:(cust_rep.qutOut_Base_Currency___percent)?cust_rep.qutOut_Base_Currency___percent:''},
                 {Name: '@lang("layout.QutIn")' + ' ' + '@lang("layout.BaseCurrency")' , column_name: 'QutIn_Base_Currency',checkedColumn:(cust_rep.QutIn_Base_Currency)?'checked':'' ,column_percentage:(cust_rep.QutIn_Base_Currency___percent)?cust_rep.QutIn_Base_Currency___percent:''},
                 {Name: '@lang("layout.Amount")' + ' ' + '@lang("layout.BaseCurrency")', column_name: 'Amount_Base_Currency',checkedColumn:(cust_rep.Amount_Base_Currency)?'checked':'' ,column_percentage:(cust_rep.Amount_Base_Currency___percent)?cust_rep.Amount_Base_Currency___percent:''},
                 {Name: '@lang("layout.CurrenciesInAmount")' , column_name: 'currency_in_amount',checkedColumn:(cust_rep.currency_in_amount)?'checked':'' ,column_percentage:(cust_rep.currency_in_amount___percent)?cust_rep.currency_in_amount___percent:''},
                 {Name: '@lang("layout.CurrenciesOutAmount")' , column_name: 'currency_out_amount',checkedColumn:(cust_rep.currency_out_amount)?'checked':'' ,column_percentage:(cust_rep.currency_out_amount___percent)?cust_rep.currency_out_amount___percent:''},
                 {Name: '@lang("layout.Days")' , column_name: 'days',checkedColumn:(cust_rep.days)?'checked':'' ,column_percentage:(cust_rep.days___percent)?cust_rep.days___percent:''},
                  
                ],
                  cust_rep:cust_rep
            },
            watch: {
                selectedAccount: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });

                    this.account_id = x;
                    console.log('x value');
                    console.log(x);
                }
            },
            methods: {
                get_by_bank_type()
                {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'account_search',
                            // type: '',
                            type: vm.type_id,
                            bank_type: vm.bank_type,
                            search: ''
                        }
                    })
                        .then(function (response) {
                            this.account_list = [];
                            if (response.data.length > 0) {
                                vm.account_list = response.data;
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        })

                },

                 //ajax call to get expense_categories
                searchCategories(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'anyTable',
                                'search_column': 'name',
                                'table_name': 'expense_categories',
                                keyword: search,
                            }
                        })
                        .then(function(response) {
                            vm.expense_category = [];
                            if (response.data.length > 0) {
                                vm.expense_category = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            console.log(error);
                        })

                    loading(false);
                },

                onAccountSearch: _.debounce((search, loading) => {

                    // var bank_type_id = (document.getElementById('bank_type_idd'))?document.getElementById('bank_type_idd').value:null;
                    // console.log('DDDD',vm.bank_type,bank_type_id)
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'account_search',
                            type: vm.type_id,
                            bank_type: vm.bank_type,
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.account_list = [];
                            if (response.data.length > 0) {
                                vm.account_list = response.data;
                                console.log('data', vm.account_list);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })

                }, getDebounceTime()),

                closeModal: function () {
                    this.account_list = [];
                    this.account_id = [];
                    this.is_show = !this.is_show;
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

</script>


@endpush