@extends('layouts.app')
@section('content')
    <div class="row">
 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    @if($duplicate)
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewAccountStep') </span>
                    @else
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditAccount') </span>
                    @endif
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"> 
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            @if($duplicate)
            {!! Form::model($account, ['method' => 'post','class'=>'form-horizontal','route' => ['account.store', $account->id]]) !!}
            @else
            {!! Form::model($account, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['account.update', $account->id]]) !!}
            @endif
            <input type="hidden" name="type" value="{{$account->type}}" id="">
                <div class="form-body">
                    <div class="row" id="app" v-cloak style="display: flex; justify-content: center;">
                        <div class="col-lg-6 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;padding: 0px 0px 10px 0px;">
                            @if(getAccountNumber()=="true")
                            <div class="form-group">
                                <label class="control-label col-lg-12" style="display: flex; justify-content: start;">@lang('layout.AccountNumber')</label>
                                <div class="col-lg-12">
                                    {{Form::number('number',null,['class'=>'form-control'])}}
                                </div>
                            </div>
                            @endif
                            <div class="form-group">
                                <label class="control-label col-lg-12" style="display: flex; justify-content: start;">@lang('layout.AccountName')
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-lg-12">
                                    @if($account->name=="opening balance equity")
                                    {{Form::text('name',null,['class'=>'form-control','readonly'=>'true'])}}
                                    @else
                                    {{Form::text('name',null,['class'=>'form-control'])}}
                                    @endif
                                    
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-12" style="display: flex; justify-content: start;">@lang('layout.Currency')
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-md-12">
                                    {{Form::text('currency',null,['class'=>'form-control','disabled'])}}
                                </div>
                            </div>
                            <div class="form-group" v-if="balances">
                                <label class="control-label col-md-12" style="display: flex; justify-content: start;">@lang('layout.Balance')
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-md-12">
                                    <vue-numeric
                                        class="form-control"
                                        v-model="balance"
                                        :max="99999999999999"
                                        currency=""
                                        :precision="precision()"

                                        @if(systemConfig()[29] == 1) @readonly($account->currency != getHomeCurrency()['code']) @endif
                                        >
                                    </vue-numeric>
                                    <input type="hidden" v-model="balance" name="balance" />
                                </div>
                            </div>
                            <div class="form-group" v-if="balances">
                                <label class="control-label col-md-12" style="display: flex; justify-content: start;">@lang('layout.Rate')
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-md-12">
                                    {{Form::text('rate',null,['class'=>'form-control'])}}
                                </div>
                            </div>
                            <div class="form-group" v-if="balances">
                                <label class="control-label col-md-12" style="display: flex; justify-content: start;">@lang('layout.Date')
                                    <span class="required"> </span>
                                </label>
                                <div class="col-md-12">
                                    {{Form::text('date',null,['class'=>'form-control date'])}}
                                </div>
                            </div>
                            <!-- begin parent account -->
                            @if(systemConfig()[29] != 1)
                            <div class="form-group ">
                                <label class="control-label col-md-12" style="display: flex; justify-content: start;">@lang('layout.Subaccount')</label>
                                <div class="col-md-12">
                                    <v-select  label="name"  :options="approperiateParentBank" v-model="selected_parent"></v-select>
                                    <input type="hidden" name="parent_id"  v-validate="'required'" data-vv-as="@lang('layout.Account')" :value="(this.selected_parent==null)?null:selected_parent.id">
                                </div>
                            </div>
                            @endif
                            <!-- end parent account -->
                            <!-- begin accountClass account -->
                            <div class="form-group ">
                                <label class="control-label col-md-12" style="display: flex; justify-content: start;">@lang('layout.Class')</label>
                                <div class="col-md-12">
                                    <v-select  label="name" :options="accountClass" v-model="selected_accountClass"></v-select>
                                    <input type="hidden" name="class_id"  v-validate="'required'" data-vv-as="@lang('layout.Class')" :value="(this.selected_accountClass==null)?null:selected_accountClass.id">
                                </div>
                            </div>
                            <!-- end accountClass account -->
                            <!-- begin expense category -->
                            <div class="form-group " v-if="type == 'expense'">
                                <label class="control-label col-md-12" style="display: flex; justify-content: start;">@lang('layout.Category')
                                </label>
                                <div class="col-md-12">
                                    <v-select  label="name" :options="expense_category" v-model="selected_expense_category"></v-select>
                                    <input type="hidden" name="exp_category_id"  v-validate="'required'" data-vv-as="@lang('layout.Class')" :value="(this.selected_expense_category==null)?null:selected_expense_category.id">
                                </div>
                            </div>
                            <!-- end expense category -->
                            @if($account->type == 'bank')
                            <div class="form-group">
                                <label class="control-label col-md-12" style="display: flex; justify-content: start;">@lang('layout.BankType')</label>
                                <div class="col-md-12">
                                <select name="bank_type" id="" class="form-control" v-model="bank_type">
                                    <option value=""> @lang('layout.Select') </option>
                                    <option value="Bank"> @lang('layout.Bank') </option>
                                    <option value="Box"> @lang('layout.Box') </option>
                                </select>
                                </div>
                            </div>
                            @endif
                            <div class="form-group">
                                <label class="control-label col-md-12" style="display: flex; justify-content: start;">@lang('layout.Description')</label>
                                <div class="col-md-12">
                                    {{Form::textarea('description',$account->description,['class'=>'form-control','rows'=>'3'])}}
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- <div class="row" id="app" v-cloak>
                        <div class="col-md-8">
                        </div>
                    </div> --}}
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('account.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>  
            {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
 

@push('scripts')
    <script>
    Vue.component('v-select', VueSelect.VueSelect);
    Vue.use(VueNumeric.default);

    var parent = {!! $parent!!};
    var accountClass = {!! $accountClass!!};
    var category = {!! $category!!};

    var account={!! $account !!};
    
    new Vue({
    el: '#app',
    data:{
        serverError:{ },
        type:"{!!$account->type!!}",
        all_parent:parent,
        parent:[],
        selected_parent:{!! $selectedParent !!},
        accountClass:accountClass,
        selected_accountClass: null,
        expense_category:category,
        selected_expense_category:null,
        balance: 0,
        bank_type: null,
        selectedCurrency:{!! $selectedCurrency !!},
    },
    computed:{
        balances: function () {
            this.accountTypeChange();
            if(this.type == 'bank' || this.type == 'otherCurrentAsset' || this.type == 'liability' ||this.type == 'CreditCard' || this.type == 'otherAsset' || this.type == 'otherCurrentLiability' || this.type == 'longTermLiability' || this.type == 'asset' || this.type=='equity'){
                return true;
                }
                else
                {
                return false;
                }
            },

            // filter the banks according to selected currency
            approperiateParentBank:function()
        {
                var parentCopy=this.parent.slice();
                var tempParent=parentCopy.filter((account)=>{
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.currency.toLowerCase())
                });
                if(tempParent.length>0)
                {
                    //this.selected_parent=tempParent[0];
                }
                return tempParent;
        },
    },
    mounted: function() {
        if (account.bank_type) {
            this.bank_type = account.bank_type;
            // console.log(this.bank_type,account);
        }
        @if($account->class_id)
            this.selected_accountClass = _.find(accountClass , (o) => o.id == "{{$account->class_id}}");
        @endif
        @if($account->exp_category_id)
            this.selected_expense_category = _.find(category , (o) => o.id == "{{$account->exp_category_id}}");
        @endif
        @if($account->balance)
            this.balance = {{$account->balance}};
        @endif
    },
    methods:{
        accountTypeChange()
        {
            if(this.type != ''){ 
                console.log('tttt',this.type);
                var all_parent_copy=this.all_parent.slice();
                this.parent=all_parent_copy.filter((account)=>{
                     return this.type.toLowerCase()==account.type.toLowerCase();
                });
            }
        },
    }
})

    </script>
@endpush