@extends('layouts.app')
@section('style')
    <link rel="stylesheet" href="{{url('vue/wizardform/vue-form-wizard.min.css')}}">
    <style>
    </style>
@stop
@section('content')
@include('accounts.modal')
    <div class="row">
        <div class="portlet light sale" id="form_wizard_d">
                <div class="">
                    <div class="caption">
                        <i class=" icon-layers font-red"></i>
                        <span class="caption-subject font-red bold uppercase"> @lang('layout.CreateNewAccountStep')
                        </span>
                    </div>
                 </div>
                <div class=" form">
                    {{Form::open(['route'=>'account.store','method'=>'post','class'=> 'form-horizontal','id'=>'account-form'])}}
                    <div class="" id="accot">
                        <div class="form-body">
                            <div class="">
                                <div class="alert alert-danger display-none">
                                    <button class="close" data-dismiss="alert"></button> You have some form errors. Please check below. </div>
                                <div class="alert alert-success display-none">
                                    <button class="close" data-dismiss="alert"></button> Your form validation is successful! </div>

                                <div id="app" v-cloak>

                                        {{-- <form-wizard title="@lang('layout.ProvideYourAccountDetails')" color="#26a1ab"  subtitle='' @on-complete="onComplete" :start-index="{{(old('type'))?1:0}}"> --}}
                                        {{-- <tab-content title="@lang('layout.SelectAccountType')" > --}}
                                            <div class="col-lg-6">
                                                <div style="border: 1px solid rgb(218, 218, 218);border-radius: 5px;padding: 5px 20px;border-radius: 5px;">
                                                    <div class="card-header" style="background-color: rgb(80, 129, 141) !important; padding: 15px;border-radius: 5px;">
                                                        <h4 class="text-center" style="color: white;">@lang('layout.SelectAccountType')</h4>
                                                    </div>
                                                    <div class="tab-pane active" id="t1">
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label class=" col-md-4">@lang('layout.AccountType')
                                                                    </label>
                                                                    <div class="col-md-5">
                                                                        <br>
                                                                        <div class="mt-radio-list">
                                                                            <label class="mt-radio" style="border-bottom: 1px solid rgb(240, 240, 240);"> @lang('layout.Income')
                                                                                {{ Form::radio('income',null,null,['v-model'=>'type']) }}
                                                                                <span></span>
                                                                            </label>
                                                                            <label class="mt-radio" style="border-bottom: 1px solid rgb(240, 240, 240);"> @lang('layout.Expense')
                                                                                {{ Form::radio('expense',null,null,['v-model'=>'type']) }}
                                                                                <span></span>
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="col-md-4">@lang('layout.OtherAccountType')
                                                                    </label>
                                                                    <br>
                                                                    <div class="col-md-5">
                                                                        <div class="mt-radio-list">
                                                                            <label class="mt-radio" style="border-bottom: 1px solid rgb(240, 240, 240);"> @lang('layout.FixAsset')
                                                                                {{ Form::radio('asset',null,null,['v-model'=>'type']) }}
                                                                                <span></span>
                                                                            </label>
                                                                            <label class="mt-radio" style="border-bottom: 1px solid rgb(240, 240, 240);"> @lang('layout.Bank')
        
                                                                                {{ Form::radio('bank',null,null,['v-model'=>'type']) }}
        
                                                                                <span></span>
                                                                            </label>
                                                                            <label class="mt-radio" style="border-bottom: 1px solid rgb(240, 240, 240);"> @lang('layout.Liability')
                                                                                {{ Form::radio('liability',null,null,['v-model'=>'type']) }}
        
                                                                                <span></span>
                                                                            </label>
                                                                            <label class="mt-radio" style="border-bottom: 1px solid rgb(240, 240, 240);"> @lang('layout.CreditCard')
                                                                                {{ Form::radio('CreditCard',null,null,['v-model'=>'type']) }}
        
                                                                                <span></span>
                                                                            </label>
                                                                            <label class="mt-radio" style="border-bottom: 1px solid rgb(240, 240, 240);"> @lang('layout.Equity')
                                                                                {{ Form::radio('equity',null,null,['v-model'=>'type']) }}
                                                                                <span></span>
                                                                            </label>
        
                                                                            <label class="mt-radio" style="border-bottom: 1px solid rgb(240, 240, 240);"> @lang('layout.OtherAccount')
                                                                                {{ Form::radio('other','other',null,['v-model'=>'other']) }}
        
                                                                                <span></span>
                                                                            </label>
                                                                        </div>
                                                                        <div v-if="other">
                                                                            {{Form::select('type',['accountsReceivable' => __('layout.AccountsReceivable'),'otherCurrentAsset' => __('layout.OtherCurrentAssets'),
                                                                            'otherAsset' => __('layout.OtherAsset'),'accountsPayable' => __('layout.AccountsPayable'),'otherCurrentLiability' => __('layout.OtherCurrentLiability'),
                                                                            'longTermLiability' => __('layout.LongTermLiability'),'costOfGoodSold' => __('layout.CostOfGoodSold'),'otherIncome' => __('layout.OtherIncome'),
                                                                            'otherExpense' => __('layout.OtherExpense')],'Accounts Receivable',[ 'v-model'=>'type','class'=>'form-control'])}}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            {{-- <div class="mt-element-ribbon bg-grey-steel desciption-mt" style="v">
                                                                <div class="ribbon ribbon-border ribbon-color-primary uppercase">@lang('layout.Description')</div> --}}
                                                                {{-- <p v-html="description" class="ribbon-content"></p> --}}
                                                                <p v-html="description" class="ribbon-content" style="visibility: hidden;"></p> 
                                                                {{--<p class="ribbon-content">Duis mollis, est non commodo luctus, nisi erat porttitor ligula</p>--}}
                                                                {{--<p class="ribbon-content">@{{description}}</p>--}}
                                                            {{-- </div> --}}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        {{-- </tab-content> --}}

                                        {{-- <tab-content title="@lang('layout.LastStep')" > --}}
                                            <div class="col-lg-6" v-if="type" style="">
                                                <div style="border: 1px solid rgb(218, 218, 218);border-radius: 5px;padding: 5px 20px;border-radius: 5px;">
                                                    <div class="card-header" style="background-color: rgb(80, 129, 141) !important; padding: 15px;border-radius: 5px;">
                                                        <h4 class="text-center" style="color: white;">@lang('layout.AccountDetails')</h4>
                                                    </div>
                                                    {{-- <h4 class="text-center" style="text-decoration: underline; text-underline-position: under;">@lang('layout.AccountDetails')</h4> --}}
                                                    <div class="tab-pane" id="tab2">
                                                        <input type="hidden" name="type"  v-model="type">
                                                        @if(session()->get("system_direction") == "ltr")
                                                        <h3 class="block"> @lang('layout.ProvideYour') <span style="color: red; font-weight: bolder;font-size: 50px;">@{{ translateType }}</span> @lang('layout.AccountDetails')</h3>
                                                        @else
                                                         <h4 class="block" style="direction: rtl"> 
                                                         <span style="color: red;font-weight: bolder;font-size: 25px;"> @{{ translateType }}</span>
                                                         @lang('layout.ProvideYour') </h4>
                                                        @endif
                                                        <div class="row" style="">
                                                            <div class="col-md-12" >
                                                                @if(getAccountNumber()=="true") {{--&& !(fields.number.dirty)--}}
                                                                <div class="form-group " style="margin-bottom: 5px;" :class="{ 'has-error': errors.has('number') || serverError.number  }">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.AccountNumber')</label>
                                                                    <div class="col-md-7" >
                                                                        <span v-bind:value="serverError.number = {{($errors->has('number')?'true':'false')}}"  ></span>
                                                                        {{Form::number('number',null,['class'=>'form-control ','autocomplete'=>'off','rows'=>'3',':class'=>"{'input': true}"])}}
                                                                        <span v-if="serverError.number && !(fields.number.dirty) " class="help-block">  {{$errors->first('number')}}</span>
                                                                        <span v-if="errors.has('number')" v-bind:value="serverError.number = false" class="help-block">@{{ errors.first('number') }}</span>
                                                                    </div>
                                                                </div> 
                                                                @endif
                                                                @if(getBankNumber()=="true") {{--!(fields.number.dirty)--}}
                                                                <div class="form-group " style="margin-bottom: 5px;" v-if="bank_account_number" :class="{ 'has-error': errors.has('number') || serverError.number  }">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.BankAccountNumber')</label>
                                                                    <div class="col-md-7">
                                                                        {{Form::text('bank_account_number',null,['class'=>'form-control ','autocomplete'=>'off','rows'=>'3',':class'=>"{'input': true}"])}} 
                                                                    </div> 
                                                                </div>
                                                                @endif 
                                                                <span v-bind:value="serverError.name = {{($errors->has('name')?'true':'false')}}"  > </span> {{--&& !(fields.name.dirty)--}}
                                                                <div class="form-group " style="margin-bottom: 5px;" :class="{ 'has-error': errors.has('name') || serverError.name }">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.AccountName')
                                                                        <span class="required" style="padding: 0px 10px 0px 0px;"> * </span>
                                                                    </label>
                                                                    <div class="col-md-7" style="margin-bottom: 5px;">
                                                                        {{Form::text('name',null,['class'=>'form-control','autocomplete'=>'off','v-validate'=>"'required|min:3'" ])}}
                                                                        <span v-if="serverError.name  " class="help-block">  {{$errors->first('name')}}</span> {{--&& !(fields.name.dirty)--}}
                                                                        <span v-if="errors.has('name')" v-bind:value="serverError.name = false" class="help-block">@{{ errors.first('name') }}</span>
                                                                        <span v-if="balance">
                                                                            {{Form::hidden('currency',null,['class'=>'form-control','v-bind:value'=>'selectedCurrency.code'])}}
                                                                            {{Form::hidden('balance',null,['class'=>'form-control','v-bind:value'=>'amount'])}}
                                                                                <input type="hidden" name="date" v-bind:value='date'  />
                                                                            {{--{{Form::hidden('rate',null,['class'=>'form-control','v-bind:value'=>'rate'])}}--}}
                                                                            {{Form::hidden('currency_rate',null,['class'=>'form-control','v-bind:value'=>'selectedCurrency.exchange_rate'])}}
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                                <!-- begin currency -->
                                                                <div class="form-group " style="margin-bottom: 5px;" v-if="type == 'bank' || type== 'accountsReceivable' || type== 'accountsPayable' || type== 'CreditCard'">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.ToCurrency')
                                                                        <span class="required" style="padding: 0px 10px 0px 0px;"> * </span>
                                                                    </label>
                                                                    <div class="col-lg-7" style="padding: 0px !important;">
                                                                        <div class="col-md-9">
                                                                            <select id="" class="form-control" style="margin-bottom: 5px;" v-model="selectedCurrency">
                                                                               <option  v-for="currency in currencyList" :value="currency">@{{currency.name}}</option>
                                                                               {{--@foreach($currency as  $curr)--}}
                                                                                  {{----}}
                                                                                   {{--<option  value="{{$curr->code}},{{$curr->symbol}},{{$curr->exchange_rate}}">{{$curr->name}}</option>--}}
                                                                               {{--@endforeach--}}
                                                                           </select>
                                                                             {{Form::hidden('currency',null,['class'=>'form-control','v-bind:value'=>'selectedCurrency.code'])}}
                                                                       </div>
                                                                    </div>
                                                                </div>

                                                                
                                                                
                                                                <!-- end currency -->
                                                                <!-- begin parent account -->
                                                                @if(systemConfig()[29] != 1)
                                                                <div class="form-group " style="margin-bottom: 5px;">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.Subaccount')
                                                                    </label>
                                                                    <div class="col-md-7"> 
                                                                        <v-select  label="name" :options="approperiateParentBank" v-model="selected_parent"></v-select>
                                                                        <input type="hidden" name="parent_id"  v-validate="'required'" data-vv-as="@lang('layout.Account')" :value="(this.selected_parent==null)?null:selected_parent.id">
                                                                    </div>
                                                                </div>
                                                                @endif
                                                                <!-- end parent account -->
                                                                <!-- begin accountClass account -->
                                                                <div class="form-group " style="margin-bottom: 5px;">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.Class')
                                                                    </label>
                                                                    <div class="col-md-7">
                                                                        <v-select  label="name" :options="accountClass" v-model="selected_accountClass"></v-select>
                                                                        <input type="hidden" name="class_id"  v-validate="'required'" data-vv-as="@lang('layout.Class')" :value="(this.selected_accountClass==null)?null:selected_accountClass.id">
                                                                    </div>
                                                                    <div class="col-md-2">
                                                                        <!-- app -->
                                                                        <div v-if="balance" id="openingbalance">
                                                                            <button type=button id="show-modal" v-on:click="showModal = true" @if(systemConfig()[29] == 1) v-if="selectedCurrency && selectedCurrency.code == '{{getHomeCurrency()['code']}}'" @endif class="btn btn-success">@lang('layout.OpeningBalance')</button>
                                                                            <!-- use the modal component, pass in the prop -->
                                                                            <modal v-if="showModal" @close="showModal = false">
                                                                                <div slot="body">
                                                                                    <div class="row">
                                                                                        <div class="col-md-12">
                                                                                            <div class="form-group">
                                                                                                <label class="control-label">@lang('layout.Date')</label>
                                                                                                <div class="">
                                                                                                    <date_picker placeholder="@lang('layout.Date')" @click.native="get_date()" id="date" ></date_picker>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="form-group">
                
                                                                                            <div v-if="type == 'bank'" class="col-md-12">
                                                                                                <label class="control-label ">@lang('layout.SelectCurrency') </label>
                
                                                                                                <select name="currency" id="" class="form-control" v-model="selectedCurrency" @if(systemConfig()[29] == 1) disabled @endif >
                                                                                                    <option  v-for="currency in currencyList" :value="currency">@{{currency.name}}</option>
                                                                                                    {{--@foreach($currency as  $curr)--}} 
                                                                                                        {{--<option  value="{{$curr->code}},{{$curr->symbol}},{{$curr->exchange_rate}}">{{$curr->name}}</option>--}}
                                                                                                    {{--@endforeach--}}
                                                                                                </select>
                
                                                                                            </div>
                                                                                        </div>
                                                                                        <div v-if="selectedCurrency && selectedCurrency.code != '{{getHomeCurrency()['code']}}'" class="col-md-12">
                                                                                            <div class="form-group">
                                                                                                <label class="control-label ">@lang('layout.FromRate'): {{getHomeCurrency()['code']}} @lang('layout.ToRate') : @{{ selectedCurrency.code }}</label>
                
                                                                                                <div class="input-group">
                                                                                                    <span class="input-group-addon">{{Currency()->exchange_rate}} {{getHomeCurrency()['code']}} = </span>
                
                                                                                                    <input type="number"   v-model="selectedCurrency.exchange_rate"  min="0" step="any" data-number-to-fixed="2" data-number-stepfactor="100" class="form-control currency" id="c2" />
                                                                                                    <span class="input-group-addon">@{{ selectedCurrency.code }}</span>
                                                                                                </div>
                
                
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-12">
                                                                                            <div class="form-group">
                                                                                                <label class="control-label ">@lang('layout.Balance')</label>
                
                                                                                                <span v-bind:value="serverError.balance = {{($errors->has(' balance')?'true':'false')}}"  ></span> {{--&& !(fields. balance.dirty)--}}
                                                                                                 <div class="input-group " :class="{ 'has-error': errors.has(' balance') || serverError. balance  }">
                                                                                                    <span class="input-group-addon">@{{  selectedCurrency.code}}</span>
                                                                                                    <vue-numeric
                                                                                                        class="form-control"
                                                                                                        v-model="amount"
                                                                                                        :max="99999999999999"
                                                                                                        currency=""
                                                                                                        :precision="precision()"
                                                                                                        @click="get_date"
                                                                                                        >
                                                                                                    </vue-numeric>
                                                                                                    <input type="hidden" v-model="amount" min="0" step="0.01" data-number-to-fixed="2" data-number-stepfactor="100" class="form-control currency" id="c2" />
                                                                                                    <span class="input-group-addon">@{{ selectedCurrency.symbol }}</span>
                
                                                                                                     {{-- && !(fields. balance.dirty) --}}
                                                                                                </div>
                                                                                                     <span v-if="serverError.balance" class="help-block">  {{$errors->first(' balance')}}</span>
                                                                                                     <span v-if="errors.has(' balance')" v-bind:value="serverError. balance = false" class="help-block">@{{ errors.first('balance') }}</span>
                
                
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <h3 slot="header">@lang('layout.OpeningBalance')</h3>
                                                                                <div slot="footer">
                                                                                    <button type="button" @click="get_dates" class="btn btn-success" >
                                                                                        @lang('layout.Submit')
                                                                                    </button>
                                                                                    <button type="button" class="btn btn-danger" @click="get_dates" >
                                                                                        @lang('layout.Cancel')
                                                                                    </button>
                                                                                </div>
                                                                            </modal>
                                                                        </div>
                                                                    </div> 
                                                                </div>
                                                                <!-- end accountClass account -->
                                                                <!-- begin expense category -->
                                                                <div class="form-group " v-if="type == 'expense'" style="margin-bottom: 5px;">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.Category')
                                                                    </label>
                                                                    <div class="col-md-7">
                                                                        <v-select  label="name" :options="expense_category" v-model="selected_expense_category"></v-select>
                                                                        <input type="hidden" name="exp_category_id"  v-validate="'required'" data-vv-as="@lang('layout.Class')" :value="(this.selected_expense_category==null)?null:selected_expense_category.id">
                                                                    </div>
                                                                </div> 
                                                                <div class="form-group"  v-show="type == 'bank'" style="margin-bottom: 5px;">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.BankType')</label>
                                                                    <div class="col-md-7">
                                                                    <select name="bank_type" id="" class="form-control">
                                                                        <option value=""> @lang('layout.Select') </option>
                                                                        <option value="Bank"> @lang('layout.Bank') </option>
                                                                        <option value="Box"> @lang('layout.Box') </option>
                                                                    </select>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group" style="margin-bottom: 5px;">
                                                                    <label class="control-label col-md-3" style=" display: flex; justify-content: start;">@lang('layout.Description')</label>
                                                                    <div class="col-md-7"> 
                                                                        {{Form::textarea('description',null,['class'=>'form-control','rows'=>'3'])}}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                                              
                                                        </div> 
                                                        <div class="row">
                                                            <div class="col-md-12 text-center">
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-5"></label>
                                                                    <div class="col-md-12">
                                                                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                                                        <button  type="button" class="btn blue" style="border: 1px solid #3598dc;" v-if="type" :disabled="disabled"
                                                                        @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                                                        <a href="{{route('account.index')}}" class="btn default" style="border: 1px solid #e1e5ec;"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                            
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        {{-- </tab-content> --}}
                                        {{-- <span v-if="type " slot="next">
                                        </span> --}}
                                      <!-- <el-button type="primary" slot="prev" >
                                          <i style="font-size:80px;color:rgb(38, 161, 171)" class="{{(App::isLocale('fa') || App::isLocale('pa'))?"fa fa-arrow-circle-right":"fa fa-arrow-circle-left"}}"></i>
                                        </el-button>
                                      <el-button type="primary"  v-if="type " slot="next">
                                          <i style="font-size:80px;color:rgb(38, 161, 171)" class="{{(App::isLocale('fa') || App::isLocale('pa'))?"fa fa-arrow-circle-left":"fa fa-arrow-circle-right"}}"></i>
                                      </el-button>
                                        <el-button type="primary" slot="finish"><i style="font-size:80px;color:rgb(38, 161, 171)" class="fa fa-save"></i></el-button>   
                                         -->
                                        
                                        {{-- <el-button type="primary" slot="prev" class="btn btn-default btn-wd" style="background-color: rgb(38, 161, 171); border-color: rgb(38, 161, 171); color: white;">
                                            @lang('layout.Previous')
                                        </el-button>
                                        <el-button type="primary" class="btn btn-default btn-wd" v-if="type " slot="next"  style="background-color: rgb(38, 161, 171); border-color: rgb(38, 161, 171); color: white;">
                                        @lang('layout.Next')
                                        </el-button>
                                        <el-button type="primary" slot="finish" class="btn btn-default btn-wd" style="background-color: green; border-color: rgb(38, 161, 171); color: white;">
                                        @lang('layout.Finish')               
                                        </el-button> --}}
                                       
                                        {{-- </form-wizard>  --}}
                                </div>
                            </div>
                        </div>
                    </div> 
                    {!! Form::close() !!}
                </div>


            </div>
    </div>

@endsection
@push('scripts')
 
<script src="{{url('vue/wizardform/vue-form-wizard.js')}}"></script>

<script>
    Vue.component('v-select', VueSelect.VueSelect);
    Vue.use(VueNumeric.default);
    Vue.use(VeeValidate);
    Vue.component('modal', {
        template: '#modal-template'
    })

    Vue.use(VueFormWizard);

  

    var parent = {!! $parent!!};
    var accountClass = {!! $accountClass!!};
    var category = {!! $category!!};
    var v = new Vue({
    el: '#app',
    data:{
        type:"{{old('type')}}",
        translateType:null,
        serverError:{ },
        currencyList:{!! $currency !!},
        selectedCurrency:{!! json_encode($homeCurrency) !!},
        all_parent:parent,
        parent:[],
        selected_parent:null,
        accountClass:accountClass,
        selected_accountClass:null,
        expense_category:category,
        selected_expense_category:null,
        other:false,
        currency: false,
        balance: false,
        disabled: false,
        amount:null,
        date:null,
        rate:null,
        bank_account_number:false,
        showModal: false,
        message: "tets",
        pro:{
            width: ''
        },
    },
    watch:{
        type:function(){
        //   console.log('sss',this.translateType);

        }
    },
    computed:{
        description: function (createElement) {
            this.accountTypeChange();
            if(this.type == ''){
                  this.translateType="";

                this.pro.width='0'
            }
            else{
                this.pro.width='50%'
            }

            if(this.type == 'income'){

                this.currency = false
                this.balance = false
                this.other = false
                this.bank_account_number = false
                this.translateType="@lang('layout.IncomeAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.IncomeAccount')</strong>"
            }
            else if(this.type == 'expense'){
                this.currency = false
                this.balance = false
                this.other = false
                this.bank_account_number = false
                this.translateType="@lang('layout.ExpenseAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.ExpenseAccount')</strong><br>"
            }
            else if(this.type == 'asset'){
                this.currency = false
                this.balance = true
                this.other = false
                this.bank_account_number = false
                this.translateType="@lang('layout.AssetAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.AssetAccount')</strong>"
            }
            else if(this.type == 'bank'){
                this.currency = true
                this.balance = true
                this.other = false
                this.translateType="@lang('layout.BankAccount')";
                this.bank_account_number = true

                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.BankAccount')</strong>"
            }
            else if(this.type == 'liability'){
                this.currency = false
                this.balance = true
                this.other = false
                this.bank_account_number = false
                this.translateType="@lang('layout.LiabilityAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.LiabilityAccount')</strong>"
            }
            else if(this.type == 'CreditCard'){
                this.currency = true
                this.balance = true
                this.other = false
                this.bank_account_number = false
                 this.translateType="@lang('layout.CreditCardAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.CreditCardAccount')</strong>"
            }
            else if(this.type == 'equity'){
                this.currency = false
                this.balance = true
                this.other = false
                this.bank_account_number = false
                   this.translateType="@lang('layout.EquityAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.EquityAccount')</strong>"
            }
            else if(this.type == 'accountsReceivable'){
                this.currency = true
                this.balance = false
                this.bank_account_number = false
                this.translateType="@lang('layout.AccountsReceivable')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.AccountsReceivable')</strong>"
            }
            else if(this.type == 'otherCurrentAsset'){
                this.currency = false
                this.balance = true
                this.other = true
                this.bank_account_number = false
                 this.translateType="@lang('layout.OtherCurrentAssetAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.OtherCurrentAssetAccount')</strong>"
            }
            else if(this.type == 'otherAsset'){
                this.currency = false
                this.balance = true
                this.bank_account_number = false
                 this.translateType="@lang('layout.OtherAssetAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.OtherAssetAccount')</strong>"
            }
            else if(this.type == 'accountsPayable'){
                this.currency = true
                this.balance = false
                this.bank_account_number = false
                this.translateType="@lang('layout.AccountPayable')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.AccountPayable')</strong>"
            }
            else if(this.type == 'otherCurrentLiability'){
                this.currency = false
                this.balance = true
                this.bank_account_number = false
                 this.translateType="@lang('layout.OtherCurrentLiabilityAccount')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.OtherCurrentLiabilityAccount') </strong>"
            }
            else if(this.type == 'longTermLiability'){
                this.currency = false
                this.balance = true
                this.bank_account_number = false
                this.translateType="@lang('layout.LongTermLiability')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.LongTermLiability')</strong>"
            }
            else if(this.type == 'costOfGoodSold'){
                this.currency = false
                this.balance = false
                this.bank_account_number = false
                 this.translateType="@lang('layout.CostOfGoodSold')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.CostOfGoodSold')</strong>"
            }
            else if(this.type == 'otherIncome'){
                this.currency = false
                this.balance = false
                this.bank_account_number = false
                   this.translateType="@lang('layout.OtherIncome')";
               return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.OtherIncome')</strong>"
            }
            else if(this.type == 'otherExpense'){
                this.currency = false
                this.balance = false
                this.bank_account_number = false
                  this.translateType="@lang('layout.OtherExpense')";
                return " @lang('layout.ThisIsDescriptionFor') <strong>@lang('layout.OtherExpense')</strong>"
            }

            

        },
        
         // filter the banks according to selected currency
        approperiateParentBank:function() {
            var parentCopy=this.parent.slice();
            var tempParent=parentCopy.filter((account)=>{
                return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.currency.toLowerCase())
            });
            if(tempParent.length>0)
            {
                //this.selected_parent=tempParent[0];
            }
            return tempParent;
       },
    },
    created:function()
    {
        // console.log('ssss',this.all_parent);
    },
    methods: {

        saveAndNew() {
            var url = "{{route('account.store')}}";
            form_id = 'account-form';
            var data = $('#' + form_id).serialize();
            v.disabled = true;
            axios.post(url, data)
                .then(function (response) {
                    if (response.data.result == 1) {
                        $('#' + form_id).trigger('reset');
                        toastr.success('', response.data.message);
                        location.reload();
                    }
                    else {
                        v.disabled = false;
                        var message = "{{__('message.Warning')}}";
                        $('#error-sound')[0].play();
                        toastr.warning('', message);
                    }
                })
                .catch(function (error) {
                    v.disabled = false;
                    console.log(error);
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                });
        },

        getParents()
        {

        },
        onComplete: function(){
//                alert('Yay. Done!');
//                this.$emit('on-complete')
            document.getElementById("account-form").submit()

        },
        get_date: function(){
            var date = document.getElementById("date").value;
            this.date = date;
        },
        get_dates: function(){
            var date = document.getElementById("date").value;
            this.date = date;
            this.showModal=false;

        },

        accountTypeChange()
        {
            if(this.type != ''){

                
                var all_parent_copy=this.all_parent.slice();
                this.parent=all_parent_copy.filter((account)=>{
                    

                    return this.type.toLowerCase()==account.type.toLowerCase();
                });
            }
        },
    }
})

</script>

@endpush