@extends('layouts.factor-master')
@section('content')

<?php
$report = customeReportNew('bank_list_show_percent');
$_account_number= !in_array('account_number', $report);
$_account_name= !in_array('account_name', $report);
$_account_type= !in_array('account_type', $report);
$_currency= !in_array('currency', $report);
$_balance= !in_array('balance', $report);
$_qut_in= !in_array('qut_in', $report);
$_qut_out= !in_array('qut_out', $report);

$report_percent = customeReportNewPercent('bank_list_show_percent');
$_account_number_percent = (array_key_exists('account_number___percent', $report_percent))?$report_percent['account_number___percent']:null;
$_account_name_percent = (array_key_exists('account_name___percent', $report_percent))?$report_percent['account_name___percent']:null;
$_account_type_percent = (array_key_exists('account_type___percent', $report_percent))?$report_percent['account_type___percent']:null;
$_currency_percent = (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
$_balance_percent = (array_key_exists('balance___percent', $report_percent))?$report_percent['balance___percent']:null;
$_qut_in_percent = (array_key_exists('qut_in___percent', $report_percent))?$report_percent['qut_in___percent']:null;
$_qut_out_percent = (array_key_exists('qut_out___percent', $report_percent))?$report_percent['qut_out___percent']:null;
 
// dd($report, $report_percent);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.BankListReport')</h3>



<table class="main-table">
        <tr class="bg">
            <th>@lang('layout.Record')</th>
            @if($_account_number)<th @if($_account_number_percent) width="{{$_account_number_percent}}%" @endif>@lang('layout.AccountNumber')</th>@endif
            @if($_account_name)<th @if($_account_name_percent) width="{{$_account_name_percent}}%" @endif>@lang('layout.AccountName')</th>@endif
            @if($_account_type)<th @if($_account_type_percent) width="{{$_account_type_percent}}%" @endif>@lang('layout.AccountType')</th>@endif
            @if($_currency)<th @if($_currency_percent) width="{{$_currency_percent}}%" @endif>@lang('layout.Currency')</th>@endif
            @if($_balance)<th @if($_balance_percent) width="{{$_balance_percent}}%" @endif>@lang('layout.Balance')</th>@endif
            @if($_qut_in)<th @if($_qut_in_percent) width="{{$_qut_in_percent}}%" @endif>@lang('layout.QutIn')</th>@endif
            @if($_qut_out)<th @if($_qut_out_percent) width="{{$_qut_out_percent}}%" @endif>@lang('layout.QutOut')</th>@endif
            
        </tr>
    <?php 
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
       <td class="center">{{++$count}}</td>
       @if($_account_number) <td class="center">{{$record->number}}</td> @endif
       @if($_account_name)  <td class="center">{{$record->name}}</td> @endif
       @if($_account_type) <td style="text-align: center;">@lang('layout.Bank')</td> @endif
       @if($_currency) <td style="text-align: center;">{{$record->currency}}</td> @endif
       @if($_balance) <td style="text-align: center;">{{myRound($record->balance)}}</td> @endif
       @if($_qut_in)  <td  style="text-align: center;">{{myRound($record->total_in_amount)}}</td> @endif
       @if($_qut_out)  <td class="center"> {{myRound($record->total_out_amount)}} </td> @endif
    </tr>
    @endforeach
</table>

<table>
    <tr>

    </tr>
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection