@extends('layouts.factor-master')

@section('content')

@php

$report = customeReportNew('account_index');

    // dd($report);
    $_type= !in_array('type', $report);
    $_date= !in_array('date', $report);
    $_account_number= !in_array('account_number', $report);
    $_account_name= !in_array('account_name', $report);
    $_amount= !in_array('amount', $report);
    $_currency= !in_array('currency', $report);
    $_total= !in_array('total', $report);
    $_transactionQty= !in_array('transactionQty', $report);
    $_firstDate= !in_array('firstDate', $report);
    $_lastDate= !in_array('lastDate', $report);
    $_user= !in_array('user', $report);
    $_qutIn= !in_array('qutIn', $report);
    $_qutOut= !in_array('qutOut', $report);
    $_base_currency= !in_array('base_currency', $report);
    $_qutOut_Base_Currency= !in_array('qutOut_Base_Currency', $report);
    $_Amount_Base_Currency= !in_array('Amount_Base_Currency', $report);
    $_currency_in_amount= !in_array('currency_in_amount', $report);
    $_currency_out_amount= !in_array('currency_out_amount', $report);


    $report_percent = customeReportNewPercent('account_index');
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_account_number_percent= (array_key_exists('account_number___percent', $report_percent))?$report_percent['account_number___percent']:null;
    $_account_name_percent= (array_key_exists('account_name___percent', $report_percent))?$report_percent['account_name___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_transactionQty_percent= (array_key_exists('transactionQty___percent', $report_percent))?$report_percent['transactionQty___percent']:null;
    $_firstDate_percent= (array_key_exists('firstDate___percent', $report_percent))?$report_percent['firstDate___percent']:null;
    $_lastDate_percent= (array_key_exists('lastDate___percent', $report_percent))?$report_percent['lastDate___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_qutIn_percent= (array_key_exists('qutIn___percent', $report_percent))?$report_percent['qutIn___percent']:null;
    $_qutOut_percent= (array_key_exists('qutOut___percent', $report_percent))?$report_percent['qutOut___percent']:null;
    $_base_currency_percent= (array_key_exists('base_currency___percent', $report_percent))?$report_percent['base_currency___percent']:null;
    $_qutOut_Base_Currency_percent= (array_key_exists('qutOut_Base_Currency___percent', $report_percent))?$report_percent['qutOut_Base_Currency___percent']:null;
    $_Amount_Base_Currency_percent= (array_key_exists('Amount_Base_Currency___percent', $report_percent))?$report_percent['Amount_Base_Currency___percent']:null;
@endphp
 
<h3 class="table-caption" style="text-align: center;">@lang('layout.ChartOfAccountsReport')</h3>
@if($from_date || $to_date)
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif    {{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif     {{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
@endif
@if(count($selected_accounts)>0 || $ClassName || $accountClassName)
<table class="main-table" style="margin: 6px 0px;" >
    @if($ClassName)
    <tr>
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
    </tr>
    @endif    
    
    @if($accountClassName)
    <tr>
      <td>
        <span>@lang('layout.Class')</span>: {{$accountClassName}}
      </td>
    </tr>
    @endif
    
    @if(count($selected_accounts)>0)
    <tr>
        <td>
          <span>@lang('layout.Account')</span>: 
          @foreach($selected_accounts as $account)
          {{$account->name}} ,
          @endforeach
        </td>
    </tr>
    @endif
</table>
@endif

<table class="main-table" id="aa" cellpadding="5px">
    <thead>
        <tr class="bg">
            <td  class="center" style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Record') </div>
            </td>
            @if($_transactionQty)<td class="center" @if($_transactionQty_percent) width="{{$_transactionQty_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.TransactionQty')</div>
            </td> @endif
            @if($_firstDate)<td class="center" @if($_firstDate_percent) width="{{$_firstDate_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.FirstTransaction')</div>
            </td> @endif 
            @if($_lastDate)<td class="center" @if($_lastDate_percent) width="{{$_lastDate_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.LastTransaction')</div>
            </td> @endif

            @if($_account_name)<td class="center"  @if($_account_name_percent) width="{{$_account_name_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.AccountName') </div>
            </td>@endif
            @if($_account_number)<td class="center" @if($_account_number_percent) width="{{$_account_number_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.AccountNumber')</div>
            </td>@endif
            
            {{-- @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Date')</div>
            </td>@endif  --}}
            @if($_type)<td class="center" @if($_type_percent) width="{{$_type_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Type')</div>
            </td>@endif
 
            @if($_currency)<td class="center" @if($_currency_percent) width="{{$_currency_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Currency')</div>
            </td>@endif
 
            @if($from_date)
            @if($_amount)<td class="center" @if($_amount_percent) width="{{$_amount_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.PreviousBilance')</div>
            </td>@endif
            @endif
            @if($_qutIn)<td class="center" @if($_qutIn_percent) width="{{$_qutIn_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.QutIn')</div>
            </td>@endif
            @if($_qutOut)<td class="center" @if($_qutOut_percent) width="{{$_qutOut_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.QutOut')</div>
            </td>@endif
            
            @if($_amount)<td class="center" @if($_amount_percent) width="{{$_amount_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Amount')</div>
            </td>@endif

            @if($from_date) @if($_Amount_Base_Currency)<td class="center" @if($_Amount_Base_Currency_percent) width="{{$_Amount_Base_Currency_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.PreviousBilance') {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>@endif
            @endif
            @if($_base_currency)<td class="center" @if($_base_currency_percent) width="{{$_base_currency_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.QutIn') {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>@endif
            @if($_qutOut_Base_Currency)<td class="center" @if($_qutOut_Base_Currency_percent) width="{{$_qutOut_Base_Currency_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.QutOut') {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>@endif
            
            @if($_Amount_Base_Currency)<td class="center" @if($_Amount_Base_Currency_percent) width="{{$_Amount_Base_Currency_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>@endif

            @if($_user)
            <td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif style="font-weight: bold; font-size:18px">
                <div> @lang('layout.User')</div>
            </td>
            @endif
            
        </tr>
    </thead>
    @php
    $count = 0;
    $sum= 0;
    $beforeBelance = 0;
    $total_in = 0;
    $total_out = 0;
    $currencies_in=[];
    $currencies_out=[];
    $total_sum = 0;

    $total_beforeCurrencyBelance = 0;
    $total_in_amount = 0;
    $total_out_amount = 0;
    $totalBalance = 0;


    $totalBalance_base = 0;
    $colspan = 8;

    @endphp
    @foreach($data AS $record)

    @php

    $sum+=$record['ExchangedAmount'];
    $total_in+=$record['in_balance_base'];
    $total_out+=$record['out_balance_base'];
    
    $beforeBelance+=$record['beforeBelance'];
    $total_beforeCurrencyBelance += $record['beforeCurrencyBelance'];
    $total_in_amount += $record['in_balance'];
    $total_out_amount += $record['out_balance'];
    $totalBalance += $record['Balance'];
    $totalBalance_base += $record['Balance_base'];

    if(array_key_exists($record['Currency'], $currencies_in))
    {
        $currencies_in[$record['Currency']]['amount']=$currencies_in[$record['Currency']]['amount']+$record['in_balance'];
        $currencies_in[$record['Currency']]['base_amount']=$currencies_in[$record['Currency']]['base_amount']+$record['in_balance_base'];
        $currencies_in[$record['Currency']]['transaction_count_in']=$currencies_in[$record['Currency']]['transaction_count_in']+$record['in_transaction_count'];
    }
    else
    {
        $currencies_in[$record['Currency']]['amount']=$record['in_balance'];
        $currencies_in[$record['Currency']]['base_amount']=$record['in_balance_base'];
        $currencies_in[$record['Currency']]['transaction_count_in']=$record['in_transaction_count'];
    }
    if(array_key_exists($record['Currency'], $currencies_out))
    {
        $currencies_out[$record['Currency']]['amount']=$currencies_out[$record['Currency']]['amount']+$record['out_balance'];
        $currencies_out[$record['Currency']]['base_amount']=$currencies_out[$record['Currency']]['base_amount']+$record['out_balance_base'];
        $currencies_out[$record['Currency']]['transaction_count_out']=$currencies_out[$record['Currency']]['transaction_count_out']+$record['out_transaction_count'];
    }
    else
    {
        $currencies_out[$record['Currency']]['amount']=$record['out_balance'];
        $currencies_out[$record['Currency']]['base_amount']=$record['out_balance_base'];
        $currencies_out[$record['Currency']]['transaction_count_out']=$record['out_transaction_count'];
    }
    @endphp
    <tr>
        <td class="center">{{++$count}}</td>
        @if($_transactionQty)<td class="center">{{$record['transaction_count']}}</td>@endif
        @if($_firstDate)<td class="center">{{convertDate($record['min_date'])}}</td>@endif
        @if($_lastDate)<td class="center">{{convertDate($record['max_date'])}}</td>@endif
        @if($_account_name)<td class="" style=" color: #000000; font-weight: bolder; font-size: 18px">{{$record['AccountName']}}</td>@endif
        @if($_account_number)<td class="center">{{$record['accountNumber']}}</td>@endif
        {{-- @if($_date)<td class="center">{{convertDate($record['Date'])}}</td>@endif --}}
        @if($_type)<td class="center">{{__('layout.'.ucfirst($record['Type']))}}</td>@endif

        @if($_currency)<td class="center">{{$record['Currency']}}</td>@endif

        @if($from_date)
        @if($_amount)<td class="center">{{myRound($record['beforeBelance'])}}</td>@endif
        @endif

        @if($record['in_balance'] == 0)
        @if($_qutIn)<td class="center">  </td>@endif
        @else 
        @if($_qutIn)<td class="center">{{myRound($record['in_balance'])}}</td>@endif
        @endif

        @if($record['out_balance'] == 0)
        @if($_qutOut)<td class="center">  </td>@endif
        @else 
        @if($_qutOut)<td class="center">{{myRound($record['out_balance'])}}</td>@endif
        @endif

        @if($_amount)<td class="center ltr">{{myRound($record['Balance'],2)}} 
            @php
            if(!empty($record['children']))
            {
            @endphp
            <br/>
            <span>@lang('layout.Total') {{$record['AccountName']}} : {{myRound($record['total'])}} </span>
            @php
            }
            @endphp
        </td>@endif 

        @if($from_date)
        @if($_Amount_Base_Currency)<td class="center">{{myRound($record['beforeCurrencyBelance'])}}</td>@endif
        @endif

        @if($record['in_balance_base'] == 0)
        @if($_base_currency)<td class="center">  </td>@endif
        @else 
        @if($_base_currency)<td class="center">{{myRound($record['in_balance_base'])}}</td>@endif
        @endif

        @if($record['out_balance_base'] == 0)
        @if($_qutOut_Base_Currency)<td class="center"></td>@endif
        @else 
        @if($_qutOut_Base_Currency)<td class="center">{{myRound($record['out_balance_base'])}}</td>@endif
        @endif


        @if($_Amount_Base_Currency)<td class="center">{{myRound($record['Balance_base'])}}</td>@endif 
        @if($_user)<td class="center">{{$record['user']}} </td>@endif
    </tr>


   
    <!-- start first ch -->
    @if(!empty($record['children']))
    <?php
    $f_count=0;
    ?>
    @foreach($record['children'] as $key=>$fc)
    @php
    $sum+=$fc['ExchangedAmount'];
    $total_in+=$fc['in_balance_base'];
    $total_out+=$fc['out_balance_base'];

    $beforeBelance +=$fc['beforeBelance'];
    $total_beforeCurrencyBelance += $fc['beforeCurrencyBelance'];

    $total_in_amount += $fc['in_balance'];
    $total_out_amount += $fc['out_balance'];
    $totalBalance += $fc['Balance'];
    $totalBalance_base += $fc['Balance_base'];
    
    if(array_key_exists($fc['Currency'], $currencies_in))
    {
        $currencies_in[$fc['Currency']]['amount']=$currencies_in[$fc['Currency']]['amount']+$fc['in_balance'];
        $currencies_in[$fc['Currency']]['base_amount']=$currencies_in[$fc['Currency']]['base_amount']+$fc['in_balance_base'];
        $currencies_in[$fc['Currency']]['transaction_count_in']=$currencies_in[$fc['Currency']]['transaction_count_in']+$fc['in_transaction_count'];   
    }
    else
    {
        $currencies_in[$fc['Currency']]['amount']=$fc['in_balance'];
        $currencies_in[$fc['Currency']]['base_amount']=$fc['in_balance_base'];
        $currencies_in[$fc['Currency']]['transaction_count_in']=$fc['in_transaction_count'];
        
    } 
    if(array_key_exists($fc['Currency'], $currencies_out))
    {
        $currencies_out[$fc['Currency']]['amount']=$currencies_out[$fc['Currency']]['amount']+$fc['out_balance'];
        $currencies_out[$fc['Currency']]['base_amount']=$currencies_out[$fc['Currency']]['base_amount']+$fc['out_balance_base'];
        $currencies_out[$fc['Currency']]['transaction_count_out']=$currencies_out[$fc['Currency']]['transaction_count_out']+$fc['out_transaction_count'];
        
    }
    else
    {
        $currencies_out[$fc['Currency']]['amount']=$fc['out_balance'];
        $currencies_out[$fc['Currency']]['base_amount']=$fc['out_balance_base'];
        $currencies_out[$fc['Currency']]['transaction_count_out']=$fc['out_transaction_count'];
        
    }
    @endphp 
    <tr>
        <td class="center">{{++$f_count}}</td>
        @if($_transactionQty)<td class="center">{{$fc['transaction_count']}}</td>@endif
        @if($_firstDate)<td class="center">{{convertDate($fc['min_date'])}}</td>@endif
        @if($_lastDate)<td class="center">{{convertDate($fc['max_date'])}}</td>@endif
        @if($_account_name)<td class="" style=" color: #4c0000; font-weight: bolder; font-size: 17px"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {{$fc['AccountName']}}</td>@endif
        @if($_account_number)<td class="center">{{$fc['accountNumber']}}</td>@endif
        {{-- @if($_date)<td class="center">{{convertDate($fc['Date'])}}</td>@endif --}}
        @if($_type)<td class="center">{{__('layout.'.ucfirst($fc['Type']))}}</td>@endif

        @if($_currency)<td class="center">{{$fc['Currency']}}</td>@endif
        @if($from_date) @if($_amount)<td class="center">{{myRound($fc['beforeBelance'])}}</td>@endif @endif
        @if($_qutIn)<td class="center">{{myRound($fc['in_balance'])}}</td>@endif
        @if($_qutOut)<td class="center">{{myRound($fc['out_balance'])}}  </td>@endif

        @if($_amount)<td class="center ltr">{{myRound($fc['Balance'])}}
            @php
            if(!empty($fc['children']))
            {
            @endphp
            <br/>
            <span>@lang('layout.Total') {{$fc['AccountName']}} : {{myRound($fc['total'])}} </span>
            @php
            }
            @endphp

        </td>@endif
        
        @if($from_date) @if($_Amount_Base_Currency)<td class="center">{{myRound($fc['beforeCurrencyBelance'])}}</td>@endif @endif
        @if($_base_currency)<td class="center">{{myRound($fc['in_balance_base'])}}</td>@endif
        @if($_qutOut_Base_Currency)<td class="center">{{myRound($fc['out_balance_base'])}}</td>@endif
        @if($_Amount_Base_Currency)<td class="center">{{myRound($fc['Balance_base'])}}</td>@endif 
        @if($_user)<td class="center">{{$fc['user']}}</td>@endif
    </tr>

    



    <!-- start se ch -->
    @if(!empty($fc['children']))
    <?php
        $s_count = 0;
    ?>
    @foreach($fc['children'] as $key1=>$sc)
    @php

    $sum+=$sc['ExchangedAmount'];
    $total_in+=$sc['in_balance_base'];
    $total_out+=$sc['out_balance_base'];
    $beforeBelance +=$sc['beforeBelance'];
    $total_beforeCurrencyBelance += $sc['beforeCurrencyBelance'];
    $total_in_amount += $sc['in_balance'];
    $total_out_amount += $sc['out_balance']; 
    $totalBalance += $sc['Balance'];
    $totalBalance_base += $sc['Balance_base'];
 
    if(array_key_exists($sc['Currency'], $currencies_in))
    {
        $currencies_in[$sc['Currency']]['amount']=$currencies_in[$sc['Currency']]['amount']+$sc['in_balance'];
        $currencies_in[$sc['Currency']]['base_amount']=$currencies_in[$sc['Currency']]['base_amount']+$sc['in_balance_base'];
        $currencies_in[$sc['Currency']]['transaction_count_in']=$currencies_in[$sc['Currency']]['transaction_count_in']+$sc['in_transaction_count'];
        
    }
    else
    {
        $currencies_in[$sc['Currency']]['amount']=$sc['in_balance'];
        $currencies_in[$sc['Currency']]['base_amount']=$sc['in_balance_base'];
        $currencies_in[$sc['Currency']]['transaction_count_in']=$sc['in_transaction_count']; 
    }

    if(array_key_exists($sc['Currency'], $currencies_out))
    {
        $currencies_out[$sc['Currency']]['amount']=$currencies_out[$sc['Currency']]['amount']+$sc['out_balance'];
        $currencies_out[$sc['Currency']]['base_amount']=$currencies_out[$sc['Currency']]['base_amount']+$sc['out_balance_base'];
        $currencies_out[$sc['Currency']]['transaction_count_out']=$currencies_out[$sc['Currency']]['transaction_count_out']+$sc['out_transaction_count'];
        
    }
    else
    {
        $currencies_out[$sc['Currency']]['amount']=$sc['out_balance'];
        $currencies_out[$sc['Currency']]['base_amount']=$sc['out_balance_base'];
        $currencies_out[$sc['Currency']]['transaction_count_out']=$sc['out_transaction_count'];
       
    } 
    @endphp 
    <tr>
        <td class="center">{{++$s_count}}</td>
        @if($_transactionQty)<td class="center">{{$sc['transaction_count']}}</td>@endif
        @if($_firstDate)<td class="center">{{convertDate($sc['min_date'])}}</td>@endif
        @if($_lastDate)<td class="center">{{convertDate($sc['max_date'])}}</td>@endif
        @if($_account_name)<td class="" style=" color: #6f0000; font-weight: bolder; font-size: 16px"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {{$sc['AccountName']}}</td>@endif
        @if($_account_number)<td class="center">{{$sc['accountNumber']}}</td>@endif
        {{-- @if($_date)<td class="center">{{convertDate($sc['Date'])}}</td>@endif --}}
        @if($_type)<td class="center">{{__('layout.'.ucfirst($sc['Type']))}}</td>@endif

        @if($_currency)<td class="center">{{$sc['Currency']}}</td>@endif
        @if($from_date) @if($_amount)<td class="center">{{myRound($sc['beforeBelance'])}}</td>@endif @endif
        @if($_qutIn)<td class="center">{{myRound($sc['in_balance'])}}</td>@endif
        @if($_qutOut)<td class="center">{{myRound($sc['out_balance'])}}</td>@endif

        @if($_amount)
        <td class="center ltr">{{myRound($sc['Balance'])}}
            @if(!empty($sc['children']))
            <br/>
            <span>@lang('layout.Total') {{$sc['AccountName']}} : {{myRound($sc['total'])}} </span>
            @endif 
        </td>
        @endif

        @if($from_date) @if($_Amount_Base_Currency)<td class="center">{{myRound($sc['beforeCurrencyBelance'])}}</td>@endif @endif
        @if($_base_currency)<td class="center">{{myRound($sc['in_balance_base'])}}</td>@endif
        @if($_qutOut_Base_Currency)<td class="center">{{myRound($sc['out_balance_base'])}}</td>@endif
        @if($_Amount_Base_Currency)<td class="center">{{myRound($sc['Balance_base'])}}</td>@endif 
        @if($_user)<td class="center">{{$sc['user']}}  </td>@endif 
    </tr>
    <!-- start th ch -->
    @if(!empty($sc['children']))
    <?php
        $t_count = 0;
    ?>
    @foreach($sc['children'] as $key1=>$tc)
    @php  
    $sum+=$tc['ExchangedAmount'];
    $total_in+=$tc['in_balance_base'];
    $total_out+=$tc['out_balance_base']; 
    $beforeBelance +=$tc['beforeBelance'];
    $total_beforeCurrencyBelance += $tc['beforeCurrencyBelance'];
    $total_in_amount += $tc['in_balance'];
    $total_out_amount += $tc['out_balance']; 
    $totalBalance += $tc['Balance'];
    $totalBalance_base += $tc['Balance_base']; 
    if(array_key_exists($tc['Currency'], $currencies_in))
    {
        $currencies_in[$tc['Currency']]['amount']=$currencies_in[$tc['Currency']]['amount']+$tc['in_balance'];
        $currencies_in[$tc['Currency']]['base_amount']=$currencies_in[$tc['Currency']]['base_amount']+$tc['in_balance_base'];
        $currencies_in[$tc['Currency']]['transaction_count_in']=$currencies_in[$tc['Currency']]['transaction_count_in']+$tc['in_transaction_count'];  
    }
    else
    {
        $currencies_in[$tc['Currency']]['amount']=$tc['in_balance'];
        $currencies_in[$tc['Currency']]['base_amount']=$tc['in_balance_base'];
        $currencies_in[$tc['Currency']]['transaction_count_in']=$tc['in_transaction_count'];
        
    }



    if(array_key_exists($tc['Currency'], $currencies_out))
    {
        $currencies_out[$tc['Currency']]['amount']=$currencies_out[$tc['Currency']]['amount']+$tc['out_balance'];
        $currencies_out[$tc['Currency']]['base_amount']=$currencies_out[$tc['Currency']]['base_amount']+$tc['out_balance_base'];
        $currencies_out[$tc['Currency']]['transaction_count_out']=$currencies_out[$tc['Currency']]['transaction_count_out']+$tc['out_transaction_count'];
        
    }
    else
    {
        $currencies_out[$tc['Currency']]['amount']=$tc['out_balance'];
        $currencies_out[$tc['Currency']]['base_amount']=$tc['out_balance_base'];
        $currencies_out[$tc['Currency']]['transaction_count_out']=$tc['out_transaction_count'];
        
    } 
    @endphp
    <tr>
        <td class="center">{{++$t_count}}</td>
        @if($_transactionQty)<td class="center">{{$tc['transaction_count']}}</td>@endif
        @if($_firstDate)<td class="center">{{convertDate($tc['min_date'])}}</td>@endif
        @if($_lastDate)<td class="center">{{convertDate($tc['max_date'])}}</td>@endif  
        @if($_account_name)<td class="" style=" color: #940000; font-weight: bolder; font-size: 15px">  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {{$tc['AccountName']}}</td>@endif
        @if($_account_number)<td class="center">{{$tc['accountNumber']}}</td>@endif
        {{-- @if($_date)<td class="center">{{convertDate($tc['Date'])}}</td>@endif --}}
        @if($_type)<td class="center">{{__('layout.'.ucfirst($tc['Type']))}}</td>@endif
        @if($_currency)<td class="center">{{$tc['Currency']}}</td>@endif
        @if($from_date) @if($_amount)<td class="center">{{myRound($tc['beforeBelance'])}}</td>@endif @endif
        @if($_qutIn)<td class="center">{{myRound($tc['in_balance'])}}</td>@endif
        @if($_qutOut)<td class="center">{{myRound($tc['out_balance'])}}</td>@endif
        @if($_amount)<td class="center ltr">{{myRound($tc['Balance'])}}</td>@endif
        @if($from_date) @if($_Amount_Base_Currency)<td class="center">{{myRound($tc['beforeCurrencyBelance'])}}</td>@endif @endif
        @if($_base_currency)<td class="center">{{myRound($tc['in_balance_base'])}}</td>@endif
        @if($_qutOut_Base_Currency)<td class="center">{{myRound($tc['out_balance_base'])}}</td>@endif
        @if($_Amount_Base_Currency)<td class="center">{{myRound($tc['Balance_base'])}}</td>@endif 
        @if($_user)<td class="center">{{$tc['user']}}  </td>@endif
    </tr> 
    @endforeach
    @endif 
    @endforeach
    @endif
    <!-- end se ch -->

    @endforeach
    @endif
    <!-- end first ch --> 
    @endforeach

     
    @if(!$_transactionQty)   <?php  $colspan = $colspan-1;  ?>       @endif 
    @if(!$_firstDate)   <?php  $colspan = $colspan-1;  ?>       @endif 
    @if(!$_lastDate)   <?php  $colspan = $colspan-1;  ?>       @endif 
    @if(!$_account_name)   <?php  $colspan = $colspan-1;  ?>       @endif 
    @if(!$_account_number)   <?php  $colspan = $colspan-1;  ?>       @endif 
    @if(!$_type)   <?php  $colspan = $colspan-1;  ?>       @endif 
    @if(!$_currency)   <?php  $colspan = $colspan-1;  ?>       @endif 

    

    <tr class="bg">
        <td colspan="{{$colspan}}" class="center"> @lang('layout.Total') </td>
        @if($from_date)
        @if($_amount)
        <td colspan="1" class="center"> {{myRound($beforeBelance)}} </td>
        @endif
        @endif
        @if($_qutIn)
        @if(count($currencies_in) <= 1)
        @if($total_in_amount == 0)
        <td colspan="1" class="center"> </td>
        @else 
        <td colspan="1" class="center"> {{myRound($total_in_amount)}} </td>
        @endif
        @else 
        <td></td>
        @endif
        @endif
        @if($_qutOut)
        @if(count($currencies_out) <= 1)
        @if($total_out_amount == 0)
        <td colspan="1" class="center"> </td>
        @else 
        <td colspan="1" class="center"> {{MyRound($total_out_amount)}} </td>
        @endif
        @else 
        <td></td>
        @endif
        @endif
        @if($_amount)
        @if(count($currencies_in) <= 1)
        <td colspan="1" class="center"> {{MyRound($totalBalance)}} </td>
        @else
        <td></td>
        @endif 
        @endif 
        
        @if($from_date)
        @if($_Amount_Base_Currency)
        <td colspan="1" class="center"> {{myRound($total_beforeCurrencyBelance)}} </td>
        @endif
        @endif
        @if($_base_currency)
        <td colspan="1" class="center"> {{MyRound($total_in)}} </td>
        @endif
        @if($_qutOut_Base_Currency)
        <td colspan="1" class="center"> {{MyRound($total_out)}} </td> 
        @endif
        @if($_Amount_Base_Currency)
        <td colspan="1" class="center"> {{MyRound($totalBalance_base)}} </td>
        @endif
    </tr>
     

    <!-- start zero account -->
    @if($zero_account)
    <?php
        $z_count = 0;
    ?>
    @foreach($zero_account as $keyz=>$recordz)
    <tr>
        <td class="center">{{++$z_count}}</td>
        @if($_transactionQty)<td class="center">{{$recordz['transaction_count']}}</td>@endif
        @if($_firstDate)<td class="center">{{convertDate($recordz['min_date'])}}</td>@endif
        @if($_lastDate)<td class="center">{{convertDate($recordz['max_date'])}}</td>@endif  
        @if($_account_name)<td class="" style=" color: #000000; font-weight: bolder; font-size: 18px">{{$recordz['name']}}</td>@endif
        @if($_account_number)<td class="center">{{$recordz['number']}}</td>@endif
        {{-- @if($_date)<td class="center">{{convertDate($recordz['date'])}}</td>@endif --}}
        @if($_type)<td class="center">{{__('layout.'.ucfirst($recordz['type']))}}</td>@endif
        @if($_currency)<td class="center">{{$recordz['currency']}}</td>@endif
        @if($from_date) @if($_amount)<td class="center">{{myRound($recordz['beforeBelance'])}}    </td>@endif @endif
        @if($_qutIn)<td class="center">{{myRound($recordz['in_balance'])}}    </td>@endif
        @if($_qutOut)<td class="center">{{myRound($recordz['out_balance'])}}</td>@endif
        @if($_amount)<td class="center ltr">{{myRound($recordz['balance'])}}</td>@endif

        @if($from_date) @if($_Amount_Base_Currency)<td class="center">{{myRound($recordz['beforeCurrencyBelance'])}}    </td>@endif @endif
        @if($_base_currency)<td class="center">{{myRound($recordz['in_balance_base'])}}</td>@endif
        @if($_qutOut_Base_Currency)<td class="center">{{myRound($recordz['out_balance_base'])}}</td>@endif
        @if($_Amount_Base_Currency)<td class="center">{{myRound($recordz['Balance_base'])}}</td>@endif 
        @if($_user)<td class="center">{{$recordz['user']}}  </td>@endif
    </tr>
    @endforeach
    @endif
    <!-- end zero account -->
 
  


</table>

@if($_currency_in_amount)
<!--BEGIN In Total-->
<table class="main-table" style="margin-top:1%">
    <tr class="bg">
        <td colspan="4" class="center"><h3>@lang('layout.QutIn')</h3></td>
    </tr>
    <tr>
        <td><div class="center">  @lang('layout.Record') </div></td>
        <td><div class="center"> @lang('layout.Currency') </div></td>
        <td><div class="center"> @lang('layout.TransactionQty') </div></td>
        <td><div class="center"> @lang('layout.Amount') </div></td>
        <td><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
    </tr>
    <?php
    $count=0;
    $totalALlCurrency = 0;
    foreach($currencies_in As $key=>$currency)
    {
        $totalALlCurrency += $currency['base_amount'];
        ?>
        <tr>
        <td><div class="center">{{++$count}}</div></td>
        <td><div class="center">{{$key}}</div></td>
        <td><div class="center">{{isset($currency['transaction_count_in'])?$currency['transaction_count_in']:0}}</div></td>
        <td><div class="center">{{myRound($currency['amount'])}}</div></td>
        <td><div class="center">{{myRound($currency['base_amount'])}}</div></td>
        </tr>
        <?php
    }
    ?>
    <tr class="bg">
    <td colspan="4" class="center"><div class="center"><h3>@lang('layout.Total')</h3></div></td>
    <td colspan="1"><div class="center">{{myRound($totalALlCurrency)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
    </tr>
    </table>
    <!--END In Total--> 

    @endif
    @if($_currency_out_amount)

    <!--BEGIN Out Total-->
<table class="main-table" style="background-color: #fbc0c0; margin-top:1%">
    <tr class="bg">
        <td colspan="4" class="center"><h3>@lang('layout.QutOut')</h3></td>
    </tr>
    <tr>
        <td><div class="center">  @lang('layout.Record') </div></td>
        <td><div class="center"> @lang('layout.Currency') </div></td>
        <td><div class="center"> @lang('layout.TransactionQty') </div></td>
        <td><div class="center"> @lang('layout.Amount') </div></td>
        <td><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
    </tr>
    <?php
    $count=0;
    $totalHomeMoney = 0;
    foreach($currencies_out As $key=>$currency)
    {
        $totalHomeMoney += $currency['base_amount'];

        ?>
        <tr>
        <td><div class="center">{{++$count}}</div></td>
        <td><div class="center">{{$key}}</div></td>
        <td><div class="center">{{isset($currency['transaction_count_out'])?$currency['transaction_count_out']:0}}</div></td>
        <td><div class="center">{{myRound($currency['amount'])}}</div></td>
        <td><div class="center">{{myRound($currency['base_amount'])}}</div></td>
        </tr>
        <?php
    }
    ?>
    <tr class="bg">
    <td colspan="4" class="center"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
    <td colspan="1"><div class="center">{{myRound($totalHomeMoney)}} {{getHomeCurrency()[getCurrencyType()]}}  </div></td>
    </tr>
    </table>
    <!--END Out Total--> 
@endif

<!--BEGIN Balance-->
@if($_total)
<table class="main-table" style="margin-top:1%">
    <tr class="bg">
        <td colspan="3" class="center"><h3>@lang('layout.Total')</h3></td>
      </tr>
      <tr>
        <td><div class="center"> @lang('layout.QutIn') </div></td>
        <td><div class="center"> @lang('layout.QutOut') </div></td>
        <td><div class="center"> @lang('layout.Balance')</div></td>
      </tr>
    <tr>
        <td  style="font-weight: bold; font-size:16px;text-align:center">{{myRound($total_in)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td  style="font-weight: bold; font-size:16px;text-align:center">{{myRound($total_out)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td  style="font-weight: bold; font-size:16px;text-align:center">{{myRound($sum)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
    
</table>
@endif
<!--END Balance-->

<table class="main-table">
    @if($_total)
    @if($sum > 0 && $currency_rate >0 && $currency_name)
    <tr class="mt">
        <td colspan="2">
            <div class="center">@lang('layout.SelectedCurrency')</div>
        </td>
        <td colspan="2">
            <div class="center">@lang('layout.Rate') : {{$currency_rate}} </div>
        </td>
        <td colspan="3" style="font-weight: bold; font-size:16px;text-align:center">
            <div class="center">
                @if(systemConfig()[30] == 1)
                {{myRound($sum / (currencyList($key)[0]->static_rate) * $currency_rate)}} 
                {{-- {{myRound($sum * $currency_rate)}}  --}}
                @else 
                {{myRound($sum * $currency_rate)}} 
                @endif
                {{$currency_name}}</div>
        </td>
    </tr>
    @endif
    @endif
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection