@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('menu.Accounting')</h3>
                <div>
                    <div class="btn-group">
                        @permission('purchase-create')
                        <a href="{{route('purchase.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn btn-success dropdown-toggle" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @permission('account-create')
                            <li>
                                <a href="{{route('account.create')}}">@lang('layout.AccountList')</a>
                            </li>
                            @endpermission
                            @permission('journalEntry-list')
                            <li>
                                <a href="{{route('journalEntry.create')}}">@lang('layout.JournalEntry')</a>
                            </li>
                            @endpermission
                            @if(systemConfig()[7] != 0 )
                            @permission('PlattsRate-list')
                            <li>
                                <a href="{{route('plattsRate.create')}}">@lang('menu.PlattsRate')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @permission('account-list')
                <a href="{{route('account.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex; justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ChartOfAccount')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-cc-mastercard"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.Bank')) {{myRound($bankAccount)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                {{-- @permission('account-list')
                <a href="{{route('account.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="display: flex;justify-content: space-between;flex-wrap: wrap; padding: 0px !important;">
                            <div style="padding: 5px 10px;">
                                <div style="padding: 0px !important; margin: 0px !important;">
                                    <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ChartOfAccount')</p></div>
                                </div>
                                <div style="padding: 0px !important; margin: 0px !important;">
                                    <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.Bank')) {{myRound($bankAccount)}} {{getHomeCurrency()['code']}}</p>
                                </div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-cc-mastercard"></i></div>
                            </div>
                        </div>
                    </div>
                </a>
                @endpermission --}}
                @permission('journalEntry-list')
                <a href="{{route('journalEntry.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div  class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.JournalEntry')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-credit-card"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$journalEntry}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('discount-list')
                <a href="{{route('discount.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Discount')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-percent"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.DiscountToCustomer')) {{myround($dicountToCustomer)}} {{getHomeCurrency()['code']}}</p>
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.DiscountFromVendor')) {{myround($discountFromCustomer)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('cashbook-list')
                <a href="{{route('cashBook.newCashbook')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.CashBook1')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-book"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('cashbook-list')
                <a href="{{route('cashBook.dailyCashbook')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.DailyTransactions')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('RiskManagement-list')
                <a href="{{route('riskManagement.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.RiskManagement')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(251, 239, 91, 1);" class="fa fa-gear"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('AccountClass-list')
                <a href="{{route('accountClass.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.AccountClass')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(163, 209, 118, 1);" class="fa fa-align-justify"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 5px 0px !important;">{{$accountClass}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[7] != 0 )
                @permission('PlattsRate-list')
                <a href="{{route('plattsRate.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.PlattsRate')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 166, 164, 1);" class="fa fa-percent"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 5px 0px !important;">{{$plattsRate}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @permission('cashbook-list')
                <a href="{{route('cashBook.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.CashBook')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(21, 239, 233, 1);" class="fa fa-book"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('bankCheck-list')
                <a href="{{route('check.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.BankCheck')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 193, 191, 1);" class="fa fa-credit-card"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 5px 0px !important;">{{$bankCheck}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush