@extends('layouts.app')
@section('content')
@include('member_classes.modal')


<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ClassList') </span>
            </div>
             <div class="btn-group pull-right">
                    <!-- <a href="{{route('accountClass.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a> -->
                    <div id="accountClass" v-cloak>
                        
                         <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button>

                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.ClassCreate')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                            <textarea class="form-control" name="description" v-model="description">
                                                
                                            </textarea>
                                        </div>

                                    </div>
                                    
                                </div>
                            </div>


                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal>
                        
                    </div>

            </div>
        </div>
        <div class="portlet-body">

            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="accountClasses" width="100%">
                <thead>
                <tr> 
                    <th>@lang('layout.ID')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.Description') </th>
                    <th>@lang('layout.CreatedAt') </th>
                    <th>@lang('layout.UpdatedAt') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    let data_table;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#accountClasses').DataTable( {
            ajax: '{{route("accountClass.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:         true,
            columns: [
            { data: 'id', name: 'id' },
            { data: 'name', name: 'name' },
            { data: 'description', name: 'description' },
            { data: 'created_at', name: 'created_at' },
            { data: 'updated_at', name: 'updated_at' },
            { data: 'action', name: 'action', searchable: false, orderable: false },
            ] 
    }); 
    });
        Vue.component('modal',{
            template: '#modal-template'
        });

     let vu = new Vue({
        el: '#accountClass',
        data:{
            showModal:false,
            fieldErrors:[],
            className: null,
            description: null,
        },
        methods:{
            addClass(){
             
                // var myData = {name: this.className,description:this.description};

                axios.post("{{route('accountClass.store')}}",{
                    name:this.className,
                    description:this.description
                })
                .then(function(response){
                    vu.showModal = false;
                    vu.className = null;
                    vu.description = null;
                    $('#accountClasses').DataTable().ajax.reload();
                })
            }
        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                 }
             }
         }
     });


</script>

@endpush
