@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'transferAccounts'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                                @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-4">
                                                    <label class="control-label"> @lang('layout.FromAccount')</label>
                                                    <v-select label="name" v-model="from_account" :options="account" ></v-select>
                                                    <input type="hidden" name="from_account_id" :value="(!from_account)?null:from_account.id">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label"> @lang('layout.ToAccount')</label>
                                                    <v-select label="name" v-model="to_account" :options="account" ></v-select>
                                                    <input type="hidden" name="to_account_id" :value="(!to_account)?null:to_account.id">
                                                </div>
                                                @if(systemConfig()[5] != 0 )
                                                <div class="col-md-4">
                                                    <label class="control-label"> @lang('layout.SelectProject')</label>
                                                    <v-select label="name" v-model="selectedProject" :options="project_items" @search="ProjectSearch"></v-select>
                                                    <input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.id">
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="row">
                                            @if(systemConfig()[20] == 1)
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.ContractName')</label>
                                                <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="{{$contract}}">
                                                </v-select>
                                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />    
                                            </div>
                                            @endif
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.Currency')</label>
                                                <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                                                <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                                            </div>

                                            @if(getFinancialClass() =='true') 
                                            @permission('financialClass-list')
                                            <div class="col-md-4">
                                                <label class="control-label"> @lang('menu.FinancialClass')</label>
                                                <select name="financial_class_id" class="form-control" >
                                                    <option value="">@lang('layout.SelectClass')</option>
                                                    <option value="Unclassified">Unclassified</option>
                                                    <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                                </select>
                                            </div>
                                            @endpermission
                                            @endif
                                            @if(systemConfig()[29] == 1)
                                            <div class="col-md-2">
                                                <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                                <div class="col-md-12 mt-checkbox">
                                                    <label class="mt-checkbox mt-checkbox-outline"> 
                                                        <input type="checkbox" name="transaction_confirm" value="On">
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                            @endif
                                            <div class="col-md-2">
                                                <label class=" control-label">@lang('layout.Total')</label>
                                                <div class="col-md-12 mt-checkbox">
                                                    <label class="mt-checkbox mt-checkbox-outline"> 
                                                        <input type="checkbox" name="total_conf" value="on">
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" name="from_date"
                                                                    autocomplete="off">

                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" name="to_date"
                                                                    autocomplete="off">

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="transfer_account_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>



                                                             <!-- <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label> -->

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </report-modal>
    </div>

    <!-- <div class="row"> -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
        <div class="col-md-2 col-sm-2">
                <span class="caption-subject bold uppercase" style="font-size: 20px;">@lang('layout.Transferlist')</span>
            </div>
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Search') </span>
                    </div>
                </div>
            </div>


            <div class="portlet-title">
                <div class="caption font-dark">
                    <!-- <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Transferlist') </span> -->
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                @permission('transferAccounts-export')
                            <span id="anchore-modal">
                            <a href="#" @click.prevent="showModal" id="anchore-modal-link" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                            </a>
                    </span>
                    @endpermission
                @permission('transferAccounts-create')
                <a href="{{route('transferAccounts.create')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a>
                @endpermission

                </div>
            </div>


            
            <div class="portlet-body">

                <div class="" v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </div>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="transferAccounts">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number') </th>
                        <th>@lang('layout.FromAccount') </th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.FromRate')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.ToAccount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.ToRate')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Date')</th>
                        @if(systemConfig()[5] != 0 )
                        <th>@lang('layout.Project')</th>
                        @endif
                        <th>@lang('layout.ReferenceName')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    <!-- </div> -->

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

    <script>
        var cust_rep = {!!customeReportNewData('transfer_account_index')!!};
 
        function printAccountTransfer(id) { 
            var a = document.createElement('a');
            a.href = "{{url('printAccountTransfer')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
 
        let data = {
            selected: '{!! getCompanyID() !!}'
        };
        let data_table = null;

        function getRecord() {
            data_table = $('#transferAccounts').DataTable({
                ajax: {
                    ajax: '{{route("transferAccounts.index")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                }, 
                pageLength:'{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:9}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'transfer_accounts.number'},
                    {data: 'From_account', name: 'from_a.name'},
                    {data: 'from_currency', name: 'from.unit'},
                    {data: 'from_rate', name: 'from.rate'},
                    {data: 'amount', name: 'from.amount'},
                    {data: 'to_Account', name: 'to_a.name'},
                    {data: 'to_currency', name: 'to.unit'},
                    {data: 'to_rate', name: 'to.rate'},
                    {data: 'to_amount', name: 'to.amount'},
                    {data: 'Date', name: 'transfer_accounts.Date'},
                    @if(systemConfig()[5] != 0 )
                    {data: 'project', name: 'projects.name'},
                    @endif
                    {data: 'referencen_name', name: 'referencen_name'},
                    {data: 'referencen_number', name: 'referencen_number'},
                    {data: 'username', name: 'users.name'},
                    {data: 'Description', name: 'transfer_accounts.description'},
                    {data: 'actions', name: 'actions', searchable: false, orderable: false}
                ]
            });
        }

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            getRecord();

        });


        let vmCompany = new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    console.log('company emitted from child',event.company);
                    data.selected = event.company;

                    if (data_table != null && typeof  data_table =='object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });



        Vue.component('v-select', VueSelect.VueSelect)
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });

        let account = {!! $account !!};
        var currency2 ={!! $currency !!}
        let contract = {!!$contract!!};
        var vm = new Vue({

            el: '#print-modal',
            data: {
                selectedContract: null,
                contract: contract, 
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                project_items: [],
                selectedProject: null,
                account: account,
                from_account: null,
                to_account: null,
                currency: currency2,
                selectedCurrency: null,
                financial_classes: {!!getFinancialClassList()!!},
                customReportData:
                [            
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.FromAccount")', column_name: 'from_account',checkedColumn:(cust_rep.from_account)?'checked':'',column_percentage:(cust_rep.from_account___percent)?cust_rep.from_account___percent:''},
                 {Name: '@lang("layout.ReferenceName")', column_name: 'referencen_name',checkedColumn:(cust_rep.referencen_name)?'checked':'',column_percentage:(cust_rep.referencen_name___percent)?cust_rep.referencen_name___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'referencen_number',checkedColumn:(cust_rep.referencen_number)?'checked':'',column_percentage:(cust_rep.referencen_number___percent)?cust_rep.referencen_number___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'from_currency',checkedColumn:(cust_rep.from_currency)?'checked':'',column_percentage:(cust_rep.from_currency___percent)?cust_rep.from_currency___percent:''},
                 {Name: '@lang("layout.FromRate")', column_name: 'from_rate',checkedColumn:(cust_rep.from_rate)?'checked':'',column_percentage:(cust_rep.from_rate___percent)?cust_rep.from_rate___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'from_amount',checkedColumn:(cust_rep.from_amount)?'checked':'',column_percentage:(cust_rep.from_amount___percent)?cust_rep.from_amount___percent:''}, 
                 {Name: '@lang("layout.BaseAmount")', column_name: 'base_amount',checkedColumn:(cust_rep.base_amount)?'checked':'',column_percentage:(cust_rep.base_amount___percent)?cust_rep.base_amount___percent:''}, 
                 {Name: '@lang("layout.ToAccount")', column_name: 'to_account',checkedColumn:(cust_rep.to_account)?'checked':'',column_percentage:(cust_rep.to_account___percent)?cust_rep.to_account___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'to_currency',checkedColumn:(cust_rep.to_currency)?'checked':'',column_percentage:(cust_rep.to_currency___percent)?cust_rep.to_currency___percent:''},
                 {Name: '@lang("layout.ToRate")', column_name: 'to_rate',checkedColumn:(cust_rep.to_rate)?'checked':'',column_percentage:(cust_rep.to_rate___percent)?cust_rep.to_rate___percent:''},
                 {Name: '@lang("layout.ToAmount")', column_name: 'to_amount',checkedColumn:(cust_rep.to_amount)?'checked':'',column_percentage:(cust_rep.to_amount___percent)?cust_rep.to_amount___percent:''},
                 {Name: '@lang("layout.BaseAmount")', column_name: 'base_amount_to',checkedColumn:(cust_rep.base_amount_to)?'checked':'',column_percentage:(cust_rep.base_amount_to___percent)?cust_rep.base_amount_to___percent:''}, 
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Commission")', column_name: 'camission',checkedColumn:(cust_rep.camission)?'checked':'',column_percentage:(cust_rep.camission___percent)?cust_rep.camission___percent:''},
                 {Name: '@lang("layout.GainOrLoss")', column_name: 'gain_or_loss',checkedColumn:(cust_rep.gain_or_loss)?'checked':'',column_percentage:(cust_rep.gain_or_loss___percent)?cust_rep.gain_or_loss___percent:''},
                 {Name: '@lang("layout.TransactionConfirm")', column_name: 'transaction_confirm',checkedColumn:(cust_rep.transaction_confirm)?'checked':'',column_percentage:(cust_rep.transaction_confirm___percent)?cust_rep.transaction_confirm___percent:''},
                 {Name: '@lang("layout.TransactionType")',
                    column_name: 'trans_type',
                    checkedColumn: (cust_rep.trans_type) ? 'checked' : '',
                    column_percentage:(cust_rep.trans_type___percent)?cust_rep.trans_type___percent:''
                 },
                 {Name: '@lang("layout.MonetarySource")',
                        column_name: 'monetary_source',
                        checkedColumn: (cust_rep.monetary_source) ? 'checked' : '',
                        column_percentage:(cust_rep.monetary_source___percent)?cust_rep.monetary_source___percent:''
                },
                {Name: '@lang("layout.Contract")', 
                    column_name: 'contract',
                    checkedColumn:(cust_rep.contract)?'checked':'',
                    column_percentage:(cust_rep.contract___percent)?cust_rep.contract___percent:''
                },
                {Name: '@lang("layout.Amount") $', 
                    column_name: 'transferAmount',
                    checkedColumn:(cust_rep.transferAmount)?'checked':'',
                    column_percentage:(cust_rep.transferAmount___percent)?cust_rep.transferAmount___percent:''
                },
                {Name: '@lang("layout.Project")', 
                    column_name: 'transferProject',
                    checkedColumn:(cust_rep.transferProject)?'checked':'',
                    column_percentage:(cust_rep.transferProject___percent)?cust_rep.transferProject___percent:''
                },
                {Name: '@lang("layout.Currency")', 
                    column_name: 'transferCurrency',
                    checkedColumn:(cust_rep.transferCurrency)?'checked':'',
                    column_percentage:(cust_rep.transferCurrency___percent)?cust_rep.transferCurrency___percent:''
                },
                {Name: '@lang("layout.Amount")', 
                    column_name: 'transferAmount1',
                    checkedColumn:(cust_rep.transferAmount1)?'checked':'',
                    column_percentage:(cust_rep.transferAmount1___percent)?cust_rep.transferAmount1___percent:''
                },
                {Name: '@lang("layout.Amount") $', 
                    column_name: 'transferAmount2',
                    checkedColumn:(cust_rep.transferAmount2)?'checked':'',
                    column_percentage:(cust_rep.transferAmount2___percent)?cust_rep.transferAmount2___percent:''
                },
                {Name: '@lang("layout.AverageRate")', 
                    column_name: 'transferAverageRate',
                    checkedColumn:(cust_rep.transferAverageRate)?'checked':'',
                    column_percentage:(cust_rep.transferAverageRate___percent)?cust_rep.transferAverageRate___percent:''
                },
                ],
                cust_rep:cust_rep
            },

            methods: {

                // Search Project 
                ProjectSearch: _.debounce((search, loading) => {
                    vm.project_items = [];
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'projects',
                            'search_column': 'name',
                            'user_type': 'yes',
                        }
                    })
                    .then(function(response) {
                        this.project_items = [];
                        if (response.data.length > 0) {
                            vm.project_items = response.data;
                            // console.log('test 22', vm.project_items);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                }, getDebounceTime()),

                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });


        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    getRecord();
                }
            }
        });

    </script>


@endpush
