@extends('layouts.app')
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                   <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.TransferAccountEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($transfer, ['method' => 'PATCH','class'=>'form-horizontal','id' => 'transferAccount-form', 'route' => ['transferAccounts.update',$transfer->id]]) !!}
                <div id="app">
                    <div class="form-body">
                        <div class="row text-center">
                            <i class="font-green-haze fa fa-exchange" style="font-size: 1.6em;"></i>
                            <span class="caption-subject font-green-haze bold uppercase" style="font-size: 1.6em;"  >@lang('layout.TransferandExchangeCurrency') </span>
                        </div>
                        <br>
                        <br>
                        <div class="col-lg-6 col-md-12 col-sm-12 margin-bottom-10">
                            <div class="col-xs-12 col-sm-12 col-md-12" style="padding: 10px 0px 20px 0px;">
                                <label class="control-label col-md-3"></label>
                                <div  class="col-md-8 text-center">
                                   <span class="caption-subject font-green-haze bold uppercase" style="font-size: 1.5em;">
                                    @lang('layout.FromAccount')</span>
                                </div>
                            </div>
                            <div style="padding: 10px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.FromAccount')</label>
                                    <div class="col-md-8">
                                        <v-select placeholder="@lang('layout.SelectFromAccount')" label="name" value="id" :options="{{ json_encode($account)}}"  @input="formUpdate" v-model="fromAccount" ></v-select>
                                        <input type="hidden" name="from_account" v-validate="'required'" data-vv-as="@lang('layout.SelectFromAccount')" :value="(fromAccount)?fromAccount.id:null">
                                        <span class="required">@{{ errors.first('from_account') }}</span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Currency') </label>
                                    <div class="col-md-8">
                                        <input type="text" name="from_currency" placeholder="@lang('layout.FromCurrency')" class="form-control" readOnly="readOnly" :value="(fromAccount)?fromAccount.currency:null" >
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Rate')</label>
                                    <div class="col-md-8">
                                        {{Form::number('fromRate',null,['class' => 'form-control', 'v-validate' =>'"required"', '@keyup'=>'editKey = true', '@click'=>'editKey = true', '@input'=>'(editKey)?settransfered():""', 'data-vv-as' => __('layout.Amount'),'v-model'=>'(!fromAccount)?null:fromAccount.rate','placeholder'=>__('layout.CurrencyRate'),':readOnly' => '(fromAccount)?(fromAccount.currency == "'.getHomeCurrency()["code"].'")?true:false:null','step'=>'0.001'])}}
                                        <span class="required">@{{ errors.first('fromRate') }}</span>
                                    </div>
                                </div> 
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.TotalAmount')</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" readOnly :value="(!fromAccount)?null:fromAccount.balance - transferAmount " placeholder="@lang('layout.TotalAmount')"> 
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Amount')</label>
                                    <div class="col-md-8">
                                        <vue-numeric
                                            class="form-control"
                                            v-model="transferAmount"
                                            :max="99999999999999"
                                            :currency="(fromAccount)?fromAccount.currency:''"
                                            :precision="precision()"
                                            @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?(settransfered(),calculateCamition()):''"
                                            >
                                        </vue-numeric>
                                        <input type="hidden" name="transfer_amount" class="form-control" v-model="transferAmount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                        <span class="required">@{{ errors.first('transfer_amount') }}</span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Date')</label>
                                    <div class="col-md-8">
                                        <input type="text" name="date"  class="form-control date" value="{{$transfer->Date}}" autocomplete="off"  @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                        <span class="required">@{{ errors.first('date') }}</span>
                                    
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Description')</label>
                                    <div class="col-md-8">
                                        {{Form::textArea('second_description',null,['class' => 'form-control' ,'rows' =>'2'])}}
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.ReferenceName')</label>
                                        <div class="col-md-3">
                                            <input type="text" name="referencen_name" id="referencen_name" value="{{$transfer->referencen_name}}"  class="form-control" autocomplete="off">
                                        </div>
                                        <label class="control-label col-md-2">@lang('layout.ReferenceNumber')</label>
                                        <div class="col-md-3">
                                            <input type="text" name="referencen_number" id="referencen_number" value="{{$transfer->referencen_number}}" class="form-control" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group" style="display: flex;justify-content: center;align-items: center;">
                                    @if(getAverageRate() == "true")
                                    <div class="col-lg-6">
                                        <div class="col-lg-12 col-md-12 col-sm-12 mt-checkbox" style="display: flex; justify-content: center;align-items: center;">
                                            <label class=" control-label">@lang('layout.InactiveAverageRate')</label>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="average_rate" @click="set_average_rate()" v-model="average_rate" value="on" @checked($transfer->average_rate) >
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                    @if(systemConfig()[29] == 1)
                                    <div class="col-lg-6">
                                        <div class="col-lg-12 col-md-12 col-sm-12 mt-checkbox" style="display: flex; justify-content: center;align-items: center;">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="transaction_confirm" v-model="show_transaction_confirm_checked" value="On" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')" >
                                                <span></span>
                                            </label>
                                        </div>
                                        <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div> 
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <div class="col-xs-12 col-sm-12 col-md-12" style="padding: 10px 0px 20px 0px;">
                                <label class="control-label col-md-3"></label>
                                <div  class="col-md-8 text-center">
                                    <span class="caption-subject font-green-haze bold uppercase" style="font-size: 1.5em;"> @lang('layout.ToAccount') </span>
                                </div>
                            </div>
                            <div style="padding: 23px 10px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.ToAccount')</label>
                                    <div class="col-md-8">
                                        <v-select placeholder="@lang('layout.SelectToAccount')" label="to_account" value="id" :options="toBank" @input="formUpdate" v-model="toAccount" ></v-select>
                                        <input type="hidden" name="to_account" v-validate="'required'" data-vv-as="@lang('layout.SelectToAccount')" :value="(toAccount)?toAccount.to_id:null">
                                        <span class="required">@{{ errors.first('to_account') }}</span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Currency')</label>
                                    <div class="col-md-8">
                                        <input type="text" name="to_currency" class="form-control" placeholder="@lang('layout.ToCurrency')" readonly :value="(toAccount)?toAccount.to_currency:null">
                                    </div>
                                </div>  
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Rate')</label>
                                    <div class="col-md-8">
                                        {{Form::number('to_rate',null,['class' =>'form-control', '@keyup'=>'editKey = true', '@click'=>'editKey = true', '@input'=>'(editKey)?settransfered():""',
                                        'placeholder'=>__('layout.CurrencyRate'),':readOnly' => '(toAccount)?(toAccount.to_currency == "'.getHomeCurrency()["code"].'")?true:false:null','v-model'=>'(!toAccount)?null:toAccount.to_rate'])}}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.TotalAmount')</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" readOnly :value="(!toAccount)?null:Number(toAccount.to_balance)+Number(transferedAmount)" placeholder="@lang('layout.TotalAmount')">
    
                                    </div>
                                </div>

                                <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.TranferAmount')</label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <vue-numeric
                                                :disabled='(toAccount)?(toAccount.to_currency == "{{getHomeCurrency()['code']}}" && !change_amount):null'
                                                class="form-control"
                                                v-model="transferedAmount"
                                                :max="99999999999999"
                                                :currency="(toAccount)?toAccount.to_currency:''"
                                                :precision="precision()"
                                                @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?(set_rate(),calculateCamition()):''"
                                                >
                                            </vue-numeric>
                                            <input type="hidden" class="form-control" name="transferedAmount" v-model="transferedAmount" placeholder="@lang('layout.TranferAmount')">
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="change_amount" v-model="change_amount" title="{{ __('layout.SelectAmountByExchangedAmount') }}">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Description')</label>
                                    <div class="col-md-8">
                                        {{Form::textArea('description',null,['class' => 'form-control' ,'rows' =>'2'])}}
                                    </div>
                                </div> 
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Number')</label>
                                    <div class="col-md-8">
                                        <input type="number" class="form-control" name="number" v-validate="'required'" value="{{ $transfer->number }}"
                                                data-vv-as="@lang('layout.Number')" />
                                        <span class="required">@{{ errors.first('number') }}</span>
                                    </div>
                                </div>
                                @if(systemConfig()[5] != 0 )
                                <div class="form-group">
                                    <label class="control-label col-md-3"> @lang('layout.SelectProject')</label>
                                    <div class="col-md-8">
                                        <v-select label="name" v-model="selectedProject" :options="project_items" @search="ProjectSearch"></v-select>
                                        <input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.id">
                                    </div>
                                </div>
                                @endif
                                @if(systemConfig()[20] == 1)
                                <div class="form-group" style="margin-top: 10px;">
                                    <label class="control-label col-md-3">@lang('layout.ContractName')</label>
                                    <div class="col-md-8">
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="contract">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                </div> 
                                @endif 
                                
                                <div class="form-group">
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                        <label class="control-label col-md-3">@lang('layout.MonetarySource')</label>
                                        <div class="col-md-3">
                                            {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                        </div>
                                        <label class="control-label col-md-2">@lang('layout.TransactionType')</label>
                                        <div class="col-md-3">
                                            {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if(getcommission() =="true")
                            <div class="col-md-12" style="margin: 15px 0px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Expense') </label>
                                    <v-select label="name" :options="expense"
                                                v-model="selectedExpense" ></v-select>
                                    <input type="hidden" name="expense_id" v-bind:value="(!selectedExpense)?null:selectedExpense.id" />
                                </div> 
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Commission')</label>
                                    <vue-numeric
                                        class="form-control"
                                        v-model="commission_amount"
                                        :max="99999999999999"
                                        :currency="(fromAccount)?fromAccount.currency:''"
                                        :precision="precision()"
                                        >
                                    </vue-numeric>
                                    <input type="hidden" name="commission_amount" class="form-control" v-model="commission_amount" placeholder="@lang('layout.Amount')">
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Percentage') @lang('layout.Commission')</label>
                                    <input type="number" step="any" v-model="camition_percentage" @input="calculateCamition()" class="form-control" autocomplete="off" max="100" name="percentage">
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('commission_description',$transfer->comm_description,['class'=>'form-control','rows'=>'1'])}}
                                </div>
                                <br/>
                                <br/>
                                <br/>
                                <br/>
                            </div>
                        @endif
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                        <!-- <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button> -->
                        <a @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</a>
                        <a href="{{route('transferAccounts.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts')
<script> 
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    
    var expense = {!! $expense !!};
    let bankes = {!!$account!!};
    let contract = {!!$contract!!};
    let transfer = {!!$transfer!!};

    Vue.component('v-select', VueSelect.VueSelect);
    Vue.use(VueNumeric.default);

    let vu = new Vue({
        el: '#app', 
        data: {
            selectedContract: null,
            contract: contract,
            fromAccount:null,
            toAccount:null,
            transferAmount:{!!$transfer->transfer_amount!!},
            transfer:{!!$transfer!!},
            bankList: {!! $account !!},
            fromBank: {!! $account !!},
            toBank: [],
            transferedAmount: {!!$transfer->transfered_amount!!},
            transfered: 0,
            editKey: false,
            toBankTemp: {!! $to_account !!},
            oldAccounts:{!!$transfer!!},
            expense: expense,
            selectedExpense: null,
            transfered_amount:{!!$transfer->transfered_amount!!},
            show_transaction_confirm_checked: "{{$transfer->transaction_confirm == 'On'}}",
            project_items: [],
            selectedProject: {!!$selectProject!!},
            selectedFrom:null,
            selectedTo:null,
            FromCurrency:null,
            to_currency:null,
            to_rate:{!!$transfer->to_rate!!},
            flag:0,
            flagToAccount:0,
            commission_amount: 0,
            camition_percentage: null,
            averageRate: false,
            average_rate: false,
            change_amount: false,
             
        },
        created:function(){
            this.flag=1;
            this.toBank=this.toBankTemp;
        },
   
        computed: {
             
          
        },
        mounted:function(){
            
            @if($transfer->contract_id != null)    
            this.selectedContract = _.find(this.contract, (e) => e.id == {{$transfer->contract_id}});
            @endif
 

            this.fromAccount    = _.find({!! json_encode($account)  !!}, (o) => o.id == {{$transfer->from_id}});
            this.fromAccount.rate=this.transfer.fromRate;

            this.toAccount = _.find({!! json_encode($to_account)  !!}, (o) => o.to_id == {{$transfer->to_id}}); 
            var temp=[];

            for(var w=0;w<this.toBank.length;w++){
                if(this.toBank[w].to_id !=this.fromAccount.id)
                {
                   temp.push(this.toBank[w]);
                }
            } 
            this.toBank=temp;
            if(this.flag){
                
                this.toAccount.to_rate=this.to_rate;

                this.flag=0;
            }
            if(this.transfer.expense_id)
            {
                this.selectedExpense = _.find(this.expense, (c) => c.id == this.transfer.expense_id);
            }
            
            if(this.transfer.commAmount)
            {
                this.commission_amount = this.transfer.commAmount;
            }
            

            if(this.transfer.comm_percentage)
            {
                this.camition_percentage = this.transfer.comm_percentage;
            }
            
            if(this.transfer.average_rate)
            {
                this.average_rate = this.transfer.average_rate;
            }

            var tr = this.transfered_amount;
            // if(this.toAccount && this.fromAccount) {
            //     tr = this.transferAmount * this.toAccount.to_rate / this.fromAccount.rate
            // }
            this.transferedAmount = tr.toFixed(precision());
                
        },
        methods: {

            calculateCamition(){
                var camition_percentage = this.camition_percentage;
                var amount = this.transferAmount;
                if (camition_percentage && amount) {
                    this.commission_amount = (camition_percentage * amount) / 100;
                }
                else{
                    this.commiss_amount = '';
                }
            },

            // Search Project 
            ProjectSearch: _.debounce((search, loading) => {
                vu.project_items = [];
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        keyword: search,
                        table_name: 'projects',
                        'search_column': 'name',
                        'user_type': 'yes',
                    }
                })
                .then(function(response) {
                    this.project_items = [];
                    if (response.data.length > 0) {
                        vu.project_items = response.data;
                        // console.log('test 22', vu.project_items);
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                });
            }, getDebounceTime()),
            
            handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                        
                                regForm(e.target);
                        }
                    });
                },

                set_rate() {
                //     let vu = this;
                // if (vu.change_amount) {
                //     if (vu.transferedAmount > 0 && vu.toAccount && vu.fromAccount) {
                //         if (vu.toAccount.to_rate > 0 && vu.fromAccount.rate > 0 ) {
                //             // vu.transferAmount = myRound((vu.transferedAmount / vu.toAccount.rate) * vu.fromAccount.rate);
                //             @if(systemConfig()[30] == 1)
                //                 vu.transferAmount = myRound(((vu.transferedAmount / vu.toAccount.static_rate * toAccount.to_rate) * vu.fromAccount.static_rate) / vu.fromAccount.rate);
                //             @else
                //                 vu.transferAmount = myRound((vu.transferedAmount / vu.toAccount.to_rate) * vu.fromAccount.rate);
                //             @endif  
                //         }
                //     }
                // } else {
                //     if (vu.transferedAmount > 0 && vu.transferAmount > 0 && vu.toAccount && vu.fromAccount) {
                //         if (vu.toAccount.currency == "{{getHomeCurrency()['code']}}") {
                //             vu.toAccount.to_rate = 1;
                //         } else {
                //             @if(systemConfig()[30] == 1)
                //             vu.toAccount.to_rate = myRound(((vu.transferedAmount / vu.transferAmoun / vu.fromAccount.static_rate * vu.fromAccount.rate) / vu.transferAmount) * vu.toAccount.static_rate);
                //             @else 
                //             vu.toAccount.to_rate = myRound((vu.transferedAmount) / (vu.transferAmount / vu.fromAccount.rate));
                //             @endif
                //         }
                //     }
                // }
                let vu = this;
                if (vu.change_amount) {
                    // console.log(11, vu.transferedAmount, vu.toAccount, vu.fromAccount);
                    if (vu.transferedAmount > 0 && vu.toAccount && vu.fromAccount) {
                        if (vu.toAccount.to_rate > 0 && vu.fromAccount.rate > 0 ) {
                            @if(systemConfig()[30] == 1)
                            // vu.transferAmount = myRound((vu.transferedAmount / vu.toAccount.to_rate) * vu.fromAccount.rate);
                            vu.transferAmount = myRound(((vu.transferedAmount / vu.toAccount.static_rate * toAccount.to_rate) * vu.fromAccount.static_rate) / vu.fromAccount.rate);
                            @else 
                            vu.transferAmount = myRound((vu.transferedAmount / vu.toAccount.to_rate) * vu.fromAccount.rate);
                            @endif
                        }
                    }
                } else {
                    if (vu.transferedAmount > 0 && vu.transferAmount > 0 && vu.toAccount && vu.fromAccount) {
                        if (vu.toAccount.currency == "{{getHomeCurrency()['code']}}") {
                            vu.toAccount.to_rate = 1;
                        } else {
                            @if(systemConfig()[30] == 1)
                            vu.toAccount.rate = myRound(((vu.transferedAmount / vu.transferAmoun / vu.fromAccount.static_rate * vu.fromAccount.rate) / vu.transferAmount) * vu.toAccount.static_rate);
                            @else 
                            vu.toAccount.to_rate = myRound((vu.transferedAmount) / (vu.transferAmount / vu.fromAccount.rate));
                            @endif
                        }
                    }
                }
            },

            settransfered() {
                var tr = 0;
                if (this.toAccount && this.fromAccount) {
                    // tr = this.transferAmount * this.toAccount.to_rate / this.fromAccount.rate 
                    // this.transferedAmount = tr.toFixed(7);
                    if (this.toAccount && this.fromAccount) {
                    @if(systemConfig()[30] == 1)
                    // console.log(this.toAccount.static_rate);
                    this.transferedAmount = myRound(((this.transferAmount / this.fromAccount.static_rate * this.fromAccount.rate) * this.toAccount.static_rate) / this.toAccount.to_rate);
                    // console.log(this.transferedAmount);
                    @else 
                    this.transferedAmount = this.transferAmount * this.toAccount.to_rate / this.fromAccount.rate;
                    @endif 
                }
                }
            },
            
            formUpdate:function () {
                    this.fromBank = this.bankList.slice();
                    this.toBank   = this.toBank.slice();

                    if (this.fromAccount) {
                   
                        this.fromBank.splice(this.fromBank.findIndex(item => item.id == this.fromAccount.id), 1);
                         var temp=[];

                          for(var w=0;w<this.toBankTemp.length;w++){
                            if(this.toBankTemp[w].to_id !=this.fromAccount.id)
                            {
                               
                                    temp.push(this.toBankTemp[w]);
                            }
                        } 
                        this.toBank=temp;
                   
                        // if(this.flagToAccount==0)
                        // {
                        //     this.flagToAccount=1;
                        // }
                        // else
                        // {
                        //     this.toAccount=this.toBank[0]; 
                        // }
                        
                        // this.toBankTemp.splice(this.toBank.findIndex(item => item.to_id == this.fromAccount.id));
                        // this.toBank=this.toBankTemp;
                    }
                    if(this.toAccount){
                       
                        this.fromBank.splice(this.fromBank.findIndex(item => item.id == this.toAccount.to_id), 1)
                        // this.toBank.splice(this.toBank.findIndex(item => item.to_id == this.toAccount.to_id), 1)
                    }
                       
                      
                    
                },

                set_average_rate() {
                    let vu = this;
                    setTimeout(() => {
                        if (vu.average_rate) {
                            vu.bankList = bankes;
                            console.log(32, vu.fromAccount);
                            if (vu.fromAccount) {
                                vu.bankList.forEach((bank) => {
                                    if (vu.fromAccount.id == bank.id) {
                                        vu.fromAccount.rate = bank.rate;
                                        if (vu.toAccount) {
                                            if (vu.toAccount.to_currency == bank.currency) {
                                                vu.toAccount.to_rate = bank.rate;
                                                vu.transferedAmount = vu.transferAmount;
                                            }
                                        }
                                    }
                                });
                            }     
                        }
                    }, 200);
                },


              
}

});
</script>
@endpush

