@extends('layouts.app')
@section('content')
<div class="row">
    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.TransferAccount') </span>
            </div>
            <div class="tools"> 
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'transferAccounts.store','method'=>'POST','id' => 'transferAccount-form', 'class'=>'form-horizontal')) !!}
            {{ csrf_field() }}
            <div id="app" v-cloak> 
                <div class="form-body">
                    <div class="row text-center">
                        <i class="font-green-haze fa fa-exchange" style="font-size: 1.6em;"></i>
                        <span class="caption-subject font-green-haze bold uppercase" style="font-size: 1.6em;">@lang('layout.TransferandExchangeCurrency') </span>
                    </div>
                    <br>
                    <br>
                    <div class="row">
                        <div class="col-lg-6 col-md-12 col-sm-12 margin-bottom-10">
                            <div class="col-xs-12 col-sm-12 col-md-12" style="padding: 10px 0px 20px 0px;">
                                <label class="control-label col-md-3"></label>
                                <div class="col-md-8 text-center"> 
                                    <span class="caption-subject font-green-haze bold uppercase" style="font-size: 1.5em;"> 
                                        @lang('layout.FromAccount')</span>
                                </div>
                            </div>
                            <div style="padding: 10px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.FromAccount')</label>
                                        <div class="col-md-8">
                                            <v-select placeholder="@lang('layout.SelectFromAccount')" label="name" value="id" :options="fromBank" @input="formUpdate" v-model="fromAccount"></v-select>
                                            <input type="hidden" name="from_account" v-validate="'required'" data-vv-as="@lang('layout.SelectFromAccount')" :value="(fromAccount)?fromAccount.id:null">
                                            <span class="required">@{{ errors.first('from_account') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.Currency') </label>
                                        <div class="col-md-8">
                                            <input type="text " placeholder="@lang('layout.Currency')" class="form-control" disabled="disabled" :value="(fromAccount)?fromAccount.currency:null">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.Rate')</label>
                                        <div class="col-md-8">
                                            {{Form::number('from_rate',null,['class' => 'form-control', 'v-validate' =>'"required"', '@input'=>'transfered()', 'data-vv-as' => __('layout.Rate') ,'v-model'=>'(!fromAccount)?null:fromAccount.rate','placeholder'=>__('layout.CurrencyRate'),':disabled' => '(fromAccount)?(fromAccount.currency == "'.getHomeCurrency()['code'].'")?true:false:null','step'=>'0.001'])}}
                                            <span class="required">@{{ errors.first('from_rate') }}</span>
                                        </div>
                                    </div> 
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.TotalAmount')</label>
                                        <div class="col-md-8">
                                            <input type="text" class="form-control" disabled :value="(!fromAccount)?null:fromAccount.balance - transferAmount " placeholder="@lang('layout.TotalAmount')">
                                        </div>
                                    </div> 
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.Amount')</label>
                                        <div class="col-md-8">
                                            <vue-numeric
                                                class="form-control"
                                                v-model="transferAmount"
                                                :max="99999999999999"
                                                :currency="(fromAccount)?fromAccount.currency:''"
                                                :precision="precision()"
                                                @input="transfered(), calculateCamition()"
                                                >
                                            </vue-numeric>
                                            <input type="hidden" name="transfer_amount" class="form-control" v-model="transferAmount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                            <span class="required">@{{ errors.first('transfer_amount') }}</span>
                                        </div>
                                    </div> 
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.Date')</label>
                                        <div class="col-md-8">
                                            <input type="text" name="date" id="getdate" class="form-control date" autocomplete="off" @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                            <span class="required">@{{ errors.first('date') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.Description')</label>
                                        <div class="col-md-8">
                                            {{Form::textArea('second_description',null,['class' => 'form-control' ,'rows' =>'2'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">@lang('layout.ReferenceName')</label>
                                        <div class="col-md-3">
                                            <input type="text" name="referencen_name" id="referencen_name" class="form-control" autocomplete="off">
                                        </div>
                                        <label class="control-label col-md-2">@lang('layout.ReferenceNumber')</label>
                                        <div class="col-md-3">
                                            <input type="text" name="referencen_number" id="referencen_number" class="form-control" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group" style="display: flex;justify-content: center;align-items: center;">
                                    @if(getAverageRate() == "true")
                                    <div class="col-lg-6">
                                        <div class="col-lg-12 col-md-12 col-sm-12 mt-checkbox" style="display: flex; justify-content: center;align-items: center;">
                                            <label class=" control-label">@lang('layout.InactiveAverageRate')</label>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="average_rate" @click="set_average_rate()" v-model="average_rate" value="on">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                    @if(systemConfig()[29] == 1)
                                    <div class="col-lg-6">
                                        <div class="col-lg-12 col-md-12 col-sm-12 mt-checkbox" style="display: flex; justify-content: center;align-items: center;">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="transaction_confirm" value="On" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')" >
                                                <span></span>
                                            </label>
                                        </div>
                                        <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <div class="col-xs-12 col-sm-12 col-md-12" style="padding: 10px 0px 20px 0px;">
                                <label class="control-label col-md-3"></label>
                                <div class="col-md-8 text-center">
                                    <span class="caption-subject font-green-haze bold uppercase" style="font-size: 1.5em;"> @lang('layout.ToAccount') </span>
                                </div>
                            </div> 
                            <div style="padding: 20px 10px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.ToAccount')</label>
                                    <div class="col-md-8">
                                        <v-select placeholder="@lang('layout.SelectToAccount')" label="name" value="id" :options="toBank" @input="formUpdate" v-model="toAccount"></v-select>
                                        <input type="hidden" name="to_account" :value="(toAccount)?toAccount.id:null" v-validate="'required'" data-vv-as="@lang('layout.SelectToAccount')">
                                        <span class="required">@{{ errors.first('to_account') }}</span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Currency')</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" placeholder="@lang('layout.ToCurrency')" disabled :value="(toAccount)?toAccount.currency:null">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Rate')</label>
                                    <div class="col-md-8">
                                        {{Form::text('to_rate',null,['class' => 'form-control', 'v-model'=>'(!toAccount)?null:toAccount.rate', '@input'=>'transfered()',
                                        'placeholder'=>__('layout.CurrencyRate'),':disabled' => '(toAccount)?(toAccount.currency == "'.getHomeCurrency()['code'].'")?true:false:null'])}}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.TotalAmount')</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" disabled :value="(!toAccount)?null:Number(toAccount.balance)+Number(transferedAmount) " placeholder="@lang('layout.TotalAmount')">
        
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.TranferAmount')</label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <vue-numeric
                                                :disabled='(toAccount)?(toAccount.currency == "{{getHomeCurrency()['code']}}" && !change_amount):null'
                                                class="form-control"
                                                v-model="transferedAmount"
                                                :max="99999999999999"
                                                :currency="(toAccount)?toAccount.currency:''"
                                                :precision="precision()"
                                                @input="set_rate(), calculateCamition()"
                                                >
                                            </vue-numeric>
                                            <input type="hidden" class="form-control" name="transferedAmount" v-model="transferedAmount" placeholder="@lang('layout.TranferAmount')">
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="change_amount" v-model="change_amount" title="{{ __('layout.SelectAmountByExchangedAmount') }}">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Description')</label>
                                    <div class="col-md-8">
                                        {{Form::textArea('description',null,['class' => 'form-control' ,'rows' =>'2'])}}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Number')</label>
                                    <div class="col-md-8">
                                        <input type="number" class="form-control" name="number" v-validate="'required'" value="{{ $number }}" data-vv-as="@lang('layout.Number')" />
                                        <span class="required">@{{ errors.first('number') }}</span>
                                    </div>
                                </div>
                                @if(systemConfig()[5] != 0 )
                                <div class="form-group">
                                    <label class="control-label col-md-3"> @lang('layout.SelectProject')</label>
                                    <div class="col-md-8">
                                        <v-select label="name" v-model="selectedProject" :options="project_items" @search="ProjectSearch"></v-select>
                                        <input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.id">
                                    </div>
                                </div>
                                @endif
                                @if(systemConfig()[20] == 1)
                                <div class="form-group" style="margin-top: 10px;">
                                    <label class="control-label col-md-3">@lang('layout.ContractName')</label>
                                    <div class="col-md-8">
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="{{$contract}}">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                </div> 
                                @endif 
                                <div class="form-group">
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                        <label class="control-label col-md-3">@lang('layout.MonetarySource')</label>
                                        <div class="col-md-3">
                                            {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                        </div>
                                        <label class="control-label col-md-2">@lang('layout.TransactionType')</label>
                                        <div class="col-md-3">
                                            {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    @if(getcommission() =="true")
                    <div class="col-md-12" style="margin: 15px 0px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.Expense') </label>
                            <v-select label="name" :options="expense" v-model="selectedExpense"></v-select>
                            <input type="hidden" name="expense_id" v-bind:value="(!selectedExpense)?null:selectedExpense.id" />
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.Commission')</label>
                            <vue-numeric
                                class="form-control"
                                v-model="commission_amount"
                                :max="99999999999999"
                                :currency="(fromAccount)?fromAccount.currency:''"
                                :precision="precision()"
                                >
                            </vue-numeric>
                            <input type="hidden" name="commission_amount" class="form-control" v-model="commission_amount" placeholder="@lang('layout.Amount')">
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.Percentage') @lang('layout.Commission')</label>
                            <input type="number" step="any" v-model="camition_percentage" @input="calculateCamition()" class="form-control" autocomplete="off" max="100" name="percentage">
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.Description')</label>
                            {{Form::textarea('commission_description',null,['class'=>'form-control','rows'=>'1'])}}
                        </div>
                        <br />
                        <br />
                        <br />
                        <br />
                    </div>
                    @endif
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button> -->
                    <a @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</a>
                    <button type="button" class="btn blue" :disabled="disabled" @click="checkOldList($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('transferAccounts.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('v-select', VueSelect.VueSelect);
    Vue.use(VueNumeric.default);

    let rates = {!! json_encode(getExchangeRate()) !!};
    let expense = {!! $expense !!};
    let bankes = {!!$account!!};
    let contract = {!!$contract!!};

    let vu = new Vue({
        el: '#app',
        data: {
            selectedContract: null,
            expense: expense,
            selectedExpense: null,
            fromAccount: null,
            toAccount: null,
            transferAmount: null,
            transferedAmount: 0,
            bankList: {!!$account!!},
            fromBank: {!!$account!!},
            toBank: {!!$account!!},
            project_items: [],
            selectedProject: null,
            commission_amount: 0,
            camition_percentage: null,
            change_amount: false,
            averageRate: false,
            average_rate: false,
            disabled: false,
        },
        computed: {
            // transfered: function () {
            //     var tr = 0
            //     if(this.toAccount && this.fromAccount) {
            //        tr = this.transferAmount * this.toAccount.rate / this.fromAccount.rate
            //     }
            //     this.transferedAmount = tr;
            //     return tr.toFixed(4);
            // }, 
        },
        created() {
            this.setRate();
        },
        methods: { 
            calculateCamition(){
                var camition_percentage = this.camition_percentage;
                var amount = this.transferAmount;
                if (camition_percentage && amount) {
                    this.commission_amount = (camition_percentage * amount) / 100;
                }
                else{
                    this.commiss_amount = '';
                }
            },

            // Search Project 
            ProjectSearch: _.debounce((search, loading) => {
                vu.project_items = [];
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        keyword: search,
                        table_name: 'projects',
                        'search_column': 'name',
                        'user_type': 'yes',
                    }
                })
                .then(function(response) {
                    this.project_items = [];
                    if (response.data.length > 0) {
                        vu.project_items = response.data;
                        // console.log('test 22', vu.project_items);
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                });
            }, getDebounceTime()),
            
            handleSubmit(e) { 
                this.$validator.validate()
                    .then(valid => {
                    if (valid) {
                var date = document.getElementById('getdate').value;
                var amount = this.transferAmount;
                if (this.fromAccount && this.toAccount && amount) {
                    vu.disabled = true;
                    var from_account = this.fromAccount.id;
                    var toAccount = this.toAccount.id;
                // console.log(bank , currencies , expense , date_value , amount_check);
                axios.get("{{route('transferAccount.checkOldValue')}}", {
                    params: {
                        from_account: from_account,
                        toAccount: toAccount,
                        date: date,
                        amount: amount,
                    }}).then(function (response) {
                        if (response.data) {
                            swal({
                            title: "{{__('layout.DuplicateData')}}",
                            text: "",  
                            icon: "warning",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                            warningMode: true,
                        })
                            .then((willDelete) => {
                                if (willDelete) {
                                    vu.submitTransferAccunt(e.target);
                                    vu.disabled = false;
                                } else {
                                    vu.disabled = false;
                                }
                            });
                        }else{                                
                            vu.submitTransferAccunt(e.target); 
                            vu.disabled = false;        
                        }
                        }) .catch(function (error) {
                            vu.disabled = false;
                            console.log(error);
                })
            }
                else {
                        vu.disabled = false;
                    }   
                }
                    });
            },
            formUpdate: function() {
                this.fromBank = this.bankList.slice();
                this.toBank = this.bankList.slice();
                if (this.fromAccount) {
                    this.fromBank.splice(this.fromBank.findIndex(item => item.id == this.fromAccount.id), 1)
                    this.toBank.splice(this.toBank.findIndex(item => item.id == this.fromAccount.id), 1)
                }
                if (this.toAccount) { 
                    this.fromBank.splice(this.fromBank.findIndex(item => item.id == this.toAccount.id), 1)
                    this.toBank.splice(this.toBank.findIndex(item => item.id == this.toAccount.id), 1)
                }
                this.transfered();
            },
            submitTransferAccunt: function() { 
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("transferAccount-form").submit() 
                    } else {

                    }
                });
            },
            setRate() {
                if (!this.average_rate) {
                    this.bankList.forEach((bank) => {
                        rates.forEach((rate) => {
                            if (rate.code == bank.currency) {
                                bank.rate = rate.rate;
                            }
                        })
                    });
                }
                rates.forEach((rate) => {
                    if (!this.average_rate) {
                        this.fromBank.forEach((bank) => {
                            if (rate.code == bank.currency)
                                bank.rate = rate.rate;
                        });
                    }

                    this.toBank.forEach((bank) => {
                        if (rate.code == bank.currency)
                            bank.rate = rate.rate;

                    });
                });
                // console.log('rates',rates);
                // console.log('bank list',this.bankList);
            },
            set_rate() {
                let vu = this;
                if (vu.change_amount) {
                    if (vu.transferedAmount > 0 && vu.toAccount && vu.fromAccount) {
                        if (vu.toAccount.rate > 0 && vu.fromAccount.rate > 0 ) {
                            // vu.transferAmount = myRound((vu.transferedAmount / vu.toAccount.rate) * vu.fromAccount.rate);
                            @if(systemConfig()[30] == 1)
                                vu.transferAmount = myRound(((vu.transferedAmount / vu.toAccount.static_rate * toAccount.rate) * vu.fromAccount.static_rate) / vu.fromAccount.rate);
                            @else
                                vu.transferAmount = myRound((vu.transferedAmount / vu.toAccount.rate) * vu.fromAccount.rate);
                            @endif 
                        }
                    }
                } else {
                    if (vu.transferedAmount > 0 && vu.transferAmount > 0 && vu.toAccount && vu.fromAccount) {
                        if (vu.toAccount.currency == "{{getHomeCurrency()['code']}}") {
                            vu.toAccount.rate = 1;
                        } else {
                            @if(systemConfig()[30] == 1)
                            vu.toAccount.rate = myRound(((vu.transferedAmount / vu.transferAmoun / vu.fromAccount.static_rate * vu.fromAccount.rate) / vu.transferAmount) * vu.toAccount.static_rate);
                            @else 
                            vu.toAccount.rate = myRound((vu.transferedAmount) / (vu.transferAmount / vu.fromAccount.rate));
                            @endif
                        }
                    }
                }
            },
            set_average_rate() {
                let vu = this;
                setTimeout(() => {
                    if (vu.average_rate) {
                        vu.bankList = bankes;

                        if (vu.fromAccount) {
                            vu.bankList.forEach((bank) => {
                                if (vu.fromAccount.id == bank.id) {
                                    vu.fromAccount.rate = bank.rate;
                                    if (vu.toAccount) {
                                        if (vu.toAccount.currency == bank.currency) {
                                            vu.toAccount.rate = bank.rate;
                                            vu.transferedAmount = vu.transferAmount;
                                        }
                                    }
                                }
                            });
                        }     
                    }
                }, 200);
            },
            transfered() {
                var tr = 0
                if (this.toAccount && this.fromAccount) {
                    @if(systemConfig()[30] == 1)
                    this.transferedAmount = myRound(((this.transferAmount / this.fromAccount.static_rate * this.fromAccount.rate) * this.toAccount.static_rate) / this.toAccount.rate);
                    // console.log(this.transferedAmount);
                    @else 
                    this.transferedAmount = this.transferAmount * this.toAccount.rate / this.fromAccount.rate;
                    @endif 
                }

                // this.transferedAmount = tr.toFixed(4);
 
                     

            },


            saveAndNew() {
                vu.disabled = true;
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            var url = "{{route('transferAccounts.store')}}";
                            form_id = 'transferAccount-form';
                            var data = $('#' + form_id).serialize();
                            // console.log(444, data);
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');

                                        toastr.success('', response.data.message);
                                        location.reload();
                                        vu.disabled = false;

                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        vu.disabled = false;
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    vu.disabled = false;
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },

            checkOldList(){ 
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                var date = document.getElementById('getdate').value;
                var amount = this.transferAmount;
                if (this.fromAccount && this.toAccount && amount) {
                    vu.disabled = true;
                    var from_account = this.fromAccount.id;
                    var toAccount = this.toAccount.id;
                // console.log(from_account , toAccount , date, amount); 
                axios.get("{{route('transferAccount.checkOldValue')}}", {
                        params: {
                            from_account: from_account,
                            toAccount: toAccount,
                            date: date,
                            amount: amount,
                    }}).then(function (response) {
                            // console.log(response.data);
                            if (response.data) {
                                swal({
                                title: "{{__('layout.DuplicateData')}}",
                                text: "",
                                icon: "warning",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                infoMode: true,
                            })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        vu.saveAndNew(); 
                                    } else {
                                        vu.disabled = false;
                                    }
                                });
                            }else{
                                vu.saveAndNew(); 
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                            vu.disabled = false;
                        }) 
                    }
                    else {
                        vu.disabled = false;
                    } 
                }
                    });
                    }, 
                 onComplete: function() {
                document.getElementById("account-form").submit() 
            },
            
        }

    })
</script>

@endpush