
@extends('layouts.factor-master')

@section('content')
<?php

$report = customeReportNew('transfer_account_index');

$_number= !in_array('number', $report);
$_date= !in_array('date', $report);
$_from_account= !in_array('from_account', $report);
$_from_currency= !in_array('from_currency', $report);
$_from_rate= !in_array('from_rate', $report);
$_from_amount= !in_array('from_amount', $report);
$_to_account= !in_array('to_account', $report);
$_to_currency= !in_array('to_currency', $report);
$_to_rate= !in_array('to_rate', $report);
$_to_amount= !in_array('to_amount', $report);
$_total= !in_array('total', $report);
$_user= !in_array('user', $report);
$_transaction_confirm= !in_array('transaction_confirm', $report);

$report_percent = customeReportNewPercent('transfer_account_index');
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_from_account_percent= (array_key_exists('from_account___percent', $report_percent))?$report_percent['from_account___percent']:null;
    $_from_currency_percent= (array_key_exists('from_currency___percent', $report_percent))?$report_percent['from_currency___percent']:null;
    $_from_rate_percent= (array_key_exists('from_rate___percent', $report_percent))?$report_percent['from_rate___percent']:null;
    $_from_amount_percent= (array_key_exists('from_amount___percent', $report_percent))?$report_percent['from_amount___percent']:null;
    $_to_account_percent= (array_key_exists('to_account___percent', $report_percent))?$report_percent['to_account___percent']:null;
    $_to_currency_percent= (array_key_exists('to_currency___percent', $report_percent))?$report_percent['to_currency___percent']:null;
    $_to_rate_percent= (array_key_exists('to_rate___percent', $report_percent))?$report_percent['to_rate___percent']:null;
    $_to_amount_percent= (array_key_exists('to_amount___percent', $report_percent))?$report_percent['to_amount___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_transaction_confirm_percent= (array_key_exists('transaction_confirm___percent', $report_percent))?$report_percent['transaction_confirm___percent']:null;

?>
 

  <h3 class="table-caption" style="text-align: center;">@lang('layout.TransferAccountsReport')</h3>
  <table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table> 
@if($from_account_name || $to_account_name || $currency || $ClassName || $transaction_confirm) 
<table   class="main-table">
  <tr>
    @if($from_account_name)
   <td>
    <span>@lang('layout.FromAccount')</span>: {{$from_account_name}}
  </td>
  @endif
  @if($to_account_name)
  <td>
    <span>@lang('layout.ToAccount')</span>: {{$to_account_name}}
  </td>
  @endif

  @if($ClassName)
  <td>
    <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
  </td>
  @endif

  @if($currency)
  <td>
    <span>@lang('layout.Currency')</span>: {{$currency}}
  </td>
  @endif
  @if($transaction_confirm)
    <td>
      <span>@lang('layout.TransactionConfirm')</span>:    @lang('layout.yes')
    </td>
    @endif 

</tr>
</table>
<br>
@endif
  <table class="main-table">
    <thead>
      <tr class="bg">  
      <td  class="center" ><div > @lang('layout.Record')</div></td>
      @if($_number) <td  class="center"  @if($_number_percent) width="{{$_number_percent}}%" @endif><div > @lang('layout.Number')</div></td>@endif
      @if($_number)<td  class="center"  @if($_number_percent) width="{{$_number_percent}}%" @endif><div > @lang('layout.TransactionQty')</div></td>@endif
      @if($_date)<td  class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.FirstTransaction')</div></td>@endif
      @if($_date)<td  class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.LastTransaction')</div></td>@endif
      @if($_from_account)<td  class="center"  @if($_from_account_percent) width="{{$_from_account_percent}}%" @endif><div > @lang('layout.FromAccount') </div></td>@endif
      @if($_from_currency)<td  class="center"   @if($_from_currency_percent) width="{{$_from_currency_percent}}%" @endif><div > @lang('layout.Currency')</div></td>@endif
      @if($_from_amount)<td  class="center"  @if($_from_amount_percent) width="{{$_from_amount_percent}}%" @endif><div > @lang('layout.Amount')</div></td>@endif
      @if($_from_rate)<td  class="center"  @if($_from_rate_percent) width="{{$_from_rate_percent}}%" @endif><div > @lang('layout.FromRate')</div></td>@endif
      @if($_from_amount)<td  class="center"  @if($_from_amount_percent) width="{{$_from_amount_percent}}%" @endif><div > @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}}</div></td>@endif
      @if(getcommission() =="true")<td  class="center" ><div > @lang('layout.Commission')</div></td>@endif
      @if($_to_account)<td  class="center"  @if($_to_account_percent) width="{{$_to_account_percent}}%" @endif><div > @lang('layout.ToAccount')</div></td>@endif
      @if($_to_currency)<td  class="center"  @if($_to_currency_percent) width="{{$_to_currency_percent}}%" @endif><div > @lang('layout.Currency')</div></td>@endif
      @if($_to_amount)<td  class="center"  @if($_to_amount_percent) width="{{$_to_amount_percent}}%" @endif><div > @lang('layout.Amount')</div></td>@endif
      @if($_to_rate)<td  class="center"  @if($_to_rate_percent) width="{{$_to_rate_percent}}%" @endif><div > @lang('layout.ToRate')</div></td>@endif
      @if($_to_amount)<td  class="center"  @if($_to_amount_percent) width="{{$_to_amount_percent}}%" @endif><div > @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}}</div></td>@endif
      @if(getAverageRate() == "true")<td  class="center" ><div > @lang('layout.GainOrLoss')  {{getHomeCurrency()[getCurrencyType()]}}</div></td>@endif
      @if(systemConfig()[29] == 1)
      @if(!$transaction_confirm)
      @if($_transaction_confirm)
      <td  class="center" @if($_transaction_confirm_percent) width="{{$_transaction_confirm_percent}}%" @endif>
        <div > @lang('layout.TransactionConfirm')</div>
      </td>
      @endif
      @endif
      @endif
      
      @if(systemConfig()[5] != 0 )<td  class="center" ><div > @lang('layout.Project')</div></td>@endif
      @if($_user)<td  class="center"  @if($_user_percent) width="{{$_user_percent}}%" @endif><div > @lang('layout.User')</div></td>@endif
    </tr>
    </thead>
    <tbody>
   <?php
  $count = 0;
  $total_home_currency=0;
  $total2_home_currency=0;
  $currencies=[];
  $secound_currencies=[];
  $comm_home_currency=0;
  $gain_loss=0;
  $comm_currencies=[];
  $colspan_from = 7;
  $colspan_to = 3;
  $totalFromAmount = 0;
  $totalToAmount = 0;
  ?>
  @foreach($data AS $record)
  <tr>
      <?php
      $total_home_currency+=$record->AmountBase;
      $total2_home_currency+=$record->To_amountBase;

      $totalFromAmount += $record->Amount;
      $totalToAmount += $record->To_amount;

    if(systemConfig()[30] == 1){
      // $comm_home_currency+=$record->commAmount / $record->comm_static_rate  *  $record->from_static_rate;
      $comm_home_currency+=$record->commAmount/$record->from_static_rate *$record->From_rate;
    }else{
      $comm_home_currency+=$record->commAmount/$record->From_rate;
    } 
      if ($record->gain_loss) {
        $gain_loss +=$record->gain_loss;
      }
        if(array_key_exists($record->From_currency, $currencies))
        {
            $currencies[$record->From_currency]['amount']=$currencies[$record->From_currency]['amount']+$record->Amount;
            $currencies[$record->From_currency]['base_amount']=($currencies[$record->From_currency]['base_amount'])+($record->AmountBase);
            $comm_currencies[$record->From_currency]=$comm_currencies[$record->From_currency]+$record->commAmount;
        }
        else
        {
            $currencies[$record->From_currency]['amount']=$record->Amount;
            $currencies[$record->From_currency]['base_amount']=$record->AmountBase;
            $comm_currencies[$record->From_currency]=$record->commAmount;
        } 

        if(array_key_exists($record->To_currency, $secound_currencies))
        {
            $secound_currencies[$record->To_currency]['amount']=$secound_currencies[$record->To_currency]['amount']+$record->To_amount;
            $secound_currencies[$record->To_currency]['base_amount']=($secound_currencies[$record->To_currency]['base_amount'])+($record->To_amountBase);
        }
        else
        {
            $secound_currencies[$record->To_currency]['amount']=$record->To_amount;
            $secound_currencies[$record->To_currency]['base_amount']=$record->To_amountBase;
        }
      ?>
      <td class="center">{{++$count}}</td>
      @if($_number) <td class="center">{{$record->number}}</td>@endif
      @if($_number)<td  class="center">{{$record->To_count}}</td>@endif
      @if($_date)<td  class="center">{{convertDate($record->min_date)}}</td>@endif
      @if($_date)<td  class="center">{{convertDate($record->max_date)}}</td>@endif
      @if($_from_account)<td  class="center">{{$record->From_account}}</td>@endif
      @if($_from_currency)<td  class="center">{{$record->From_currency}}</td>@endif
      @if($_from_amount)<td  class="center">{{myRound($record->Amount)}}</td>@endif
      @if(systemConfig()[30] == 1)
      @if($_from_rate)<td  class="center">{{myRound( ABS($record->AmountBase /$record->Amount * $record->from_static_rate))}}</td>@endif
      @else 
      @if($_from_rate)<td  class="center">{{myRound($record->Amount / $record->AmountBase)}}</td>@endif
      @endif
      @if($_from_amount)<td  class="center">{{myRound($record->AmountBase)}}</td>@endif
      @if(getcommission() =="true")<td  class="center">{{myRound($record->commAmount)}}</td>@endif
      @if($_to_account)<td  class="center">{{$record->To_Account}}</td>@endif
      @if($_to_currency)<td  class="center">{{$record->To_currency}}</td>@endif
      @if($_to_amount)<td  class="center">{{myRound($record->To_amount)}}</td>@endif
      @if(systemConfig()[30] == 1)
      @if($_to_rate)<td  class="center">{{myRound(ABS($record->To_amountBase / $record->To_amount /  $record->to_static_rate))}}</td>@endif
      @else 
      @if($_to_rate)<td  class="center">{{myRound($record->To_amount / $record->To_amountBase)}}</td>@endif
      @endif
       @if($_to_amount)<td  class="center">{{myRound($record->To_amountBase)}}</td>@endif
       @if(getAverageRate() == "true")<td  class="center">{{myRound($record->gain_loss)}}</td>@endif
       @if(systemConfig()[29] == 1)
       @if(!$transaction_confirm)
       @if($_transaction_confirm) 
       @if($record->transaction_confirm == 'On')
       <td class="center"> @lang('layout.yes') </td>
       @else
       <td class="center"> @lang('layout.no') </td>
       @endif
       @endif
       @endif
       @endif   
      @if(systemConfig()[5] != 0 )<td class="center"> {{ $record->project }} </td>@endif
      @if($_user)<td  class="center">{{$record->user}}</td>@endif 
</tr>
@endforeach 
<tr class="bg">

  @if(!$_number)   <?php  $colspan_from = $colspan_from-2;  ?>       @endif
  @if(!$_date)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif
  @if(!$_date)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif
  @if(!$_from_account)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif
  @if(!$_from_currency)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif
  @if(!$_from_amount)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif 
  @if(!$_from_amount)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif
  @if(!$_to_account)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif
  @if(!$_to_currency)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif
  @if(!$_to_amount)   <?php  $colspan_from = $colspan_from-1;  ?>       @endif
  @if(getcommission() !="true")
    <?php  $colspan_from = $colspan_from-1;  ?> 
  @endif 
 
  <td colspan="{{$colspan_from}}" class="center">@lang('layout.Total')</td>
  
  @if(count($currencies) <= 1)
    <td>   {{MyRound($totalFromAmount)}}     </td>
  @else
  <td></td>
  @endif 

  <td>{{MyRound($total_home_currency)}}</td>
  <td colspan="{{$colspan_to}}"></td>
  @if(count($currencies) <= 1)
    <td>   {{MyRound($totalToAmount)}}     </td>
    <td></td>
    @else
    <td></td>
  <td></td>
  @endif
  
  <td>{{MyRound($total2_home_currency)}}</td>
</tr>  
</tbody>

</table>
@if($_total)
<table class="main-table">
  <tr class="bg">
    <td colspan="2" class="center" > @lang('layout.PerCurrency') </td>
   </tr>
<tr>
  <td>

<table class="main-table">
   <tr class="bg">
      <td colspan="{{(getAverageRate() =="true")?'5':'4'}}"><div class="center">@lang('layout.FromAccount')</div></td>
    </tr>
    <tr>
      <td><div class="center"> @lang('layout.Record')</div></td>
      <td><div class="center"> @lang('layout.Currency') </div></td>
      <td><div class="center"> @lang('layout.Amount') </div></td>
      <td><div class="center"> @lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}} </div></td>
      @if(getAverageRate() =="true")
      <td><div class="center"> @lang('layout.AverageRate') </div></td>
      @endif
    </tr>
  <?php
  $count=0;
    foreach($currencies As $key=>$currency)
    {
      ?>
    <tr>
      <td><div class="center">{{++$count}}</div></td>
      <td><div class="center">{{$key}}</div></td>
      <td><div class="center">{{myRound($currency['amount'])}}</div></td>
      <td><div class="center">{{myRound($currency['base_amount'])}}</div></td>
      @if(getAverageRate() =="true")
      <td><div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['amount']/$currency['base_amount'])):($currency['amount']/$currency['base_amount'])))}}</div></td>
      @endif
       
    </tr>
    <?php
  }
    ?>
  </table>
</td>

<td>
  <table class="main-table">
   <tr class="bg">
      <td colspan="{{(getAverageRate() =="true")?'5':'4'}}"><div class="center">@lang('layout.ToAccount')</div></td>
    </tr>
    <tr>
      <td><div class="center"> @lang('layout.Record')</div></td>
      <td><div class="center"> @lang('layout.Currency') </div></td>
      <td><div class="center"> @lang('layout.Amount') </div></td>
      <td><div class="center"> @lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}} </div></td>
      @if(getAverageRate() =="true")
      <td><div class="center"> @lang('layout.AverageRate') </div></td>
      @endif
    </tr>
  <?php
  $count=0;
    foreach($secound_currencies As $key=>$currency)
    {
      ?>
    <tr>
      <td><div class="center">{{++$count}}</div></td>
      <td><div class="center">{{$key}}</div></td>
      <td><div class="center">{{myRound($currency['amount'])}}</div></td>
      <td><div class="center">{{myRound($currency['base_amount'])}}</div></td>
      @if(getAverageRate() =="true")
      <td><div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['amount']/$currency['base_amount'])):($currency['amount']/$currency['base_amount'])))}}</div></td>
      @endif
       
    </tr>
    <?php
  }
    ?> 
  </table>
</td>
</tr>
<tr class="bg">
 <td colspan="1" class="center" > @lang('layout.HomeCurrencyTotal') : {{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}} </td>
 <td colspan="1" class="center" > @lang('layout.HomeCurrencyTotal') : {{myRound($total2_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}} </td>
</tr>
<tr class="bg">
 <td colspan="2" class="center" > @lang('layout.HomeCurrencyTotal') @lang('layout.GainOrLoss') : {{myRound($gain_loss * -1)}} {{getHomeCurrency()[getCurrencyType()]}} </td>
</tr>
</table>
  @if(getcommission() =="true")
  <table class="main-table">
   <tr class="bg">
      <td colspan="3"><div class="center">@lang('layout.PerCurrency') @lang('layout.Commission') </div></td>
    </tr>
    <tr>
      <td><div class="center"> @lang('layout.Record')</div></td>
      <td><div class="center"> @lang('layout.Currency') </div></td>
      <td><div class="center"> @lang('layout.Amount') </div></td>
    </tr>
  <?php
  $count=0;
    foreach($comm_currencies As $key=>$currency)
    {
      ?>
    <tr>
      <td><div class="center">{{++$count}}</div></td>
      <td><div class="center">{{$key}}</div></td>
      <td><div class="center">{{myRound($currency)}}</div></td>
    </tr>
    <?php
  }
    ?>
    <tr>
       <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
      <td><div class="center">{{myRound($comm_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>
    </tr>
  </table>
 @endif
 @endif
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection