@extends('layouts.factor-master')


@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.TransferAccount')</h3>

<table class="main-table">
    <thead>
        <tr>
            <th> @lang('layout.Date') </th>
            <th> @lang('layout.Date') </th>
            <th> @lang('layout.Number')</th>
            <th> @lang('layout.ReferenceNumber')</th>
            <th> @lang('layout.ReferenceName')</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>{{convertDate($transfer->Date)}}</td>
            <td>{{$transfer->Date}}</td>
            <td class="hidden-xs"> {{ $transfer->number}} </td>
            <td style="text-align: center;"> {{ $transfer->referencen_number}}  </td>
            <td style="text-align: center;"> {{ $transfer->referencen_name}}  </td>
        </tr>


    </tbody>
</table>


<table class="main-table" style="margin-top: 30px;">

    <tr> 
        <th> @lang('layout.FromAccount')</th>
        <th> @lang('layout.Currency')</th>
        <th> @lang('layout.Rate')</th>
        <th> @lang('layout.Amount')</th>

        <th>@lang('layout.Description')</th>


    </tr>
    <tr> 
        <td class="hidden-xs"> {{ $transfer->fromAccount}} </td>
        <td class="hidden-xs"> {{ $transfer->from_currency}} </td>
        <td class="hidden-xs"> {{ myRound($transfer->fromRate)}} </td>
        <td class="hidden-xs"><b> {{ myRound($transfer->fromAmount)}} </b> </td>
        <td align="center">
            <?php 
                    $des = wordwrap($transfer->second_description,80,"<br/>\n",false);
                    echo $des;
                    ?>

        </td>
    </tr>
    @if(getcommission() =="true")
    <tr>
        <td class="hidden-xs"> @lang('layout.Commission') </td>
        <td class="hidden-xs"> {{ myRound($transfer->commAmount)}} </td>
        <td class="hidden-xs"> {{ myRound($transfer->fromRate)}} </td>
        <td class="hidden-xs"> @lang('layout.Description') </td>
        <td align="center">
            <?php 
                    $dess = wordwrap($transfer->comm_description,80,"<br/>\n",false);
                    echo $dess;
                    ?>
        </td>
    </tr>
    @endif

</table>
<br>

<table class="main-table">

    <tr>
        <th> @lang('layout.ToAccount')</th>
        <th> @lang('layout.Currency')</th>
        <th> @lang('layout.Rate')</th>
        <th> @lang('layout.Amount')</th>

        <th>@lang('layout.Description')</th>


    </tr>
    <tr>
        <td class="hidden-xs"> {{ $transfer->to_Account}} </td>
        <td class="hidden-xs"> {{ $transfer->to_currency}} </td>
        <td class="hidden-xs"> {{ myRound($transfer->to_rate)}} </td>
        <td class="hidden-xs"><b> {{ myRound($transfer->toAmount)}} </b> </td>
        <td align="center">
            <?php 
                    $des = wordwrap($transfer->description,80,"<br/>\n",false);
                    echo $des;
                    ?>
        </td>
    </tr>

</table>

<br>
<!--  signature -->
<table class="main-table">
    <tr>
        <td style="text-align: left; width:10%; text-align: center; vertical-align:text-to">
            <i class=""></i> @lang('layout.User') : {{ $transfer->user_name}}
        </td>  
        <td style="text-align: left; width:10%; text-align: center; vertical-align:text-to">
            <i class=""></i> @lang('layout.By') : 
        </td>  
 
        @foreach(getCompanyInfo('sign','voucher') AS $info)
        <td style="text-align: left; width:10%; text-align: center;">
            <table >
                <tr>
                    <td align="right" style="height: 60px;border:none;vertical-align:text-to">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
        @break
        @endforeach  

    </tr>
    <tr>
          
        @foreach(getCompanyInfo('sign','voucher') AS $key => $value)
        @if($key == 0)
        @continue 
        @endif
        <td style="text-align: left; width:10%; text-align: center;">
            <table >
                <tr>
                    <td align="right" style="height: 80px;border:none;vertical-align:text-to">{{$value['name']}}</td>
                </tr>
            </table>
        </td>
        @endforeach                
                         
    </tr>
</table>
<!-- End signature -->





@if(company()['exchange_message'])
<table width="100%">
    <tr>
        <td style="font-size: 14px;">{!!company()['exchange_message']!!}</td>
    </tr>

    <tr>
        <td></td>
        <td></td>
    </tr>


</table>
@endif
@endsection