@extends('layouts.factor-master')
@section('content')

<?php
$report = customeReportNew('employee_overtime_index');
$_record= !in_array('record', $report);
$_number= !in_array('number', $report);
$_code= !in_array('code', $report);
$_date= !in_array('date', $report);
$_employee= !in_array('employee', $report);
$_second_status= !in_array('second_status', $report);
$_from_date= !in_array('from_date', $report);
$_to_date= !in_array('to_date', $report);
$_from_hour= !in_array('from_hour', $report);
$_to_hour= !in_array('to_hour', $report);
$_duration= !in_array('duration', $report);
$_status= !in_array('status', $report);
$_description= !in_array('description', $report);


$report_percent = customeReportNewPercent('employee_overtime_index');
$_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_employee_percent= (array_key_exists('employee___percent', $report_percent))?$report_percent['employee___percent']:null;
$_second_status_percent= (array_key_exists('second_status___percent', $report_percent))?$report_percent['second_status___percent']:null;
$_from_date_percent= (array_key_exists('from_date___percent', $report_percent))?$report_percent['from_date___percent']:null;
$_to_date_percent= (array_key_exists('to_date___percent', $report_percent))?$report_percent['to_date___percent']:null;
$_from_hour_percent= (array_key_exists('from_hour___percent', $report_percent))?$report_percent['from_hour___percent']:null;
$_to_hour_percent= (array_key_exists('to_hour___percent', $report_percent))?$report_percent['to_hour___percent']:null;
$_duration_percent= (array_key_exists('duration___percent', $report_percent))?$report_percent['duration___percent']:null;
$_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
 

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.EmployeeLeavesReport')</h3>

@if($from_date || $to_date || $member_name || $status)
<table class="main-table">
    <tr class="bg">
       
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
            </td>
        @endif

        @if($member_name)
            <td>
                <span>@lang('layout.EmployeeName')</span>:
                <BDO>{{$member_name}}</BDO>
            </td>
        @endif


        @if($status)
            @if($status == 'Justifiend')
            <td style="color:green">
                 <span>@lang('layout.Status')</span>: @lang('layout.Justifiend')</td>
            @elseif($status == 'pending')
            <td style="color:orange;">
                 <span>@lang('layout.Status')</span>: @lang('layout.Waiting')</td>
            @else
            <td style="color:red;">
                 <span>@lang('layout.Status')</span>: @lang('layout.Rejected')</td>
            @endif
        @endif
    </tr>
</table>
<br>
@endif

<table class="main-table">
        <tr class="bg">
            @if($_record)<th @if($_record_percent) width="{{$_record_percent}}%" @endif>@lang('layout.Record')</th>@endif
            @if($_number)<th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>@endif
            @if($_code)<th @if($_code_percent) width="{{$_code_percent}}%" @endif>@lang('layout.Code')</th>@endif
            @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>@endif
            @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>@endif
            @if(!$member_name)
            @if($_employee)<th @if($_employee_percent) width="{{$_employee_percent}}%" @endif>@lang('layout.EmployeeName')</th>@endif
            @endif
            @if($_from_hour)<th @if($_from_hour_percent) width="{{$_from_hour_percent}}%" @endif>@lang('layout.FromHour')</th>@endif
            @if($_to_hour)<th @if($_to_hour_percent) width="{{$_to_hour_percent}}%" @endif>@lang('layout.ToHour')</th>@endif
            @if($_duration)<th @if($_duration_percent) width="{{$_duration_percent}}%" @endif>@lang('layout.Duration')</th>@endif
            @if(!$status)
            @if($_status)<th @if($_status_percent) width="{{$_status_percent}}%" @endif>@lang('layout.Status')</th>@endif 
            @endif
            @if($_second_status)<th @if($_second_status_percent) width="{{$_second_status_percent}}%" @endif>@lang('layout.Status')</th>@endif

        </tr>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
        @if($_record)<td class="center">{{++$count}}</td>@endif
        @if($_number)<td class="center">{{$record->number}}</td>@endif
        @if($_code)<td class="center">{{$record->code}}</td>@endif
        @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
        @if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>@endif
        @if(!$member_name)
        @if($_employee)<td class="center" style="text-align: center;">{{$record->name}}</td>@endif
        @endif       
        @if($_from_hour)<td class="center" >{{$record->from_hour}}</td>@endif
        @if($_to_hour)<td class="center" >{{$record->to_hour}}</td>@endif
       
        <?php

        $startHourTime = Carbon\Carbon::parse($record->from_hour);
        $EndHourTime = Carbon\Carbon::parse($record->to_hour);
        $diffInHours = $startHourTime->diffInMinutes($EndHourTime);
        $diffInminurte = round($diffInHours/60);   
        $diffmodeminutes = $diffInHours % 60;
        ?>
       @if($diffmodeminutes == 0)
        <td class="center">{{$diffInminurte}}@lang('layout.Hour')</td>
        @else
        <td class="center">{{$diffInminurte}}@lang('layout.Hour') {{$diffmodeminutes}} @lang('layout.Minute')</td>
        @endif
        @if(!$status)
        @if($record->status == 'Justifiend')
        <td class="center" style="color:green">@lang('layout.Justifiend')</td>
        @elseif($record->status == 'pending')
        <td class="center" style="color:orange;">@lang('layout.Waiting')</td>
        @else
        <td class="center" style="color:red;">@lang('layout.Rejected')</td>
       @endif
       @endif

       @if($record->second_status == 'Off')
       <td class="center" style="color:green">@lang('layout.Paid')</td>
      @endif

    </tr>
    @endforeach
</table>

<table>
    <tr>

    </tr>
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection