@extends('layouts.app')

@section('style')
<!-- <link rel="stylesheet" type="text/css" href="{{URL::asset('profile/profile-2.min.css')}}"> -->
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />

<style type="text/css">
    .padding {
        padding: 0px;
    }
</style>

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" id="form_holy_day" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddEmployeeLeave') </span>

                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
   
                </div>
            </div>
            <div class="portlet-body form" id="app" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                <form role="form" action="{{route('leaves.storeleaves')}}" method="post" enctype="multipart/form-data">
                    @csrf
                <div class="form-body">

                <div class="row">


                    <div class="col-md-3"style="margin-bottom:15px;">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.EmployeeName'):</label>
                            <div class="col-md-9">
                                <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                                <input type="hidden" name="member_id" :value="!selected_employee?null:selected_employee.id">
                            
                            </div>
                        </div>

                    </div>
                    

                    <div class="col-md-3">
                                            
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Number'):</label>
                            <div class="col-md-9">
                                <input type="text" name="number" value="{{$number}}" class="form-control" autocomplete="off">
                            </div>
                        </div>
                    </div>


                <div class="col-md-3">
                                            
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Code'):</label>
                            <div class="col-md-9">
                                <input type="text" name="code" class="form-control" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3">
                                            
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                <input type="text" name="date"  class="form-control date" autocomplete="off">
                            </div>
                        </div>
                    </div>



                </div>
                <div class="row">
                    

                    
                    <div class="col-md-3"style="margin-bottom:15px;">
                        <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.Type'):</label>
                        <div class="col-md-9">
                        <select name="type" v-model="type" class="form-control">
                            <option value="Hourly"  >@lang('type.Hourly')</option>
                            <option value="Daily">@lang('type.Daily')</option>
                        </select>
                    </div>
                    </div>
                    </div>

                    <div class="col-md-3" v-show="type == 'Hourly' || !type">
                        <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.FromHour')</label>

                        <div class="col-md-9"> 
                            
                            <input type="text"   class="form-control timepicker timepicker-no-seconds"  ref="time_input" name="from_hour">
                            
                        </div>
                    </div>
                    </div>

                    <div class="col-md-3" v-show="type == 'Hourly' || !type">

                        <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.ToHour')</label>

                        <div class="col-md-9"> 
                            
                            <input type="text" class="form-control timepicker timepicker-no-seconds"  ref="time_input" name="to_hour">
                            
                        </div>
                    </div>
                </div>




                <div class="col-md-3" v-show="type == 'Daily'">
                    
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.FromDate'):</label>
                        <div class="col-md-9">
                            <input type="text" name="from_date" class="form-control date" autocomplete="off">
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    
                    <div class="form-group" v-show="type == 'Daily'">
                        <label class="control-label col-md-3">@lang('layout.ToDate'):</label>
                        <div class="col-md-9">
                            <input type="text" name="to_date" class="form-control date" autocomplete="off">
                        </div>
                    </div>
                </div>

                    <div class="col-md-3">                               
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                <textarea name="description" class="form-control" id="" cols="30" rows="1"></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3"style="margin-bottom:15px;">
                        <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.Status'):</label>
                        <div class="col-md-9">
                        <select name="status" class="form-control">
                            <option value="pending"  >@lang('layout.Select')</option>
                            <option value="Justifiend"  >@lang('layout.Justifiend')</option>
                            <option value="UnJustifiend">@lang('layout.Unjustified')</option>
                            <option value="Rejected">@lang('layout.Reject')</option>
                        </select>
                    </div>
                    </div>
                    </div>
                </div>

             
               
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('employeeLeaves.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
               
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection

@push('scripts')
    
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

<script>
    
    Vue.component("v-select", VueSelect.VueSelect);
 


    let vu =  new Vue({
    el: '#form_holy_day',
    data: {
        employee:[],
        selected_employee:null,
        type: null,
    },
    computed: {

    },
    methods: {
        handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
        MemberSearch: _.debounce((search, loading) => {  
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Employee'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vu.employee = [];
                    vu.employee = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),
    }

});

</script>

@endpush