@extends('layouts.factor-master')
@section('content')

<?php
$report = customeReportNew('employee_leaves_index');
$_record= !in_array('record', $report);
$_number= !in_array('number', $report);
$_code= !in_array('code', $report);
$_date= !in_array('date', $report);
$_employee= !in_array('employee', $report);
$_type= !in_array('type', $report);
$_from_date= !in_array('from_date', $report);
$_to_date= !in_array('to_date', $report);
$_from_hour= !in_array('from_hour', $report);
$_to_hour= !in_array('to_hour', $report);
$_duration= !in_array('duration', $report);
$_status= !in_array('status', $report);
$_description= !in_array('description', $report);


$report_percent = customeReportNewPercent('employee_leaves_index');
$_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_employee_percent= (array_key_exists('employee___percent', $report_percent))?$report_percent['employee___percent']:null;
$_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
$_from_date_percent= (array_key_exists('from_date___percent', $report_percent))?$report_percent['from_date___percent']:null;
$_to_date_percent= (array_key_exists('to_date___percent', $report_percent))?$report_percent['to_date___percent']:null;
$_from_hour_percent= (array_key_exists('from_hour___percent', $report_percent))?$report_percent['from_hour___percent']:null;
$_to_hour_percent= (array_key_exists('to_hour___percent', $report_percent))?$report_percent['to_hour___percent']:null;
$_duration_percent= (array_key_exists('duration___percent', $report_percent))?$report_percent['duration___percent']:null;
$_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
 
// dd($report, $report_percent);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.EmployeeLeavesReport')</h3>

@if($from_date || $to_date || $status || $member_name)
<table class="main-table">
    <tr class="bg">
       
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
            </td>
        @endif

        @if($member_name)
        <td>
            <span>@lang('layout.EmployeeName')</span>:
            <BDO>{{$member_name}}</BDO>
            </td>
        @endif


        @if($status)
       
        @if($status == 'Justifiend')
        <td class="center" style="text-align: justify;color:green">
            <span>@lang('layout.Status')</span>:@lang('layout.Justifiend')</td>
        @elseif($status == 'UnJustifiend')
        <td class="center" style="text-align: justify;color:orange">
            <span>@lang('layout.Status')</span>:@lang('layout.Unjustified')</td>
        @else
        <td class="center" style="text-align: justify;color:red;">
            <span>@lang('layout.Status')</span>:@lang('layout.Rejected')</td>
       @endif
       @endif
      
    </tr>
</table>
<br>
@endif

<table class="main-table">
        <tr class="bg">
            @if($_record)<th @if($_record_percent) width="{{$_record_percent}}%" @endif>@lang('layout.Record')</th>@endif
            @if($_number)<th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>@endif
            @if($_code)<th @if($_code_percent) width="{{$_code_percent}}%" @endif>@lang('layout.Code')</th>@endif
            @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>@endif
            @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>@endif
            @if(!$member_name)
            @if($_employee)<th @if($_employee_percent) width="{{$_employee_percent}}%" @endif>@lang('layout.EmployeeName')</th>@endif
            @endif
            @if($_type)<th @if($_type_percent) width="{{$_type_percent}}%" @endif>@lang('layout.Type')</th>@endif
            @if($_from_date)<th @if($_from_date_percent) width="{{$_from_date_percent}}%" @endif>@lang('layout.FromDate')</th>@endif
            @if($_to_date)<th @if($_to_date_percent) width="{{$_to_date_percent}}%" @endif>@lang('layout.ToDate')</th>@endif
            @if($_from_hour)<th @if($_from_hour_percent) width="{{$_from_hour_percent}}%" @endif>@lang('layout.FromHour')</th>@endif
            @if($_to_hour)<th @if($_to_hour_percent) width="{{$_to_hour_percent}}%" @endif>@lang('layout.ToHour')</th>@endif
            @if($_duration)<th @if($_duration_percent) width="{{$_duration_percent}}%" @endif>@lang('layout.Duration')</th>@endif
            @if(!$status)
            @if($_status)<th @if($_status_percent) width="{{$_status_percent}}%" @endif>@lang('layout.Status')</th>@endif
            @endif
        </tr>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
        @if($_record)<td class="center">{{++$count}}</td>@endif
        @if($_number)<td class="center">{{$record->number}}</td>@endif
        @if($_code)<td class="center">{{$record->code}}</td>@endif
        @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
        @if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>@endif
        @if(!$member_name)
        @if($_employee)<td  style="text-align: center;">{{$record->name}}</td>@endif
        @endif
        @if($record->type == 'Daily')
        @if($_type)<td class="center"> @lang('layout.Daily') </td>@endif
        @else
        @if($_type)<td class="center"> @lang('layout.Hourly') </td>@endif
        @endif
        @if($record->type == 'Daily')
        @if($_from_date)<td class="center">{{convertDate($record->from_date)}}</td>@endif
        @if($_to_date)<td class="center">{{convertDate($record->to_date)}}</td>@endif
        @else
        @if($_from_date)<td class="center"></td>@endif
        @if($_to_date)<td class="center"></td>@endif
        @endif
        @if($record->type == 'Hourly')
        @if($_from_hour)<td class="center" >{{$record->from_hour}}</td>@endif
        @if($_to_hour)<td class="center" >{{$record->to_hour}}</td>@endif
        @else
        @if($_from_hour)<td class="center" ></td>@endif
        @if($_to_hour)<td class="center" ></td>@endif
        @endif


        <?php

        $startDateTime = Carbon\Carbon::parse($record->from_date);
        $EndDateTime = Carbon\Carbon::parse($record->to_date);
        $diffInDays = $startDateTime->diffInDays($EndDateTime);

        $startHourTime = Carbon\Carbon::parse($record->from_hour);
        $EndHourTime = Carbon\Carbon::parse($record->to_hour);
        $diffInHours = $startHourTime->diffInHours($EndHourTime);
        ?>
       

        @if($record->type =='Daily')
        <td class="center">{{$diffInDays}}@lang('layout.Day')</td>
        @else
        <td class="center">{{$diffInHours}}@lang('layout.Hour')</td>
        @endif

        @if(!$status)
        @if($record->status == 'Justifiend')
        <td class="center" style="text-align: justify;color:green">@lang('layout.Justifiend')</td>
        @elseif($record->status == 'UnJustifiend')
        <td class="center" style="text-align: justify;color:orange">@lang('layout.Unjustified')</td>
        @else
        <td class="center" style="text-align: justify;color:red;">@lang('layout.Rejected')</td>
       @endif
        @endif
    </tr>
    @endforeach
</table>

<table>
    <tr>

    </tr>
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection