﻿/* Function */
function format_number(number, prefix, thousand_separator, decimal_separator) {
    var thousand_separator = thousand_separator || ',',
        decimal_separator = decimal_separator || '.',
        regex = new RegExp('[^' + decimal_separator + '\\d]', 'g'),
        number_string = number.replace(regex, '').toString(),
        split = number_string.split(decimal_separator),
        rest = split[0].length % 3,
        result = split[0].substr(0, rest),
        thousands = split[0].substr(rest).match(/\d{3}/g);

    if (thousands) {
        separator = rest ? thousand_separator : '';
        result += separator + thousands.join(thousand_separator);
    }
    result = split[1] != undefined ? result + decimal_separator + split[1] : result;
    return prefix == undefined ? result : (result ? prefix + result : '');
};

function limit_character(event) {
    key = event.which || event.keyCode;
    if (key != 188 // Comma
         && key != 8 // Backspace
         && key != 17 && key != 86 & key != 67 // Ctrl c, ctrl v
         && (key < 48 || key > 57) // Non digit
        // And many more, such as: del, left arrow dan right arrow, tab, etc...
        ) {
        event.preventDefault();
        return false;
    }
}