
<frame>


<?php
//============================================================+
// File name   : example_001.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 001 for TCPDF class
//               Default Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+
use Illuminate\Http\Request;
use setasign\Fpdi\TcpdfFpdi;
/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Default Header and Footer
 * @author Nicola Asuni
 * @since 2008-03-04
 */

$lg = Array();
$lg['a_meta_charset'] = 'UTF-8';
$lg['a_meta_dir'] = 'rtl';
$lg['a_meta_language'] = 'fa';
$lg['w_page'] = 'page';

// Include the main TCPDF library (search for installation path).

$filename = realpath('tcpdf_include.php');
var_dump($filename);

$pdf = new TcpdfFpdi(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'ISO-8859-1', false);
    $pdf->setPrintHeader(false);
        // add a page
    /*$pdf->SetMargins(10, PDF_MARGIN_TOP, 10);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);*/
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
//$fontname = $pdf->addTTFfont('/fonts/arial.ttf', '', '', 32);

//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
$pdf->setLanguageArray($lg);


        $pdf->AddPage('L', 'A5');

        ob_end_clean();
        $pdf->setSourceFile("invoiceF.pdf");
        $pdf->SetFont('helvetica', '', 12);
		$tplId = $pdf->importPage(1);
		$pdf->useTemplate($tplId, 0, 0, 210);
        $pdf->SetFont('times', '', 8);
        $pdf->SetFont('dejavusans', '', 8);

$html2 = <<<EOD
<style>
.one tr td {
	
	text-align:right;
	font-size:7px;
	}
	
</style>
<table border="0.2px" cellpadding="2"  class="one">
	
	
	<tr>
		<td width="10%">شماره</td>
		<td width="43%"></td>
		<td width="12%">مشتری :</td>
		<td width="36%"></td>
	</tr>
	<tr>
		<td>نمبر بل</td>
		<td></td>
		<td>آدرس :</td>
		<td></td>
	</tr>
	<tr>
		<td>تاریخ سررسید بل</td>
		<td></td>
		<td>شماره تماس :</td>
		<td></td>
	</tr>
	
</table>
EOD;
$pdf->setXY(-202,34);
$pdf->setCellHeightRatio(2);
$pdf->writeHTML($html2, true, false, true, false, '');


$html3 = <<<EOD
<style>
.one tr td {
	font-size:8px;
	}
	.two {
		border: 2px solid black; 
	}
.two tr th {
	
	text-align:center;
	font-size:9px;
	border: 0.2px dashed black;
	background-color: #F0F0F0;
	}	
.two tr td {
	
	text-align:center;
	font-size:9px;
	border: 0.2px dashed black;
	}
	
</style>

<table   class="one">
	
	<tr>
		<td width="47%"></td>
		<td width="12%">جزئیات بل</td>
	</tr>
	
</table>

<table  class="two">
	<tr>
		<th width="6%">شماره</th>
		<th width="8%">نوع جنس</th>
		<th width="8%">نوع بوتل</th>
		<th width="8%">تعداد توتل</th>
		<th width="11%">ظرفیت بولل</th>
		<th width="11%">مقدار زعفران</th>
		<th width="10%">واحد قیاثی</th>
		<th width="13%">قیمت فی واحد</th>
		<th width="15%">قیمت مجموع</th>
		<th width="11%">ملاحظات</th>
	</tr>
	<tr>
		<td>1</td>
		<td></td>
		<td colspan="4"></td>
		<td></td>
		<td></td>
		<td></td>
		<td></td>
	</tr>
	<tr>
		<td colspan="8">مجموعه کل</td>
		<td colspan="2"></td>
	</tr>
	
</table>
EOD;
$pdf->setXY(-202,53);
$pdf->setCellHeightRatio(2);
$pdf->writeHTML($html3, true, false, true, false, '');


$html4 = <<<EOD
<style>
.one tr td {
	font-size:8px;
	}
	.two {
		border: 2px solid black; 
	}
.two tr th {
	
	text-align:center;
	font-size:9px;
	border: 0.2px dashed black;
	}	
.two tr td {
	
	text-align:center;
	font-size:8px;
	border: 0.2px dashed black;
	}
	
</style>

<table class="two">
	
	<tr>
		<td width="35%">مبلغ پیش دریافت</td>
		<td width="67.5%"></td>
	</tr>
	<tr>
		<td>مبلغ رسید</td>
		<td></td>
	</tr>
	<tr>
		<td>الباقی</td>
		<td></td>
	</tr>
	
</table>
EOD;
$pdf->setXY(-83,77.8);
$pdf->setCellHeightRatio(2);
$pdf->writeHTML($html4, true, false, true, false, '');

$html4 = <<<EOD
<style>	
.two tr td {
	
	text-align:center;
	font-size:8px;
	}
	
</style>

<table class="two">
	
	<tr>
		<td width="35%">امضاء ومهر</td>
		<td width="65%"></td>
	</tr>
	
</table>
EOD;
$pdf->setXY(-130,95);
$pdf->setCellHeightRatio(2);
$pdf->writeHTML($html4, true, false, true, false, '');
$pdf->Output('example_048.pdf', 'I');//============================================================+

// END OF FILE
        ?>
</frame>