/*
 * jscharting.js v3.3.1.20220428
 * (c) 2009-2022 Corporate Web Solutions Ltd.
 * All client side / JavaScript code may not be used in any way without a valid JSCharting license.
 * License holder usage is governed by the license.txt terms included with the distribution.
 * To license JSCharting for your own use, please visit jscharting.com 
 */
'use strict'; (function (d) {
    function v(b, a) { var c = "function" === typeof Symbol && b[Symbol.iterator]; if (!c) return b; b = c.call(b); var d, e = []; try { for (; (void 0 === a || 0 < a--) && !(d = b.next()).done;)e.push(d.value) } catch (l) { var f = { error: l } } finally { try { d && !d.done && (c = b["return"]) && c.call(b) } finally { if (f) throw f.error; } } return e } function m(b, a) { b = document.createElement(b); if (a) for (var c in a) b.style[c] = a[c]; return b } function r(b, a) {
        b = document.createElementNS("http://www.w3.org/2000/svg", b); if (a) for (var c in a) b.style[c] =
            a[c]; return b
    } function w(b, a) {
        function c(a, b) { a && a.map(function (a) { if (a.title) { var c = m("h4", { marginTop: "0px", marginBottom: "4px", color: b }); c.innerText = a.title; g.appendChild(c) } a.text && (c = m("p", { marginTop: "0px", marginBottom: "4px" }), c.innerText = a.text, g.appendChild(c)) }) } if (b.tagName) {
            var d = a.errors ? "M8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zM12.2 10.8l-1.4 1.4-2.8-2.8-2.8 2.8-1.4-1.4 2.8-2.8-2.8-2.8 1.4-1.4 2.8 2.8 2.8-2.8 1.4 1.4-2.8 2.8 2.8 2.8z" : a.warnings ? "M8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zM9 13h-2v-2h2v2zM9 10h-2v-7h2v7z" :
                "M5.3 14.3c0 1.2.8 1.7 1.5 1.7h2.5c.8 0 1.5-.7 1.5-1.5v-1H5.3v.8zm6.9-12.6C11.1.6 9.5 0 7.9 0 4.7 0 2.1 2.7 2 5.8c0 1.9.8 3.6 2.3 4.8.5.4.9 1 1 1.6h5.5c.1-.6.5-1.2 1-1.7C13.2 9.4 14 7.8 14 6c0-1.6-.6-3.1-1.8-4.3z", e = a.errors ? h.iconError : a.warnings ? h.iconWarning : h.iconTip, f = window.getComputedStyle(b).position, l = "absolute" === f || "relative" === f ? "absolute" : "static"; f = m("div", { bottom: "8px", right: "8px", position: l }); e = r("svg", { pointerEvents: "none", fill: e }); var n = r("path"); e.setAttribute("width", 18); e.setAttribute("height",
                    18); e.setAttribute("viewBox", "0 0 16 16"); n.setAttribute("d", d); e.appendChild(n); f.appendChild(e); var g = m("div", { pointerEvents: "none" }); d = m("div", { maxHeight: "200px", overflowY: "auto" }); var k = m("div", q({ padding: "12px", backgroundColor: h.tooltipBackground, borderRadius: "16px", position: l, display: "none", textAlign: "left", maxWidth: "400px", zIndex: "999" }, x)); c(a.errors, h.textError); c(a.warnings, h.textWarning); c(a.tips, h.textTip); a = m("p", { marginBottom: "4px", color: h.disableMessage }); a.innerText = "To disable these messages, remove or set chart debug option to false";
            g.appendChild(a); b.appendChild(f); d.appendChild(g); k.appendChild(d); b.appendChild(k); var p; f.addEventListener("mouseover", function () { var a = b.getBoundingClientRect(), c = ["left", "right"], d = ["top", "bottom"], f = [1, 1], e = [26, 26]; 290 > a.left + a.width && (f[0] = 0, e[0] = a.width - 8); 158 > a.top + a.height && (f[1] = 0, e[1] = a.height - 8); k.style.removeProperty(c[f[0] ? 0 : 1]); k.style.removeProperty(d[f[1] ? 0 : 1]); k.style[c[f[0]]] = e[0] + "px"; k.style[d[f[1]]] = e[1] + "px"; k.style.display = "block" }); f.addEventListener("mouseout", function () {
                p =
                setTimeout(function () { k.style.display = "none" }, 500)
            }); k.addEventListener("mouseover", function () { p && (clearTimeout(p), p = void 0) }); k.addEventListener("mouseout", function () { var a = event.toElement || event.relatedTarget; a.parentNode != this && a != this && (k.style.display = "none") }, !0)
        }
    } var q = function () { q = Object.assign || function (b) { for (var a, c = 1, d = arguments.length; c < d; c++) { a = arguments[c]; for (var e in a) Object.prototype.hasOwnProperty.call(a, e) && (b[e] = a[e]) } return b }; return q.apply(this, arguments) }, h = {
        textError: "#ad1f2d",
        textWarning: "#cc9900", textTip: "#317a00", iconError: "#e3293b", iconWarning: "#ffc107", iconTip: "#fdd822", disableMessage: "gray", tooltipBackground: "#eeeeee"
    }, x = { fontFamily: "tahoma, geneva, sans-serif", fontSize: "12px", fontWeight: "normal", fontStyle: "normal" }, t = {
        targetElIdNotFound: { title: "Element not found", text: "The specified element id %% was not found." }, cantGetSize: { title: "Size can not be obtained", text: "Parent element size cannot be obtained. Probably the chart is hidden." }, defaultSizeIsSet: {
            title: "Default size is set",
            text: "Probably the chart is hidden. To get actual size, call chart.redraw() when the chart is visible."
        }, dataRequired: { title: "Data required", text: "Data series %% does not have all the required ## values." }, invalidData: { title: "Invalid Data", text: "Data series %% contains invalid data." }, orgChildLevel: { title: "Wrong node position", text: "A child node (id: %%) cannot be positioned at the same layer (y value) as another parent node" }, scriptLoad: { title: "Adding <script> improves performance", text: 'Adding: <script type="text/javascript" src="%%">\x3c/script> to the HTML page will improve performace' },
        cdnLoad: { title: "Loading modules locally", text: "JSCharting is using a CDN to load modules. To load modules locally, copy files in node_modules/jscharting/dist/ to a folder in the target website such as js/jsc/ and set the baseUrl option with this folder name: {baseUrl: '/js/jsc/'}" }, libNotFound: { title: "File not found", text: "File %% not found." }, iconNotFound: { title: "Icon does not exist", text: "The icon %% does not exist." }, microchartNotFound: { title: "Type does not exist.", text: "Microchart type %% does not exist." },
        microchartNotFoundSuggestion: { title: "Type does not exist.", text: "Microchart type %% does not exist. Did you mean ##?" }, spPointValueSuggestion: { title: "SmartPalette pointValue performance", text: "Using a function such as pointValue: p=>p.options('z') will improve smartPalette performance." }, incompatableAxisTypeOptions: { title: "Scale type is not compatible with data", text: "The %% axis scale type is not compatible with data points of type ##." }, objInterval: {
            title: "Scale interval is not compatible with numeric scales",
            text: "The %% scale interval of type object cannot be used with numeric scales. Try using %%Axis_scale_type:'time'"
        }, calNoData: { title: "calendar.dateRange or heatmap data is required", text: "Please specify calendar.dateRange or include heatmap data to render a calendar chart." }, noCrosshair: { title: "Crosshair is not supported", text: "Axis crosshair is not supported" }, spRangesOverflow: { title: "Maximum ranges exceeded", text: "Maximum smartPalette ranges exceeded by %% setting." }, minMaxRequired: {
            title: "Min and Max values are required",
            text: "Palette Min and Max values are required when using interval."
        }, colorsRequired: { title: "Colors required", text: "Colors are required when using range palette." }, pointSelectNoAttrs: { title: "No Point Select State", text: "Set defaultPoint_state_select_enabled:true to see selected points." }, ttFnResultBad: { title: "Tooltip Text Function", text: "The tooltip text callback function did not return a valid value." }, paletteNF: { title: "Palette not found", text: 'The specified palette "%%" was not found. See https://jscharting.com/documentation/#node=Home.API.json.Enums.palette for a lis of available options.' },
        multiAxDTE: { title: "Default ticks enabled on extra axis", text: "The default ticks on additional ## axis %% are enabled. Set defaultTick_enabled:false to remove them." }, pLabelHidden: { title: "Point labels hidden automatically.", text: 'Not all point labels "##" of series %% may be visible due to lack of space or overlaps. Try setting defaultPoint_label_autoHide:false to force all point labels to appear.', noDupes: !0 }, manyTicksTime: {
            title: "Excessive Axis Tick Count.", text: "The %% axis time scale is creating an excessive number of axis ticks (##) due to the specified time interval. This may reduce chart performance. Try specifying a larger interval or remove the interval setting.",
            noDupes: !0
        }, manyTicks: { title: "Excessive Axis Tick Count.", text: "The %% axis numeric scale is creating an excessive number axis ticks (##) due to the specified numeric interval. This may reduce chart performance. Try specifying a larger interval or remove the interval setting.", noDupes: !0 }, manyTicksCat: {
            title: "Excessive Axis Tick Count.", text: "The %% axis category scale is creating an excessive number axis ticks (##) that may reduce chart performance. If the scale should be numeric or time based, make sure numeric point values are not strings or set axis_scale_type:'time' for time scales.",
            noDupes: !0
        }, filterDidNotMatchAnyPoints: { title: "No points were matched", text: "The specified point filter did not match any points." }, mapIsAlreadyProjected: { title: "Already projected", text: "The map is already projected." }
    }, y = { chartAfterOptions: function (b, a) { var c = a.data.series; d.jsLib.def(c) && !d.jsLib.isArray(c) && b.addError(a.chart ? a.chart.id : "", "The chart series property must be an array.", a) } }, u = t, z = function () {
        function b() { this.errors = []; this.warnings = []; this.logs = []; this.tips = []; this.idleDefer = new d.idleDefer }
        b.prototype.addWarning = function (a, b, d) { var c = this; this.addItem(arguments, "JSCharting Warning: ", function () { return c.warnings }, function (a) { return c.warnings.push(a) }) }; b.prototype.addCdnWarning = function () { var a = this; clearTimeout(this._cdnWarningTimeoutId); this._cdnWarningTimeoutId = setTimeout(function () { a.addItem(["dom", "cdnLoad"], "JSCharting Warning: ", function () { return a.warnings }, function (b) { return a.warnings.push(b) }) }, 1E3) }; b.prototype.addError = function (a, b, d) {
            var c = this; this.addItem(arguments,
                "JSCharting Error: ", function () { return c.errors }, function (a) { return c.errors.push(a) })
        }; b.prototype.addTip = function (a, b, d) { var c = this; this.addItem(arguments, "JSCharting Tip: ", function () { return c.tips }, function (a) { return c.tips.push(a) }) }; b.prototype.addLog = function (a, b, d) { var c = this; this.addItem(arguments, "JSCharting Log: ", function () { return c.logs }, function (a) { return c.logs.push(a) }) }; b.prototype.validate = function (a, b, d) { (a = y[b]) && a(this, d) }; b.prototype.addItem = function (a, b, h, e) {
            var c = v(a, 3), l =
                c[0]; a = c[1]; c = c[2]; var n = c.data || []; d.en.error.mapping && (u = d.jsLib.merge({}, t, d.en.error.mapping)); var g = d.jsLib.clone(u[a]); g || (g = a.text || a.title ? a : { text: a }, g.title = g.title || b); g.text = g.text.replace(/%%/g, n[0] || "?").replace(/##/g, n[1] || "?"); b = g.noDupes ? function (a) { return a.message.title === g.title } : function (a) { return a.source === l && a.message.text === g.text }; d.jsLib.find(h(), b) || e({ source: l, message: g, container: c.container || c.chart && c.chart.getWrapper() }); this.pushUpdates()
        }; b.prototype.pushUpdates = function () {
            var a =
                this; this.idleDefer.defer("consoleUpdate", function () { return a.exec() }, 100)
        }; b.prototype.exec = function () {
            d.jsLib.each(this.warnings, function (a) { var b = "log"; d.platform.win.console && d.platform.win.console.warn && (b = "warn"); d.platform.win.console[b]("JSCharting Warning: " + a.message.text) }); d.jsLib.each(this.errors, function (a) { var b = "log"; d.platform.win.console && d.platform.win.console.error && (b = "error"); d.platform.win.console[b]("JSCharting Error: " + a.message.text) }); d.jsLib.each(this.logs, function (a) {
                d.platform.win.console.log("JSCharting Log: " +
                    a.message.text)
            }); d.jsLib.each(this.tips, function (a) { d.platform.win.console.log("JSCharting Tip: " + a.message.text) }); this.showNotifications(); this.reset()
        }; b.prototype.showNotifications = function () { function a(a) { d.jsLib.each(e[a], function (c) { var d = c.container; if (d) { var e = b.get(d); e ? (e[a] = e[a] || [], e[a].push(c.message)) : (e = {}, e[a] = [c.message], b.set(d, e), h.push(d)) } }) } var b = new Map, h = [], e = this; a("warnings"); a("errors"); a("tips"); d.jsLib.each(h, function (a) { w(a, b.get(a)) }) }; b.prototype.reset = function () {
            this.warnings =
            []; this.errors = []; this.tips = []
        }; return b
    }(); (function () { d.moduleLoader.registerModule("modules/debug"); var b = new z; d.emitter.on("warning", b.addWarning, b); d.emitter.on("error", b.addError, b); d.emitter.on("log", b.addLog, b); d.emitter.on("tip", b.addTip, b); d.emitter.on("validate", b.validate, b) })()
})(JSC.internal._modules.debug.export);
