<?php

namespace Database\Seeders;

use App\Models\SystemConfig;
use App\Models\Role;
use App\Models\User;
use App\Companies;
use Illuminate\Database\Seeder;
use App\Traits\CompanySeeder;

class UserTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    use CompanySeeder;

    public function run()
    {

        $systemConfig = SystemConfig::first();
        $company = $this->seedCompany($systemConfig);

        $user = User::create([
            'name' => "CAS",
            'email' => 'admin@admin.af',
            'lang' => 'fa',
            'password' => bcrypt('password'),
            'company_id' => $company->id
        ]);
        $user->attachRole(Role::first());

        // $user = User::create([
            // 'name' => "CAS2",
            // 'email' => 'admin@admin.com',
            // 'lang' => 'fa',
            // 'password' => bcrypt('password'),
            // 'company_id' => $company->id
        // ]);
        // $user->attachRole(Role::first());

        // $user = User::create([
            // 'name' => "CAS3",
            // 'email' => 'admin@admin.ch',
            // 'lang' => 'fa',
            // 'password' => bcrypt('password'),
            // 'company_id' => $company->id
        // ]);
        // $user->attachRole(Role::first());


//        $permission = [
//            [
//                'name'      => "Nasir Ahmad",
//                'email'     =>'nasir@nasir.com',
//                'lang'      =>'en',
//                'password'  => bcrypt('nasir'),
//            ],
//            [
//                'name'      => "Omar Najib",
//                'email'     =>'omar@omar.com',
//                'lang'      =>'en',
//                'password'  => bcrypt('omar'),
//            ],
//            [
//                'name'      => "Naser Saljughi",
//                'email'     =>'naser@naser.com',
//                'lang'      =>'en',
//                'password'  => bcrypt('naser'),
//            ],
//            [
//                'name'      => "Bismillah Kakar",
//                'email'     =>'bismillah@bismillah.com',
//                'lang'      =>'en',
//                'password'  => bcrypt('kakar'),
//            ],
//            [
//                'name'      => "Ahmad Shoaib",
//                'email'     =>'shoaib@shoaib.com',
//                'lang'      =>'en',
//                'password'  => bcrypt('shoaib'),
//            ],
//
//        ];

//        foreach ($permission as $key => $value) {
//            $user = User::create($value);
////            $user->attachRole(Role::where('name','admin'));
//        }


    }
}
