<?php

namespace Database\Seeders;

use App\Models\MemberTyp;
use Illuminate\Database\Seeder;

class TypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $types = [
            [
                'type' => 'Customer',
            ],
            [
                'type' => 'Vendor',
            ],
            [
                'type' => 'Employee',
            ],
            [
                'type' => 'Owner',
            ],
             [
                'type' => 'Shareholder',
            ],
             [
                'type' => 'Driver',
            ],
             [
                'type' => 'Supervisor',
            ]
        ];


        foreach ($types as $key => $value) {
			$p1 = (new MemberTyp())->where('type', $value['type'])->first();
            if (!$p1) {
				MemberTyp::create($value);
            }
        }

    }
}
