<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\SystemConfig;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
         $systemConfig = SystemConfig::count();
        if($systemConfig){
            $this->call(PermissionTableSeeder::class);
            $this->call(RoleTableSeeder::class);
            $this->call(UserTableSeeder::class);
            $this->call(TypeTableSeeder::class);
            $this->call(AccountTableSeeder::class);
            $this->call(CurrencyTableSeeder::class);
            $this->call(InventorySiteTableSeeder::class);
            $this->call(ItemExpenseCategoryTableSeeder::class);
            $this->call(MenuTableSeeder::class);
            $this->call(ProjectProgressTableSeeder::class);
            $this->call(WorkTypeTableSeeder::class);
        }else{
           $message = "<div style='margin: auto'><h1 style='color: orangered;'>YOU MUST RUN SYSTEM CONFIG FIRST</h1></div>";
           echo $message;
        }
    }
}
