<?php

namespace Database\Seeders;

use App\Companies;
use App\Models\Currency;
use Illuminate\Database\Seeder;
use Artisan;
use Config;

class CurrencyTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Artisan::call('currency:manage',['action' => 'add', 'currency' => Config::get('currency.default')]);

        $curr = Currency::where('code',Config::get('currency.default'))->first();

        $curr->update([
            'exchange_rate' => 1,
            'static_rate' => 1
			
        ]);

		if(Config::get('currency.default')=='USD'){
			Artisan::call('currency:manage',['action' => 'add', 'currency' => 'AFN']);
		}elseif(Config::get('currency.default')=='AFN'){
			Artisan::call('currency:manage',['action' => 'add', 'currency' => 'USD']);
		}else{
			Artisan::call('currency:manage',['action' => 'add', 'currency' => 'USD']);
		}

		$company = Companies::first();
		if($company){
			\App\Models\Currency::where('id', '>', 0)->update(['static_rate' => 1]);
            $currency = \App\Models\Currency::first();
            $user = \App\Models\User::first();

            if($currency && $user)
            {
                \App\Models\HomeCurrency::create([
                    'company_id'=>$company->id,
                    'currency_id'=>$currency->id,
                    'user_id'=>$user->id,
                ]);
            }
        }





//        Artisan::call('currency:manage',['add'=>'add','ddd'=>'dd']);

//        dd($request->get('currency'));
//        $this->currency->create($request->all());
    }
}
