<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('custom_forms')) {
            Schema::create('custom_forms', function (Blueprint $table) {
                $table->engine = 'InnoDB';
                $table->id();
                $table->string('part_name')->nullable()->index();
                $table->string('column_name')->nullable()->index();
                $table->integer('company_id')->nullable()->index();
                $table->integer('user_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('custom_forms');
    }
};
