<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    { 
        if(!Schema::hasTable('sales_gifts_alert')) {
			Schema::create('sales_gifts_alert', function (Blueprint $table) {
				$table->id();
				$table->integer('sale_id')->nullable()->index();
				$table->integer('sales_gift_id')->nullable()->index();
				$table->integer('gift_sale_id')->nullable()->index();
				$table->integer('sales_info_id')->nullable()->index();
				$table->double('gift_quantity')->nullable();
				$table->string('status')->nullable();
				$table->datetime('date')->nullable();
				$table->timestamps();
			});
		}
    }
     
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_gifts_alert');
    }
};
