<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {    
        if(!Schema::hasTable('sales_gift_details')) {
			Schema::create('sales_gift_details', function (Blueprint $table) {
				$table->id();
				$table->double('from_count')->nullable()->index();
				$table->double('to_count')->nullable()->index();
				$table->double('quantity')->nullable()->index();
				$table->integer('sales_gift_id')->nullable()->index();
				$table->timestamps();
			});
		}

    }
      
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_gift_details');
    }

};
