<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    { 

        if(!Schema::hasTable('sales_gift')) {
			Schema::create('sales_gift', function (Blueprint $table) {
				$table->id();
				$table->integer('number')->nullable();
                $table->datetime('date');
				$table->text('description')->nullable();
				$table->integer('inventory_id')->nullable()->index();
				$table->integer('gift_inventory_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
				$table->integer('user_id')->nullable()->index();
				$table->timestamps();
			});
		}

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_gift');
    }
};
