<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // DB::table('migrations')->where('migration', '2025_02_02_084038_create_member_statement_view')->delete();
		
		try {
			DB::statement("DROP VIEW `member_statement_view`");
		} catch (\Throwable $th) {
			//throw $th;
		}
				
		DB::statement("
            CREATE VIEW member_statement_view AS 
                
            (select loans.id, loans.number AS number, loans.ref_no AS ref_no, if(loans.type='getLoan','p','r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, CONCAT(transactions.remark_fa,' ',loans.description) AS Description, COALESCE(CONCAT(loans.type,loans.category),loans.type) AS Types, COALESCE(CONCAT('loan',loans.category),'loan') AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((loans.date),'%b %d, %Y') as Date, loans.date as dates, loans.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, loans.hour as hour, null AS discount 

            from `members` inner join `loans` on `loans`.`member_id` = `members`.`id` inner join `transactions` on `loans`.`loan_transaction` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select payments.id, payments.number AS number, payments.ref_no AS ref_no, (CASE WHEN payments.type='BillPayment' THEN 'p' WHEN payments.type='RefundBillPayment' THEN 'r' WHEN payments.type='payLoan' THEN 'r' ELSE 'p' END) AS type, members.id AS member_id, members.name as Name, members.phone AS Phone, members.code, accounts.name as Account, (CASE WHEN payments.type='BillPayment' THEN transactions.amount WHEN payments.type='payLoan' THEN transactions.amount ELSE transactions.amount END) AS Amount,transactions.unit as Currency, transactions.rate as Rate, payments.description AS Description, CONCAT(payments.type,'Payment') as Types, COALESCE(CONCAT('payment',payments.type),'payment') AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((payments.date),'%b %d, %Y') as Date, payments.date as dates, payments.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, purchases.number AS purchases_num, purchase_orders.orderNumber AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, payments.hour AS hour, CONCAT(ABS(round(discount_tr.amount,2)),' ',discount_tr.unit) AS discount 

            from `members` inner join `payments` on `members`.`id` = `payments`.`member_id` inner join `transactions` on `payments`.`payable_transaction` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `purchase_payments` on `purchase_payments`.`payment_id` = `payments`.`id` left join `purchases` on `purchases`.`id` = `purchase_payments`.`purchase_id` left join `purchase_orders` on `purchase_orders`.`id` = `purchases`.`order_id` left join `transactions` as `discount_tr` on `payments`.`discount_transaction` = `discount_tr`.`id` 

            where `payments`.`type` != 'WriteCheck' group by `transactions`.`id` order by `members`.`id` asc) 

            union 

            (select payrolls.id, payrolls.id AS number, null AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, payrolls.description AS Description, 'payroll' AS Types, 'payroll' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `payrolls` on `payrolls`.`employee_id` = `members`.`id` left join `salary_details` on `salary_details`.`id` = `payrolls`.`salary_id` inner join `transactions` on `transactions`.`id` = `payrolls`.`payable_transaction` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select employee_payroll_taxes.id, employee_payroll_taxes.id AS number, null AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, '' AS Description, 'payrollTax' AS Types, 'payrollTax' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` left join `employee_payroll_taxes` on `employee_payroll_taxes`.`tax_member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `employee_payroll_taxes`.`transaction_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select receivable_payments.id, receivable_payments.number AS number, receivable_payments.ref_no AS ref_no, (CASE WHEN receivable_payments.type='getLoan' THEN 'p' WHEN receivable_payments.type='Receive' THEN 'r' ELSE 'r' END) AS type, members.id AS member_id, members.name as Name, members.phone AS Phone, members.code, accounts.name as Account, (CASE WHEN receivable_payments.type='getLoan' THEN transactions.amount ELSE if('1'='',transactions.amount*-1,transactions.amount) END) AS Amount, transactions.unit as Currency, transactions.rate as Rate, receivable_payments.description AS Description, CONCAT(receivable_payments.type,'Receive') as Types, COALESCE(CONCAT('receive',receivable_payments.type),'receive') AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((receivable_payments.date),'%b %d, %Y') as Date, receivable_payments.date as dates, receivable_payments.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, sales.number AS purchases_num, purchase_orders.orderNumber AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, receivable_payments.hour AS hour, CONCAT(ABS(round(discount_tr.amount,2)),' ',discount_tr.unit) AS discount 

            from `members` inner join `receivable_payments` on `members`.`id` = `receivable_payments`.`member_id` inner join `transactions` on `receivable_payments`.`receivable_transaction` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `sale_receives` on `sale_receives`.`receivable_payment_id` = `receivable_payments`.`id` left join `sales` on `sales`.`id` = `sale_receives`.`sale_id` left join `purchase_orders` on `purchase_orders`.`prepaid_code` = `receivable_payments`.`number` left join `transactions` as `discount_tr` on `receivable_payments`.`discount_transaction` = `discount_tr`.`id` 

            group by `transactions`.`id` order by `members`.`id` asc) 

            union 

            (select member_exchanges.id, member_exchanges.number as number, member_exchanges.ref_no AS ref_no, if(member_exchanges.type='Payable' ,'p','r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount as Amount, transactions.unit As Currency, transactions.rate AS Rate, member_exchanges.description AS Description, 'MemberExchange' AS Types, 'memberExchange' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((member_exchanges.date),'%b %d, %Y') as Date, member_exchanges.date as dates, member_exchanges.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, member_exchanges.hour AS hour, null AS discount 

            from `members` inner join `member_exchanges` on `member_exchanges`.`member_id` = `members`.`id` inner join `transactions` on `member_exchanges`.`payable_tran_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select member_exchanges.id, member_exchanges.number as number, member_exchanges.ref_no AS ref_no, if(member_exchanges.type='Payable' ,'p','r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount as Amount, transactions.unit As Currency, transactions.rate AS Rate, member_exchanges.description AS Description, 'MemberExchange' AS Types, 'memberExchange' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((member_exchanges.date),'%b %d, %Y') as Date, member_exchanges.date as dates, member_exchanges.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, member_exchanges.hour AS hour, null AS discount 

            from `members` inner join `member_exchanges` on `member_exchanges`.`member_id` = `members`.`id` inner join `transactions` on `member_exchanges`.`receivable_tran_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, if(cheque.type='Receive','r','p') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, cheque.type AS Types, 'cheque' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`member_id` = `members`.`id` inner join `transactions` on `cheque`.`cheque_transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, cheque.type AS Types, 'cheque' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`sender_id` = `members`.`id` inner join `transactions` on `cheque`.`send_reci_transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `cheque`.`type` = 'Send' group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, cheque.type AS Types, 'cheque' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`reciever_id` = `members`.`id` inner join `transactions` on `cheque`.`send_reci_transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `cheque`.`type` = 'Receive' group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, if(cheque.commission_type='BelongsToOtherBranch','p','r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`member_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_recievable_tran_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`sender_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_SR_transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `cheque`.`type` = 'Send' group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`reciever_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_SR_transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `cheque`.`type` = 'Receive' group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, if(cheque.commission_type2='BelongsToOtherBranch','p','r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`member_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_recievable_tran2_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`sender_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_SR_transaction2_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `cheque`.`type` = 'Send' group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`reciever_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_SR_transaction2_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `cheque`.`type` = 'Receive' group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, if(cheque.commission_type3='BelongsToOtherBranch','p','r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`member_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_recievable_tran3_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`sender_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_SR_transaction3_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `cheque`.`type` = 'Send' group by `transactions`.`id`) 

            union 

            (select cheque.id, cheque.number AS number, cheque.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cheque.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cheque.date),'%b %d, %Y') as Date, cheque.date as dates, cheque.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cheque` on `cheque`.`reciever_id` = `members`.`id` inner join `transactions` on `cheque`.`commission_SR_transaction3_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `cheque`.`type` = 'Receive' group by `transactions`.`id`) 

            union 

            (select exchange_broker_cheques.id, exchange_brokers.number AS number, '' AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, exchange_broker_cheques.description AS Description, 'Exchange' AS Types, 'exchange' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((exchange_broker_cheques.date),'%b %d, %Y') as Date, exchange_broker_cheques.date as dates, exchange_broker_cheques.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `exchange_broker_cheques` on `exchange_broker_cheques`.`from_member_id` = `members`.`id` inner join `exchange_brokers` on `exchange_brokers`.`id` = `exchange_broker_cheques`.`exchange_broker_id` inner join `transactions` on `transactions`.`id` = `exchange_broker_cheques`.`from_pay_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select exchange_broker_cheques.id, exchange_brokers.number AS number, '' AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, exchange_broker_cheques.description AS Description, 'Exchange' AS Types, 'exchange' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((exchange_broker_cheques.date),'%b %d, %Y') as Date, exchange_broker_cheques.date as dates, exchange_broker_cheques.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `exchange_broker_cheques` on `exchange_broker_cheques`.`from_member_id` = `members`.`id` inner join `exchange_brokers` on `exchange_brokers`.`id` = `exchange_broker_cheques`.`exchange_broker_id` inner join `transactions` on `transactions`.`id` = `exchange_broker_cheques`.`from_rec_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select exchange_broker_cheques.id, exchange_brokers.number AS number, '' AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, exchange_broker_cheques.description AS Description, 'Exchange' AS Types, 'exchange' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((exchange_broker_cheques.date),'%b %d, %Y') as Date, exchange_broker_cheques.date as dates, exchange_broker_cheques.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `exchange_broker_cheques` on `exchange_broker_cheques`.`to_member_id` = `members`.`id` inner join `exchange_brokers` on `exchange_brokers`.`id` = `exchange_broker_cheques`.`exchange_broker_id` inner join `transactions` on `transactions`.`id` = `exchange_broker_cheques`.`to_pay_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select exchange_broker_cheques.id, exchange_brokers.number AS number, '' AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, exchange_broker_cheques.description AS Description, 'Exchange' AS Types, 'exchange' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((exchange_broker_cheques.date),'%b %d, %Y') as Date, exchange_broker_cheques.date as dates, exchange_broker_cheques.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `exchange_broker_cheques` on `exchange_broker_cheques`.`to_member_id` = `members`.`id` inner join `exchange_brokers` on `exchange_brokers`.`id` = `exchange_broker_cheques`.`exchange_broker_id` inner join `transactions` on `transactions`.`id` = `exchange_broker_cheques`.`to_rec_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select exchange_broker_cheques.id, exchange_brokers.number AS number, '' AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, exchange_broker_cheques.description AS Description, 'ExchangeProfitAndLoss' AS Types, 'exchangeProfitAndLoss' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((exchange_broker_cheques.date),'%b %d, %Y') as Date, exchange_broker_cheques.date as dates, exchange_broker_cheques.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `exchange_broker_cheques` on `exchange_broker_cheques`.`exp_member_id` = `members`.`id` inner join `exchange_brokers` on `exchange_brokers`.`id` = `exchange_broker_cheques`.`exchange_broker_id` inner join `transactions` on `transactions`.`id` = `exchange_broker_cheques`.`member_exp_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select exchange_brokers.id, exchange_brokers.number AS number, '' AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, exchange_brokers.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((exchange_brokers.date),'%b %d, %Y') as Date, exchange_brokers.date as dates, exchange_brokers.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `exchange_brokers` on `exchange_brokers`.`saler_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `exchange_brokers`.`commission_recievable_tran_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select cargo_item_expense.id, cargo_item_expense.number AS number, '' AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cargo_item_expense.description AS Description, 'ItemExpense' AS Types, 'itemExpense' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cargo_item_expense.date),'%b %d, %Y') as Date, cargo_item_expense.date as dates, cargo_item_expense.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cargo_item_expense` on `cargo_item_expense`.`member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `cargo_item_expense`.`receivable_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select cargo_item_expense.id, cargo_item_expense.number AS number, '' AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cargo_item_expense.description AS Description, 'ItemExpense' AS Types, 'itemExpense' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cargo_item_expense.date),'%b %d, %Y') as Date, cargo_item_expense.date as dates, cargo_item_expense.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cargo_item_expense` on `cargo_item_expense`.`member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `cargo_item_expense`.`payable_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select cargo_wastages.id, cargo_wastages.number AS number, '' AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cargo_wastages.description AS Description, 'Wastage' AS Types, 'wastage' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cargo_wastages.date),'%b %d, %Y') as Date, cargo_wastages.date as dates, cargo_wastages.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cargo_wastages` on `cargo_wastages`.`member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `cargo_wastages`.`payable_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select transfer_and_loadings.id, transfer_and_loadings.id AS number, transfer_and_loadings.ref_no AS ref_no, if(fined_drivers.load_type='OverLoad','p','r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, transfer_and_loadings.description AS Description, 'TransferAndLoading' AS Types, 'transferAndLoading' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transfer_and_loadings.date),'%b %d, %Y') as Date, transfer_and_loadings.date as dates, transfer_and_loadings.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `fined_drivers` on `fined_drivers`.`driver_id` = `members`.`id` inner join `transfer_and_loadings` on `transfer_and_loadings`.`id` = `fined_drivers`.`transfer_and_loading_id` inner join `transactions` on `transactions`.`id` = `fined_drivers`.`transaction_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select sales.id, sales.number AS number, sales.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, sales.description AS Description, 'Fined' AS Types, 'fined' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((sales.date),'%b %d, %Y') as Date, sales.date as dates, sales.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `fined_drivers` on `fined_drivers`.`driver_id` = `members`.`id` inner join `sale_infos` on `sale_infos`.`id` = `fined_drivers`.`sale_info_id` inner join `sales` on `sales`.`id` = `sale_infos`.`sale_id` inner join `transactions` on `transactions`.`id` = `fined_drivers`.`transaction_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select payrolls.id, payrolls.id AS number, null AS ref_no, (CASE WHEN item_type_payrolls.type='EmployeeOtherCharge' THEN 'p' WHEN item_type_payrolls.type='CompanyOtherCharge' THEN 'r' ELSE 'p' END) AS type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, concat(item_type_payrolls.name, payrolls.description) AS Description, 'payroll' AS Types, 'payroll' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `payrolls` on `payrolls`.`employee_id` = `members`.`id` left join `salary_details` on `salary_details`.`id` = `payrolls`.`salary_id` left join `payroll_forms` on `payroll_forms`.`payroll_id` = `payrolls`.`id` left join `payroll_price_level_details` on `payroll_price_level_details`.`id` = `payroll_forms`.`price_detail_id` left join `item_type_payrolls` on `payroll_price_level_details`.`item_type_payroll_id` = `item_type_payrolls`.`id` inner join `transactions` on `transactions`.`id` = `payroll_forms`.`payable_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select contract_close_details.id, contracts.contract_no AS number, null AS ref_no, 'p' AS type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, contract_closes.description AS Description, 'Contract' AS Types, 'contract' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((contract_closes.date),'%b %d, %Y') as Date, contract_closes.date as dates, contract_closes.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `contract_close_details` on `contract_close_details`.`shareholder_id` = `members`.`id` left join `contract_closes` on `contract_closes`.`id` = `contract_close_details`.`contract_close_id` left join `contracts` on `contracts`.`id` = `contract_closes`.`contract_id` inner join `transactions` on `transactions`.`id` = `contract_close_details`.`shareholder_transection_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select project_close_details.id, projects.number, null AS ref_no, 'p' AS type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, project_closes.description AS Description, 'Contract' AS Types, 'contract' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((project_closes.date),'%b %d, %Y') as Date, project_closes.date as dates, project_closes.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `project_close_details` on `project_close_details`.`shareholder_id` = `members`.`id` left join `project_closes` on `project_closes`.`id` = `project_close_details`.`project_close_id` left join `projects` on `projects`.`id` = `project_closes`.`project_id` inner join `transactions` on `transactions`.`id` = `project_close_details`.`shareholder_transection_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select vehicle_managements.id AS id, vehicle_managements.code AS number, null AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, vehicle_managements.description AS Description, 'VehicleRent' AS Types, 'vehicleRent' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((vehicle_managements.date),'%b %d, %Y') as Date, vehicle_managements.date as dates, vehicle_managements.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `vehicle_managements` on `vehicle_managements`.`customer_id` = `members`.`id` inner join `transactions` on `vehicle_managements`.`transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `vehicles` on `vehicles`.`id` = `vehicle_managements`.`car_id` 

            group by `transactions`.`id`) 

            union 

            (select cargo_contract.id AS id, cargo_contract.number AS number, cargo_contract.ref_no AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, cargo_contract.description AS Description, 'CargoContract' AS Types, 'cargoContract' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((cargo_contract.date),'%b %d, %Y') as Date, cargo_contract.date as dates, cargo_contract.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `cargo_contract` on `cargo_contract`.`member_id` = `members`.`id` inner join `transactions` on `cargo_contract`.`transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select vehicle_cmr.id AS id, CONCAT(vehicle_cmr.number,' - ',vehicles.palet_number) AS number, vehicle_cmr.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, vehicle_cmr.description AS Description, 'VehicleCMR' AS Types, 'vehicleCMR' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((vehicle_cmr.date),'%b %d, %Y') as Date, vehicle_cmr.date as dates, vehicle_cmr.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `vehicle_cmr` on `vehicle_cmr`.`member_id` = `members`.`id` inner join `vehicle_cmr_details` on `vehicle_cmr_details`.`vehicleCMR_id` = `vehicle_cmr`.`id` inner join `transactions` on `transactions`.`id` = `vehicle_cmr_details`.`transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `vehicles` on `vehicles`.`id` = `vehicle_cmr_details`.`vehicle_id` 

            where `vehicle_cmr`.`driver_account` is null   group by `transactions`.`id`) 

            union 

            (select vehicle_cmr.id AS id, CONCAT(vehicle_cmr.number,' - ',vehicles.palet_number) AS number, vehicle_cmr.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, vehicle_cmr.description AS Description, 'VehicleCMR' AS Types, 'vehicleCMR' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((vehicle_cmr.date),'%b %d, %Y') as Date, vehicle_cmr.date as dates, vehicle_cmr.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `vehicle_cmr_details` on `vehicle_cmr_details`.`driver_id` = `members`.`id` inner join `vehicle_cmr` on `vehicle_cmr`.`id` = `vehicle_cmr_details`.`vehicleCMR_id` inner join `transactions` on `transactions`.`id` = `vehicle_cmr_details`.`transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `vehicles` on `vehicles`.`id` = `vehicle_cmr_details`.`vehicle_id` 

            where `vehicle_cmr`.`driver_account` = 'yes' group by `transactions`.`id`) 

            union 

            (select vehicle_expenses.id AS id, vehicle_expenses.number, vehicle_expenses.ref_number AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, vehicle_expenses.description AS Description, 'VehicleExpenseReturn' AS Types, 'vehicleExpenseReturn' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((vehicle_expenses.date),'%b %d, %Y') as Date, vehicle_expenses.date as dates, vehicle_expenses.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `vehicle_expenses` on `vehicle_expenses`.`vendor_id` = `members`.`id` inner join `transactions` on `vehicle_expenses`.`receive_tran_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `vehicles` on `vehicles`.`id` = `vehicle_expenses`.`vehicle_id` 

            where `vehicle_expenses`.`type` = 'Return' group by `transactions`.`id`) 

            union 

            (select vehicle_expenses.id AS id, vehicle_expenses.number, vehicle_expenses.ref_number AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, vehicle_expenses.description AS Description, 'VehicleExpense' AS Types, 'vehicleExpense' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((vehicle_expenses.date),'%b %d, %Y') as Date, vehicle_expenses.date as dates, vehicle_expenses.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `vehicle_expenses` on `vehicle_expenses`.`vendor_id` = `members`.`id` inner join `transactions` on `vehicle_expenses`.`payable_transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `vehicles` on `vehicles`.`id` = `vehicle_expenses`.`vehicle_id` 

            where `vehicle_expenses`.`type` = 'Expenses' group by `transactions`.`id`) 

            union 

            (select n_pro_order_receive_and_pay.id AS id, n_pro_order_receive_and_pay.number, n_pro_order_receive_and_pay.ref_no AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, n_pro_order_receive_and_pay.description AS Description, 'RequestExpense' AS Types, 'requestExpense' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((n_pro_order_receive_and_pay.date),'%b %d, %Y') as Date, n_pro_order_receive_and_pay.date as dates, n_pro_order_receive_and_pay.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `n_pro_order_receive_and_pay` on `n_pro_order_receive_and_pay`.`vendor_id` = `members`.`id` inner join `transactions` on `n_pro_order_receive_and_pay`.`transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `n_pro_order_receive_and_pay`.`pay_type` = 'bill' group by `transactions`.`id`) 

            union 

            (select adjustments.id, adjustments.ref_no AS number, adjustments.ref_no AS ref_no, if(adjustments.type='adjustment','r','p') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount, transactions.unit as Currency, transactions.rate AS Rate, adjustments.description AS Description, 'adjustment' AS Types, 'adjustment' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((adjustments.date),'%b %d, %Y') as Date, adjustments.date as dates, adjustments.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `adjustment_transaction_details` on `adjustment_transaction_details`.`member_id` = `members`.`id` inner join `adjustments` on `adjustments`.`id` = `adjustment_transaction_details`.`adjustment_id` inner join `transactions` on `transactions`.`id` = `adjustment_transaction_details`.`transaction_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `adjustments`.`type` = 'adjustment' group by `transactions`.`id`) 

            union 

            (select sales.id AS id, sales.number AS number, sales.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, sales.description AS Description, 'Taxation' AS Types, 'taxation' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((sales.date),'%b %d, %Y') as Date, sales.date as dates, sales.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, sale_areas.name AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `sale_taxations` on `sale_taxations`.`customer_id` = `members`.`id` inner join `sales` on `sales`.`id` = `sale_taxations`.`sale_id` inner join `transactions` on `transactions`.`id` = `sale_taxations`.`customer_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `sale_areas` on `sale_areas`.`id` = `sales`.`sale_area_id` 

            group by `transactions`.`id`) 

            union 

            (select fixed_asset_management.id, fixed_asset_management.number as number, null AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount as Amount, transactions.unit As Currency, transactions.rate AS Rate, fixed_asset_management.description AS Description, 'FixedAsset' AS Types, 'fixedAsset' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((fixed_asset_management.date),'%b %d, %Y') as Date, fixed_asset_management.date as dates, fixed_asset_management.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `fixed_asset_management` on `fixed_asset_management`.`vendor_id` = `members`.`id` inner join `transactions` on `fixed_asset_management`.`payable_transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select fix_asset_sales.id, fix_asset_sales.number as number, null AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount as Amount, transactions.unit As Currency, transactions.rate AS Rate, fix_asset_sales.description AS Description, 'FixedAsset' AS Types, 'fixedAsset' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((fix_asset_sales.date),'%b %d, %Y') as Date, fix_asset_sales.date as dates, fix_asset_sales.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `fix_asset_sales` on `fix_asset_sales`.`customer_id` = `members`.`id` inner join `transactions` on `fix_asset_sales`.`receivable_transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select sales.id AS id, sales.number AS number, sales.ref_no AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, sales.description AS Description, 'Taxation' AS Types, 'taxation' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((sales.date),'%b %d, %Y') as Date, sales.date as dates, sales.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, sale_areas.name AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `sale_taxations` on `sale_taxations`.`vendor_id` = `members`.`id` inner join `sales` on `sales`.`id` = `sale_taxations`.`sale_id` inner join `transactions` on `transactions`.`id` = `sale_taxations`.`vendor_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `sale_areas` on `sale_areas`.`id` = `sales`.`sale_area_id` 

            group by `transactions`.`id`) 

            union 

            (select sales.id AS id, sales.number AS number, sales.ref_no AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, sales.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((sales.date),'%b %d, %Y') as Date, sales.date as dates, sales.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, sale_areas.name AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `sale_commissions` on `sale_commissions`.`vendor_id` = `members`.`id` inner join `sales` on `sales`.`id` = `sale_commissions`.`sale_id` inner join `transactions` on `transactions`.`id` = `sale_commissions`.`vendor_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `sale_areas` on `sale_areas`.`id` = `sales`.`sale_area_id` 

            group by `transactions`.`id`) 

            union 

            (select sales.id AS id, sales.number AS number, sales.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, sales.description AS Description, 'Commission' AS Types, 'commission' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((sales.date),'%b %d, %Y') as Date, sales.date as dates, sales.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, sale_areas.name AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `sale_commissions` on `sale_commissions`.`customer_id` = `members`.`id` inner join `sales` on `sales`.`id` = `sale_commissions`.`sale_id` inner join `transactions` on `transactions`.`id` = `sale_commissions`.`customer_transaction_id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `sale_areas` on `sale_areas`.`id` = `sales`.`sale_area_id` 

            group by `transactions`.`id`) 

            union 

            (select sale_transfer_rents.id, sale_transfer_rents.id AS number, '' AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, sale_transfer_rents.description AS Description, 'TransferRent' AS Types, 'transferRent' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `sale_transfer_rents` on `sale_transfer_rents`.`receivable_member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `sale_transfer_rents`.`receivable_transaction` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select sale_transfer_rents.id, sale_transfer_rents.id AS number, '' AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, sale_transfer_rents.description AS Description, 'TransferRent' AS Types, 'transferRent' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `sale_transfer_rents` on `sale_transfer_rents`.`payable_member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `sale_transfer_rents`.`payable_transaction` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select employee_assessments.id, employee_assessments.number as number, employee_assessments.code as ref_no, IF(employee_assessments.type ='rewards','p', 'r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, employee_assessments.description AS Description, employee_assessments.type AS Types, 'employeeAssessments' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `employee_assessments` on `employee_assessments`.`employee_id` = `members`.`id` left join `employee_assessment_categories` on `employee_assessment_categories`.`id` = `employee_assessments`.`assessment_category_id` left join `transactions` on `transactions`.`id` = `employee_assessments`.`member_transaction` left join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `transactions`.`amount` > 0 group by `transactions`.`id`) 

            union 

            (select rewards.id, rewards.number as number, null as ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, rewards.description AS Description, 'Reward' AS Types, 'reward' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `rewards` on `rewards`.`employee_id` = `members`.`id` left join `transactions` on `transactions`.`id` = `rewards`.`payable_transaction_id` left join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `transactions`.`amount` > 0 group by `transactions`.`id`) 

            union 

            (select purchases.id, if(purchases.type='BillExpense',IFNULL(item_expenses.part_number,purchases.expense_number), if(purchases.type = 'MemberTransfer',purchases.member_transfer_number, if(purchases.type = 'grn',purchases.grn_number,purchases.number))) as number, purchases.ref_no AS ref_no, if(purchases.type='Bill' OR purchases.type='grn' OR purchases.type='BillRoll' OR purchases.type='CustomerPrepaid' OR purchases.type='OpeningBalance' OR purchases.type='BillExpense' OR purchases.type='MemberTransfer' OR purchases.type='JournalEntry' OR purchases.type='Rent','p','r') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account, transactions.amount as Amount, transactions.unit As Currency, transactions.rate AS Rate, purchases.description AS Description, purchases.type AS Types, 'purchases' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((purchases.date),'%b %d, %Y') as Date, purchases.date as dates, purchases.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, purchase_orders.orderNumber AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, purchases.hour AS hour, null AS discount 

            from `members` inner join `purchases` on `purchases`.`vendor_id` = `members`.`id` inner join `transactions` on `purchases`.`transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `purchase_orders` on `purchase_orders`.`id` = `purchases`.`order_id` left join `item_expenses` on `item_expenses`.`purchase_id` = `purchases`.`id` 

            where `purchases`.`type` != 'WriteCheck' and `purchases`.`type` != 'WriteCheckExpense' group by `transactions`.`id`) 

            union 

            (select sales.id AS id, if(sales.type = 'MemberTransfer',sales.member_transfer_number,sales.number) as number, sales.ref_no AS ref_no, if(sales.type='Invoice' OR sales.type='InvoiceRoll' OR sales.type='OpeningBalance' OR sales.type='MemberTransfer' OR sales.type='JournalEntry' OR sales.type='ProjectInvoice' OR sales.type='saleByType','r','p') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, sales.description AS Description, sales.type AS Types, 'sales' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((sales.date),'%b %d, %Y') as Date, sales.date as dates, sales.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, sale_areas.name AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, sales.hour AS hour, null AS discount 

            from `members` inner join `sales` on `sales`.`member_id` = `members`.`id` inner join `transactions` on `sales`.`transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` left join `sale_areas` on `sale_areas`.`id` = `sales`.`sale_area_id` 

            where `sales`.`type` != 'SalesReceipt' group by `transactions`.`id`) 

            union 

            (select refunds.id, refunds.number AS number, refunds.ref_no AS ref_no, if(refunds.change_account='yes','r','p') as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, refunds.description AS Description, 'refund' AS Types, 'refund' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((refunds.date),'%b %d, %Y') as Date, refunds.date as dates, refunds.date AS sort_date,  if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `refunds` on `refunds`.`member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `refunds`.`transaction_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `refunds`.`type` in ('Invoice', 'InvoiceRoll') group by `transactions`.`id`) 

            union 

            (select return_backs.id, return_backs.number AS number, return_backs.ref_no AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, return_backs.description AS Description, 'return_backs' AS Types, 'returnBacks' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((return_backs.date),'%b %d, %Y') as Date, return_backs.date as dates, return_backs.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `return_backs` on `return_backs`.`member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `return_backs`.`transaction_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `return_backs`.`type` in ('Bill', 'BillRoll')   group by `transactions`.`id`) 

            union 

            (select branch_transfers.id, branch_transfers.id AS number, branch_transfers.ref_no AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, branch_transfers.description AS Description, 'branchTransfer' AS Types, 'branchTransfer' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `branch_transfers` on `branch_transfers`.`from_member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `branch_transfers`.`receivable_transaction_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`) 

            union 

            (select branch_transfers.id, branch_transfers.id AS number, branch_transfers.ref_no AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name AS Account, transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, branch_transfers.description AS Description, 'branchTransfer' AS Types, 'branchTransfer' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((transactions.date),'%b %d, %Y') as Date, transactions.date as dates, transactions.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `branch_transfers` on `branch_transfers`.`to_member_id` = `members`.`id` inner join `transactions` on `transactions`.`id` = `branch_transfers`.`payable_transaction_id` inner join `accounts` on `accounts`.`id` = `transactions`.`account_id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            group by `transactions`.`id`)

            union 

            (select return_expense.id, return_expense.number, null AS ref_no, 'r' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, return_expense.description AS Description, 'ReturnExpense' AS Types, 'returnExpense' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((return_expense.date),'%b %d, %Y') as Date, return_expense.date as dates, return_expense.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, 0 AS hour, null AS discount 

            from `members` inner join `return_expense` on `return_expense`.`vendor_id` = `members`.`id` inner join `transactions` on `return_expense`.`transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `return_expense`.`type` = 'BillExpense'  group by `transactions`.`id`)

            union 

            (select customs_expenses.id, customs_expenses.number, customs_expenses.ref_number AS ref_no, 'p' as type, members.id AS member_id, members.name AS Name, members.phone AS Phone, members.code, accounts.name as Account,transactions.amount As Amount,transactions.unit as Currency, transactions.rate AS Rate, customs_expenses.description AS Description, 'CustomsExpense' AS Types, 'customsExpense' AS table_type, member_classes.id AS class_id, transport_companies.id AS  tcompany_id, GROUP_CONCAT(member_typs.type) AS type_name, transactions.class_id AS financialClassId, members.identify_type AS identify_type, date_format((customs_expenses.date),'%b %d, %Y') as Date, customs_expenses.date as dates, customs_expenses.date AS sort_date, if(system_configs.static_rate=1,((IFNUll(transactions.amount,0)*transactions.rate)/IFNUll(transactions.static_rate,1)), (IFNUll(transactions.amount,0)/transactions.rate)) AS exchanged_amount, IFNUll(transactions.static_rate,1) AS static_rate, member_classes.name AS className, null AS purchases_num, null AS orderNumber, null AS areaName, member_informations.city, member_informations.address1, transactions.id as transaction_id, members.company_id, transactions.checkout, null AS items, customs_expenses.hour, null AS discount 

            from `members` inner join `customs_expenses` on `customs_expenses`.`vendor_id` = `members`.`id` inner join `transactions` on `customs_expenses`.`transaction_id` = `transactions`.`id` inner join `accounts` on `transactions`.`account_id` = `accounts`.`id` inner join `companies` on `companies`.`id` = `members`.`company_id` inner join `system_configs` on `system_configs`.`id` = `companies`.`system_config_id` inner join `member_member_type` on `member_member_type`.`member_id` = `members`.`id` inner join `member_typs` on `member_typs`.`id` = `member_member_type`.`member_type_id` left join `member_informations` on `member_informations`.`member_id` = `members`.`id` left join `member_classes` on `member_classes`.`id` = `member_informations`.`class_id` left join `transport_companies` on `transport_companies`.`id` = `member_informations`.`transport_company_id` 

            where `customs_expenses`.`expense_type` = 'bill'  group by `transactions`.`id`)
            
		");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        try {
			DB::statement("DROP VIEW `member_statement_view`");
		} catch (\Throwable $th) {
			//throw $th;
		}
    }
};
