<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('finger_attendance_temp')){
            Schema::create('finger_attendance_temp', function (Blueprint $table) {
				$table->engine = 'InnoDB';
                $table->id();
				$table->integer('member_id')->nullable()->index();
                $table->datetime('date');
				$table->integer('financial_class_id')->nullable()->index();
				$table->integer('user_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('finger_attendance_temp');
    }
};
