<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
  
        if(!Schema::hasTable('sales_expense_info')) {
            Schema::create('sales_expense_info', function (Blueprint $table) {
                $table->engine = 'InnoDB';
                $table->bigIncrements('id');
				$table->string('name')->nullable();
				$table->double('amount')->nullable();
				// $table->string('currency')->nullable();
				// $table->double('rate')->nullable();
				$table->datetime('date')->nullable();
				$table->integer('register_account')->nullable();
				$table->text('description')->nullable();
				$table->integer('sale_id')->nullable()->index(); 
                $table->timestamps();
            });
        }

        
        
        if(Schema::hasTable('offer_cycle_memoes')) {
            Schema::table('offer_cycle_memoes', function (Blueprint $table) {
                if (Schema::hasColumn('offer_cycle_memoes','offer_id') && !DB::select(DB::raw("SHOW INDEXES FROM offer_cycle_memoes WHERE key_name='offer_cycle_memoes_offer_id_index'"))) {
                    $table->index('offer_id');
                } 
                if (Schema::hasColumn('offer_cycle_memoes','position_id') && !DB::select(DB::raw("SHOW INDEXES FROM offer_cycle_memoes WHERE key_name='offer_cycle_memoes_position_id_index'"))) {
                    $table->index('position_id');
                }
                if (Schema::hasColumn('offer_cycle_memoes','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM offer_cycle_memoes WHERE key_name='offer_cycle_memoes_parent_id_index'"))) {
                    $table->index('parent_id');
                } 
                if (Schema::hasColumn('offer_cycle_memoes','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM offer_cycle_memoes WHERE key_name='offer_cycle_memoes_user_id_index'"))) {
                    $table->index('user_id');
                } 
                if (Schema::hasColumn('offer_cycle_memoes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM offer_cycle_memoes WHERE key_name='offer_cycle_memoes_company_id_index'"))) {
                    $table->index('company_id');
                } 
            });
        }
        
        
    
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_expense_info');
    }
};
