<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {		
		if(!Schema::hasTable('offer_class')) {
			Schema::create('offer_class', function (Blueprint $table) {	
                $table->engine = 'InnoDB';
				$table->id();
				$table->string('name')->nullable();
				$table->text('description')->nullable();
				$table->integer('user_id')->unsigned()->nullable();
				$table->integer('company_id')->unsigned()->nullable();
				$table->timestamps();
			});
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offer_class');
    }
};
