<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('opening_rate')) {
			Schema::create('opening_rate', function (Blueprint $table) {	
                $table->engine = 'InnoDB';
				$table->id();
				$table->string('currency')->index();
				$table->datetime('date')->index();
				$table->double('rate')->nullable();
				$table->double('Static_rate')->nullable();
				$table->integer('company_id')->nullable()->index();
				$table->integer('user_id')->nullable()->index();
				$table->timestamps();
			});
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('opening_rate');
    }
};
