<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('delivery_fix_asset')) {
			Schema::create('delivery_fix_asset', function (Blueprint $table) {	
                $table->engine = 'InnoDB';
				$table->id();
				$table->integer('fixed_asset_id')->nullable();
				$table->string('number')->nullable();
				$table->integer('employee_id')->nullable();
				$table->datetime('date')->nullable();
				$table->text('description')->nullable();
				$table->string('delivery_type')->nullable();
				$table->integer('user_id')->unsigned()->nullable();
				$table->integer('company_id')->unsigned()->nullable();
				$table->timestamps();
			});
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery_fix_asset');
    }
};
