<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('offers')) {
			Schema::create('offers', function (Blueprint $table) {	
                $table->engine = 'InnoDB';
				$table->id();
				$table->integer('number');
                $table->datetime('date');
				$table->string('code')->nullable();
				$table->string('title')->nullable();
                $table->text('description')->nullable();
				$table->integer('company_id')->nullable()->index();
				$table->integer('user_id')->nullable()->index();
				$table->timestamps();
			});
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offers');
    }
};
