<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('member_shareholders')) {
			Schema::create('member_shareholders', function (Blueprint $table) {	
        $table->engine = 'InnoDB';
				$table->id();
				$table->integer('member_id')->nullable()->index();
				$table->string('shareholder_name')->nullable();
				$table->string('shareholder_fathername')->nullable();
				$table->string('shareholder_address')->nullable();
				$table->string('shareholder_phone_number')->nullable();
				$table->string('shareholder_email')->nullable();
				$table->string('shareholder_passport_number')->nullable();
				$table->integer('company_id')->nullable()->index();
				$table->integer('user_id')->nullable()->index();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_shareholders');
    }
};
