<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('position_currencies')) {
			Schema::create('position_currencies', function (Blueprint $table) {
				$table->engine = 'InnoDB';
				$table->id();
				$table->string('currency')->index();
				$table->double('amount')->nullable();
				$table->integer('position_id')->index();
				$table->integer('company_id')->nullable()->index();
				$table->timestamps();
			});
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('position_currencies');
    }
};
