<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('member_risk_steps')) {
			Schema::create('member_risk_steps', function (Blueprint $table) {
				$table->engine = 'InnoDB';
				$table->id();
				$table->integer('member_id')->nullable()->index();
				$table->integer('risk_step_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
				$table->timestamps();
			});
        }

        Schema::table('members', function (Blueprint $table) {
            if (!Schema::hasColumn('members','risk_percentage')){
				$table->double('risk_percentage')->nullable();
				$table->string('risk_step')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_risk_steps');
    }
};
