<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('risk_steps')) {
			Schema::create('risk_steps', function (Blueprint $table) {
				$table->engine = 'InnoDB';
				$table->id();
				$table->string('name')->index();
				$table->double('percentage');
				$table->string('category')->nullable();
				$table->string('description')->nullable();
				$table->integer('user_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
				$table->timestamps();
			});
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('risk_steps');
    }
};
