<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            if (!Schema::hasColumn('loans','trans_type')){
				$table->string('trans_type')->nullable();
				$table->string('monetary_source')->nullable();
				$table->string('position_status', 20)->nullable();
				$table->text('position_description')->nullable();
            }
        });

        Schema::table('cheque', function (Blueprint $table) {
            if (!Schema::hasColumn('cheque','trans_type')){
				$table->string('trans_type')->nullable();
				$table->string('position_status', 20)->nullable();
				$table->text('position_description')->nullable();
            }
        });

        Schema::table('currency_exchanges', function (Blueprint $table) {
            if (!Schema::hasColumn('currency_exchanges','trans_type')){
				$table->string('trans_type')->nullable();
				$table->string('position_status', 20)->nullable();
				$table->text('position_description')->nullable();
            }
        });
        
        Schema::table('exchange_brokers', function (Blueprint $table) {
            if (!Schema::hasColumn('exchange_brokers','trans_type')){
				$table->string('trans_type')->nullable();
				$table->string('monetary_source')->nullable();
				$table->string('position_status', 20)->nullable();
				$table->text('position_description')->nullable();
            }
        });
        
        Schema::table('transfer_accounts', function (Blueprint $table) {
            if (!Schema::hasColumn('transfer_accounts','trans_type')){
				$table->string('trans_type')->nullable();
				$table->string('monetary_source')->nullable();
				$table->string('position_status', 20)->nullable();
				$table->text('position_description')->nullable();
            }
        });
        
        Schema::table('member_transfers', function (Blueprint $table) {
            if (!Schema::hasColumn('member_transfers','trans_type')){
				$table->string('trans_type')->nullable();
				$table->string('monetary_source')->nullable();
				$table->string('position_status', 20)->nullable();
				$table->text('position_description')->nullable();
            }
        });
        
        Schema::table('member_exchanges', function (Blueprint $table) {
            if (!Schema::hasColumn('member_exchanges','trans_type')){
				$table->string('trans_type')->nullable();
				$table->string('monetary_source')->nullable();
				$table->string('position_status', 20)->nullable();
				$table->text('position_description')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            //
        });
    }
};
