<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_wishlist_item')) {
			Schema::connection('mysqlOnline')->create('online_wishlist_item',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('item_id');
				$table->integer('session_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('online_wishlist_item');
    }
};
