<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('static_item_price_details')){
            Schema::create('static_item_price_details', function (Blueprint $table) {
                $table->id();
                $table->integer('static_item_price_id')->unsigned()->index();
                $table->integer('item_id')->unsigned()->index();
                $table->string('currency')->nullable();
                $table->double('amount')->nullable();
                $table->integer('company_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('static_item_price_details');
    }
};
