<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('static_item_prices')){
            Schema::create('static_item_prices', function (Blueprint $table) {
                $table->id();
                $table->integer('inventory_category_id')->unsigned()->nullable();
                $table->text('description')->nullable();
                $table->datetime('date');
                $table->integer('company_id')->nullable()->index();
                $table->integer('user_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('static_item_prices');
    }
};
