<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customs_expenses', function (Blueprint $table) {
            if(!Schema::hasColumn('customs_expenses' ,'measure_id')){
                $table->integer('measure_id')->nullable()->index();
                $table->integer('vendor_id')->nullable()->index();
                $table->integer('expense_category_id')->nullable()->index();
                $table->integer('gain_loss_tran_id')->nullable()->index();
                $table->string('expense_type')->nullable();
                $table->string('option_currency')->nullable();
                $table->double('option_rate')->nullable();
                $table->double('customs_amount1')->nullable();
				$table->double('customs_percent1')->nullable();
				$table->double('tax_percent1')->nullable();
				$table->double('helal_ahmar_percent1')->nullable();
                $table->time('hour')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customs_expenses', function (Blueprint $table) {
            //
        });
    }
};
