<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('linked_devices')) {
            Schema::create('linked_devices', function (Blueprint $table) {
                $table->id();
                $table->string('number');
                $table->string('device_id')->nullable();
                $table->string('device_type')->nullable();
                $table->string('device_version')->nullable();
                $table->string('device_model')->nullable();
                $table->boolean('is_physical_device')->nullable();
                $table->integer('company_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('linked_devices');
    }
};
