<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('currencies', function (Blueprint $table) {
            if(!Schema::hasColumn('currencies' ,'static_rate')){
                $table->double('static_rate')->nullable()->default(1);
            }
        });
        Schema::table('transactions', function (Blueprint $table) {
            if(!Schema::hasColumn('transactions' ,'static_rate')){
                $table->double('static_rate')->nullable()->default(1);
            }
        });
        Schema::table('system_configs', function (Blueprint $table) {
            if(!Schema::hasColumn('system_configs' ,'static_rate')){
                $table->integer('static_rate')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('currencies', function (Blueprint $table) {
            //
        });
    }
};
