<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customs_expense_options', function (Blueprint $table) {
            if(!Schema::hasColumn('customs_expense_options' ,'inventory_category_id')){
                $table->integer('inventory_category_id')->nullable()->index();
            }
        });

        Schema::table('customs_expenses', function (Blueprint $table) {
            if(!Schema::hasColumn('customs_expenses' ,'inventory_category_id')){
                $table->integer('inventory_category_id')->nullable()->index();
                $table->integer('customs_option_id')->nullable()->index();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customs_expense_options', function (Blueprint $table) {
            //
        });
    }
};
