<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('budget_details')) {
            Schema::create('budget_details', function (Blueprint $table) {
                $table->id();
                $table->integer('budget_id')->index(); 
                $table->integer('account_id')->index(); 
                $table->string('period_year')->nullable(); 
                $table->integer('period_month')->nullable(); 
                $table->double('amount')->nullable(); 
                $table->integer('company_id')->nullable()->index();
                $table->integer('user_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('budget_details');
    }
};
