<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if(!Schema::hasTable('budgets')) {
            Schema::create('budgets', function (Blueprint $table) {
                $table->id();
                $table->string('name')->nullable(); 
                $table->string('type'); 
                $table->string('period_type')->nullable(); 
                $table->string('period_year')->nullable(); 
                $table->integer('period_begin')->nullable(); 
                $table->datetime('date')->nullable();
                $table->text('description')->nullable();
                $table->integer('company_id')->nullable()->index();
                $table->integer('user_id')->nullable()->index();
                $table->timestamps();
            });
        }


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('budgets');
    }
};
