<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('contract_payroll_percent')) {
            Schema::create('contract_payroll_percent', function (Blueprint $table) {
                $table->id();
                $table->double('percentage')->nullable(); 
                $table->integer('contract_id')->nullable()->index();
                $table->integer('payroll_id')->nullable()->index();
                $table->integer('company_id')->nullable()->index();
                $table->integer('user_id')->nullable()->index();
                $table->timestamps();
            });
        }

        Schema::table('payrolls', function (Blueprint $table) {
            if(!Schema::hasColumn('payrolls' ,'contract_percentage')){
                $table->string('contract_percentage')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contract_payroll_percent');
    }
};
